/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.core.config.IngredientSortStage;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.ingredients.IListElementInfo;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.RegisteredIngredients;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class IngredientSorterComparators {
    private final IngredientFilter ingredientFilter;
    private final RegisteredIngredients registeredIngredients;
    private final ModNameSortingConfig modNameSortingConfig;
    private final IngredientTypeSortingConfig ingredientTypeSortingConfig;

    public IngredientSorterComparators(IngredientFilter ingredientFilter, RegisteredIngredients registeredIngredients, ModNameSortingConfig modNameSortingConfig, IngredientTypeSortingConfig ingredientTypeSortingConfig) {
        this.ingredientFilter = ingredientFilter;
        this.registeredIngredients = registeredIngredients;
        this.modNameSortingConfig = modNameSortingConfig;
        this.ingredientTypeSortingConfig = ingredientTypeSortingConfig;
    }

    public Comparator<IListElementInfo<?>> getComparator(List<IngredientSortStage> ingredientSorterStages) {
        return ingredientSorterStages.stream().map(this::getComparator).reduce(Comparator::thenComparing).orElseGet(this::getDefault);
    }

    public Comparator<IListElementInfo<?>> getComparator(IngredientSortStage ingredientSortStage) {
        return switch (ingredientSortStage) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientSortStage.ALPHABETICAL -> IngredientSorterComparators.getAlphabeticalComparator();
            case IngredientSortStage.CREATIVE_MENU -> IngredientSorterComparators.getCreativeMenuComparator();
            case IngredientSortStage.INGREDIENT_TYPE -> this.getIngredientTypeComparator();
            case IngredientSortStage.MOD_NAME -> this.getModNameComparator();
            case IngredientSortStage.TOOL_TYPE -> IngredientSorterComparators.getToolsComparator();
            case IngredientSortStage.TAG -> this.getTagComparator();
            case IngredientSortStage.WEAPON_DAMAGE -> IngredientSorterComparators.getWeaponDamageComparator();
            case IngredientSortStage.ARMOR -> IngredientSorterComparators.getArmorComparator();
            case IngredientSortStage.MAX_DURABILITY -> IngredientSorterComparators.getMaxDurabilityComparator();
        };
    }

    public Comparator<IListElementInfo<?>> getDefault() {
        return this.getModNameComparator().thenComparing(this.getIngredientTypeComparator()).thenComparing(IngredientSorterComparators.getCreativeMenuComparator());
    }

    private static Comparator<IListElementInfo<?>> getCreativeMenuComparator() {
        return Comparator.comparingInt(o -> {
            IListElement element = o.getElement();
            return element.getOrderIndex();
        });
    }

    private static Comparator<IListElementInfo<?>> getAlphabeticalComparator() {
        return Comparator.comparing(IListElementInfo::getName);
    }

    private Comparator<IListElementInfo<?>> getModNameComparator() {
        Set<String> modNames = this.ingredientFilter.getModNamesForSorting();
        return this.modNameSortingConfig.getComparatorFromMappedValues(modNames);
    }

    private Comparator<IListElementInfo<?>> getIngredientTypeComparator() {
        List<IIngredientType<?>> ingredientTypes = this.registeredIngredients.getIngredientTypes();
        Set ingredientTypeStrings = ingredientTypes.stream().map(IngredientTypeSortingConfig::getIngredientTypeString).collect(Collectors.toSet());
        return this.ingredientTypeSortingConfig.getComparatorFromMappedValues(ingredientTypeStrings);
    }

    private static Comparator<IListElementInfo<?>> getMaxDurabilityComparator() {
        Comparator<IListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getItemStack(o).m_41776_());
        return maxDamage.reversed();
    }

    private Comparator<IListElementInfo<?>> getTagComparator() {
        Comparator<IListElementInfo> isTagged = Comparator.comparing(this::hasTag);
        Comparator<IListElementInfo> tag = Comparator.comparing(this::getTagForSorting);
        return isTagged.reversed().thenComparing(tag);
    }

    private static Comparator<IListElementInfo<?>> getToolsComparator() {
        Comparator<IListElementInfo> toolType = Comparator.comparing(o -> IngredientSorterComparators.getToolClass(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> tier = Comparator.comparing(o -> IngredientSorterComparators.getTier(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getToolDurability(IngredientSorterComparators.getItemStack(o)));
        return toolType.reversed().thenComparing(tier.reversed()).thenComparing(maxDamage.reversed());
    }

    private static Comparator<IListElementInfo<?>> getWeaponDamageComparator() {
        Comparator<IListElementInfo> isWeaponComp = Comparator.comparing(o -> IngredientSorterComparators.isWeapon(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> attackDamage = Comparator.comparing(o -> IngredientSorterComparators.getWeaponDamage(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> attackSpeed = Comparator.comparing(o -> IngredientSorterComparators.getWeaponSpeed(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getWeaponDurability(IngredientSorterComparators.getItemStack(o)));
        return isWeaponComp.reversed().thenComparing(attackDamage.reversed()).thenComparing(attackSpeed.reversed()).thenComparing(maxDamage.reversed());
    }

    private static Comparator<IListElementInfo<?>> getArmorComparator() {
        Comparator<IListElementInfo> isArmorComp = Comparator.comparing(o -> IngredientSorterComparators.isArmor(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> armorSlot = Comparator.comparing(o -> IngredientSorterComparators.getArmorSlotIndex(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> armorDamage = Comparator.comparing(o -> IngredientSorterComparators.getArmorDamageReduce(IngredientSorterComparators.getItemStack(o)));
        Comparator<IListElementInfo> armorToughness = Comparator.comparing(o -> Float.valueOf(IngredientSorterComparators.getArmorToughness(IngredientSorterComparators.getItemStack(o))));
        Comparator<IListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorterComparators.getArmorDurability(IngredientSorterComparators.getItemStack(o)));
        return isArmorComp.reversed().thenComparing(armorSlot.reversed()).thenComparing(armorDamage.reversed()).thenComparing(armorToughness.reversed()).thenComparing(maxDamage.reversed());
    }

    private static int getTier(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.m_43314_();
            List sortedTiers = TierSortingRegistry.getSortedTiers();
            return sortedTiers.indexOf(tier);
        }
        return -1;
    }

    private static boolean isTool(ItemStack itemStack) {
        return IngredientSorterComparators.getToolActions(itemStack).stream().anyMatch(arg_0 -> ((ItemStack)itemStack).canPerformAction(arg_0));
    }

    private static int getToolDurability(ItemStack itemStack) {
        if (!IngredientSorterComparators.isTool(itemStack)) {
            return 0;
        }
        return itemStack.m_41776_();
    }

    private static boolean isWeapon(ItemStack itemStack) {
        return IngredientSorterComparators.getWeaponDamage(itemStack) > 0.0;
    }

    private static double getWeaponDamage(ItemStack itemStack) {
        if (IngredientSorterComparators.isTool(itemStack) || IngredientSorterComparators.isArmor(itemStack)) {
            return 0.0;
        }
        Multimap multimap = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        return IngredientSorterComparators.max((Multimap<Attribute, AttributeModifier>)multimap, Attributes.f_22281_);
    }

    private static double getWeaponSpeed(ItemStack itemStack) {
        if (!IngredientSorterComparators.isWeapon(itemStack)) {
            return 0.0;
        }
        Multimap multimap = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        return IngredientSorterComparators.max((Multimap<Attribute, AttributeModifier>)multimap, Attributes.f_22283_);
    }

    private static double max(Multimap<Attribute, AttributeModifier> multimap, Attribute attribute) {
        Collection modifiers = multimap.get((Object)attribute);
        return IngredientSorterComparators.max(modifiers);
    }

    private static double max(Collection<AttributeModifier> modifiers) {
        return modifiers.stream().mapToDouble(AttributeModifier::m_22218_).max().orElse(0.0);
    }

    private static int getWeaponDurability(ItemStack itemStack) {
        if (IngredientSorterComparators.isWeapon(itemStack)) {
            return itemStack.m_41776_();
        }
        return 0;
    }

    private static boolean isArmor(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item instanceof ArmorItem;
    }

    private static int getArmorSlotIndex(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40402_().m_20750_();
        }
        return 0;
    }

    private static int getArmorDamageReduce(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40404_();
        }
        return 0;
    }

    private static float getArmorToughness(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40405_();
        }
        return 0.0f;
    }

    private static int getArmorDurability(ItemStack itemStack) {
        if (IngredientSorterComparators.isArmor(itemStack)) {
            return itemStack.m_41776_();
        }
        return 0;
    }

    private String getTagForSorting(IListElementInfo<?> elementInfo) {
        Collection<ResourceLocation> tagIds = elementInfo.getTagIds(this.registeredIngredients);
        return tagIds.stream().max(Comparator.comparing(IngredientSorterComparators::tagCount)).map(ResourceLocation::m_135815_).orElse("");
    }

    private static int tagCount(ResourceLocation tagId) {
        if (tagId.toString().equals("itemfilters:check_nbt")) {
            return 0;
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tagId);
        return Registry.f_122827_.m_203431_(tagKey).map(HolderSet.ListBacked::m_203632_).orElse(0);
    }

    private boolean hasTag(IListElementInfo<?> elementInfo) {
        return !this.getTagForSorting(elementInfo).isEmpty();
    }

    private static String getToolClass(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return "";
        }
        return IngredientSorterComparators.getToolActions(itemStack).stream().filter(arg_0 -> ((ItemStack)itemStack).canPerformAction(arg_0)).findFirst().map(ToolAction::name).orElse("");
    }

    private static Collection<ToolAction> getToolActions(ItemStack itemStack) {
        itemStack.canPerformAction(ToolActions.AXE_DIG);
        return ToolAction.getActions();
    }

    public static <V> ItemStack getItemStack(IListElementInfo<V> ingredientInfo) {
        ITypedIngredient<V> ingredient = ingredientInfo.getTypedIngredient();
        V v = ingredient.getIngredient();
        if (v instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)v;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }
}

