/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.chunk;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.chunk.IChunkCache;

class DirectChunkCache
implements IChunkCache,
IBlockAccessEx {
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected World world;
    protected int worldRef;

    @Override
    public void update(@Nonnull World world, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        if (this.world != world) {
            ++this.worldRef;
            this.world = world;
        }
    }

    @Override
    public void clear() {
        this.world = null;
    }

    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        return this.world == null ? null : this.world.func_175625_s(pos);
    }

    public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
        return this.world == null ? lightValue : this.world.func_175626_b(pos, lightValue);
    }

    public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        return this.world == null ? Blocks.field_150350_a.func_176223_P() : this.world.func_180495_p(pos);
    }

    public boolean func_175623_d(@Nonnull BlockPos pos) {
        return this.world != null && this.world.func_175623_d(pos);
    }

    public Biome func_180494_b(@Nonnull BlockPos pos) {
        if (this.world != null) {
            try {
                return this.world.func_180494_b(pos);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Biomes.field_76772_c;
    }

    public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        return this.world == null ? 0 : this.world.func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.world == null ? WorldType.field_77137_b : this.world.func_175624_G();
    }

    public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        return this.world != null && this.world.isSideSolid(pos, side, _default);
    }

    @Override
    public int reference() {
        return 0;
    }

    @Override
    public int worldReference() {
        return this.worldRef;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public IBlockState getBlockState(int x, int y, int z) {
        return this.world == null ? Blocks.field_150350_a.func_176223_P() : this.world.func_180495_p((BlockPos)this.pos.func_181079_c(x, y, z));
    }

    @Override
    public int getLightFor(@Nonnull EnumSkyBlock type, @Nonnull BlockPos pos) {
        return this.world == null ? 0 : this.world.func_175642_b(type, pos);
    }

    @Override
    public BlockPos getTopSolidOrLiquidBlock(@Nonnull BlockPos pos) {
        return this.world == null ? pos : this.world.func_175672_r(pos);
    }

    @Override
    public boolean isAvailable(int x, int z) {
        return this.world != null && this.world.func_190526_b(x >> 4, z >> 4);
    }

    @Override
    public BlockPos getPrecipitationHeight(@Nonnull BlockPos pos) {
        return this.world == null ? pos : this.world.func_175725_q(pos);
    }
}

