/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.logic;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.block.ITileEntityBountyBoard;
import ejektaflex.bountiful.api.events.PopulateBountyBoardEvent;
import ejektaflex.bountiful.api.ext.ExtItemHandlerKt;
import ejektaflex.bountiful.api.logic.IBountyCreator;
import ejektaflex.bountiful.api.logic.IBountyHolder;
import ejektaflex.bountiful.data.BountyData;
import ejektaflex.bountiful.item.ItemBounty;
import ejektaflex.bountiful.logic.BountyCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0019\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u00030\u0003H\u0096\u0001J\u0011\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00030\u0003H\u0096\u0001J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lejektaflex/bountiful/logic/BountyHolder;", "Lejektaflex/bountiful/api/logic/IBountyHolder;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "handler", "Lnet/minecraftforge/items/ItemStackHandler;", "(Lnet/minecraftforge/items/ItemStackHandler;)V", "getHandler", "()Lnet/minecraftforge/items/ItemStackHandler;", "addSingleBounty", "", "world", "Lnet/minecraft/world/World;", "te", "Lejektaflex/bountiful/api/block/ITileEntityBountyBoard;", "deserializeNBT", "p0", "kotlin.jvm.PlatformType", "serializeNBT", "tickBounties", "update", "", "Bountiful"})
public class BountyHolder
implements IBountyHolder,
INBTSerializable<NBTTagCompound> {
    @NotNull
    private final ItemStackHandler handler;

    /*
     * WARNING - void declaration
     */
    @Override
    public void tickBounties(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        List toRemove = new ArrayList();
        IntRange intRange = ExtItemHandlerKt.getSlotRange((IItemHandler)this.getHandler());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                ItemStack bounty;
                void slot;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.getHandler().getStackInSlot((int)slot), (String)"handler.getStackInSlot(slot)");
                if (bounty.func_77973_b() instanceof ItemBounty && BountyData.Companion.isValidBounty(bounty)) {
                    BountyData data = BountyData.Companion.from(bounty);
                    Item item = bounty.func_77973_b();
                    if (item == null) {
                        throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.item.ItemBounty");
                    }
                    ItemBounty bountyItem = (ItemBounty)item;
                    if (Bountiful.INSTANCE.getConfig().getShouldCountdownOnBoard()) {
                        bountyItem.ensureTimerStarted(bounty, world);
                    }
                    if (data.hasExpired(world) || data.boardTimeLeft(world) <= 0L) {
                        toRemove.add((int)slot);
                    }
                }
                if (slot == n2) break;
                ++slot;
            }
        }
        Iterable $receiver$iv = toRemove;
        for (Object element$iv : $receiver$iv) {
            int it = ((Number)element$iv).intValue();
            this.getHandler().setStackInSlot(it, ItemStack.field_190927_a);
        }
    }

    @Override
    public void addSingleBounty(@NotNull World world, @Nullable ITileEntityBountyBoard te) {
        block1: {
            List freeSlots;
            Collection collection;
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            ItemStack newStack = IBountyCreator.DefaultImpls.createStack$default(BountyCreator.INSTANCE, world, null, 2, null);
            PopulateBountyBoardEvent fired = PopulateBountyBoardEvent.Companion.fireEvent(newStack, te);
            if (fired.isCanceled() || !(!(collection = (Collection)(freeSlots = CollectionsKt.minus((Iterable)CollectionsKt.toList((Iterable)((Iterable)ExtItemHandlerKt.getSlotRange((IItemHandler)this.getHandler()))), (Iterable)ExtItemHandlerKt.getFilledSlots((IItemHandlerModifiable)this.getHandler())))).isEmpty())) break block1;
            collection = freeSlots;
            IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)this.getHandler();
            Object object = CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default));
            ExtItemHandlerKt.set(iItemHandlerModifiable, ((Number)object).intValue(), newStack);
            ITileEntityBountyBoard iTileEntityBountyBoard = te;
            if (iTileEntityBountyBoard != null) {
                iTileEntityBountyBoard.sendRedstonePulse();
            }
        }
    }

    @Override
    public boolean update(@NotNull World world, @Nullable ITileEntityBountyBoard te) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        if (world.func_82737_E() % (long)20 == 3L) {
            this.tickBounties(world);
        }
        if (world.func_82737_E() % Bountiful.INSTANCE.getConfig().getBoardAddFrequency() == 3L) {
            Collection collection;
            while (ExtItemHandlerKt.getFilledSlots((IItemHandlerModifiable)this.getHandler()).size() >= Bountiful.INSTANCE.getConfig().getMaxBountiesPerBoard() && !(collection = (Collection)ExtItemHandlerKt.getFilledSlots((IItemHandlerModifiable)this.getHandler())).isEmpty()) {
                Collection collection2 = ExtItemHandlerKt.getFilledSlots((IItemHandlerModifiable)this.getHandler());
                int slotPicked = ((Number)CollectionsKt.random((Collection)collection2, (Random)((Random)Random.Default))).intValue();
                IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)this.getHandler();
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                ExtItemHandlerKt.set(iItemHandlerModifiable, slotPicked, itemStack);
            }
            this.addSingleBounty(world, te);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStackHandler getHandler() {
        return this.handler;
    }

    public BountyHolder(@NotNull ItemStackHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.handler = handler;
    }

    public void deserializeNBT(NBTTagCompound p0) {
        this.handler.deserializeNBT(p0);
    }

    public NBTTagCompound serializeNBT() {
        return this.handler.serializeNBT();
    }
}

