/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd;

import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.ItemHollowIchigoHelmet;
import littlebreadloaf.bleach_kd.armor.ItemSandals;
import littlebreadloaf.bleach_kd.armor.ItemShiniCaptain;
import littlebreadloaf.bleach_kd.armor.ItemShinigamiRobes;
import littlebreadloaf.bleach_kd.items.ISpiritFood;
import littlebreadloaf.bleach_kd.tiles.TileSeeleSchneider;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BleachLib {
    public static final String user_LOTUS = "e4c7e475-c1ff-4f94-956c-ac5be02ce04a";
    public static final String user_KNIGHT = "7b074877-010a-4941-b8c4-d18dd6705fd1";
    public static final String user_CATDIO = "b6dbfd58-1e82-4b57-921f-a5fe7b0351e8";
    public static final String user_SHIN = "7a516b4f-9ccd-4f35-a0dc-9ff8090084eb";
    public static final String user_GINGY = "b462e469-19ce-40b6-9999-d74102623b7c";

    public static float parseFloat(ICommandSender player, String strPar2) throws NumberInvalidException {
        try {
            return Float.parseFloat(strPar2);
        }
        catch (NumberFormatException numberformatexception) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{strPar2});
        }
    }

    public static float parseFloatBounded(ICommandSender player, String strPar2) throws NumberInvalidException {
        return BleachLib.parseFloatBounded(player, strPar2, 0.0f, 1.0f);
    }

    public static float parseFloatBounded(ICommandSender player, String strPar2, float minf, float maxf) throws NumberInvalidException {
        float k = BleachLib.parseFloat(player, strPar2);
        if (k < minf) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{Float.valueOf(k), Float.valueOf(minf)});
        }
        if (k > maxf) {
            throw new NumberInvalidException("commands.generic.num.tooBig", new Object[]{Float.valueOf(k), Float.valueOf(maxf)});
        }
        return k;
    }

    public static boolean isEntityInCube(Entity entity) {
        for (int i = 0; i < TileSeeleSchneider.magicSquare.size(); ++i) {
            int z;
            int y;
            int x = TileSeeleSchneider.magicSquare.get(i).func_177958_n();
            TileSeeleSchneider tile = (TileSeeleSchneider)entity.field_70170_p.func_175625_s(new BlockPos(x, y = TileSeeleSchneider.magicSquare.get(i).func_177956_o(), z = TileSeeleSchneider.magicSquare.get(i).func_177952_p()));
            if (tile == null) {
                TileSeeleSchneider.magicSquare.remove(i);
                return false;
            }
            int side = tile.side;
            if (!(entity.field_70165_t > (double)((float)x + 0.5f)) || !(entity.field_70165_t < (double)((float)(x + side) - 0.5f)) || !(entity.field_70161_v > (double)((float)z + 0.5f)) || !(entity.field_70161_v < (double)((float)(z + side) - 0.5f)) || !(entity.field_70163_u >= (double)y) || !(entity.field_70163_u < (double)(y + 5))) continue;
            return true;
        }
        return false;
    }

    public static boolean acceptedHollowFood(ItemStack stack) {
        if (BleachConfiguration.allowHollowFoods) {
            return true;
        }
        if (stack.func_77973_b() instanceof ISpiritFood) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151034_e) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151106_aX) {
            return true;
        }
        return stack.func_77973_b() == Items.field_151158_bO;
    }

    public static void unequipItem(EntityPlayer thePlayer, EntityEquipmentSlot slot) {
        if (!thePlayer.field_70170_p.field_72995_K) {
            ItemStack unequipStack = thePlayer.func_184582_a(slot);
            thePlayer.func_184201_a(slot, ItemStack.field_190927_a);
            if (!thePlayer.func_191521_c(unequipStack)) {
                thePlayer.func_70099_a(unequipStack, 0.5f);
            }
        }
    }

    public static boolean vastoCheck(Entity entity, ItemStack stack, EntityEquipmentSlot slot) {
        if (entity instanceof EntityLivingBase) {
            ItemHollowIchigoHelmet ichigoMask;
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            ItemStack helm = entityLiving.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chest = entityLiving.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack legs = entityLiving.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack feet = entityLiving.func_184582_a(EntityEquipmentSlot.FEET);
            boolean hollowCloak = false;
            boolean vastoMask = false;
            boolean hollowLegs = false;
            boolean hollowFeet = false;
            if (chest != null && chest.func_77973_b() == BleachArmor.ShiniCaptain) {
                ItemShiniCaptain CapCloak = (ItemShiniCaptain)chest.func_77973_b();
                boolean bl = hollowCloak = CapCloak.decodeCloakData(chest, 7) == 1;
                if (!hollowCloak) {
                    return false;
                }
            }
            if (helm != null && helm.func_77973_b() == BleachArmor.HollowIchigoHelmet && !(vastoMask = (ichigoMask = (ItemHollowIchigoHelmet)helm.func_77973_b()).isVastoMask(entityLiving))) {
                return false;
            }
            if (legs != null && legs.func_77973_b() == BleachArmor.ShiniPants) {
                ItemShinigamiRobes shiniPants = (ItemShinigamiRobes)legs.func_77973_b();
                boolean bl = hollowLegs = shiniPants.decodeCloakData(legs, 9) == 1;
                if (!hollowLegs) {
                    return false;
                }
            }
            if (feet != null && feet.func_77973_b() == BleachArmor.Sandals) {
                ItemSandals shiniSandals = (ItemSandals)feet.func_77973_b();
                int currentSandal = shiniSandals.getSandal(feet);
                boolean bl = hollowFeet = currentSandal == 1 || currentSandal == 3;
                if (!hollowFeet) {
                    return false;
                }
            }
            if (hollowCloak && vastoMask && hollowLegs && hollowFeet) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorderedString(FontRenderer renderer, String text, int x, int y, int colour) {
        renderer.func_78276_b(text, x + 1, y, 0);
        renderer.func_78276_b(text, x - 1, y, 0);
        renderer.func_78276_b(text, x, y - 1, 0);
        renderer.func_78276_b(text, x, y + 1, 0);
        renderer.func_78276_b(text, x, y, colour);
    }
}

