/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd;

import java.util.HashMap;
import java.util.Map;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.util.ResourceLocation;

public class BleachMaskMappings {
    public static Map<Integer, ModelBiped> IDtoMaskMapping = new HashMap<Integer, ModelBiped>();
    public static Map<Integer, String> IDtoTexMapping = new HashMap<Integer, String>();
    public static Map<String, Integer> NametoIDMapping = new HashMap<String, Integer>();
    public static final int bleachMasks = 20;

    public static void addMapping(int ID, String name, ModelBiped maskModel, String resLoc) {
        String par2String = name.toString();
        if (NametoIDMapping.containsKey(par2String)) {
            throw new IllegalArgumentException("Bleach Mask ID is already registered: " + par2String);
        }
        if (IDtoMaskMapping.containsKey(ID)) {
            throw new IllegalArgumentException("Bleach Mask ID is already registered: " + ID);
        }
        IDtoTexMapping.put(ID, resLoc);
        IDtoMaskMapping.put(ID, maskModel);
        NametoIDMapping.put(name, ID);
    }

    public static ResourceLocation getMaskTexture(int ID) {
        String tex = IDtoTexMapping.getOrDefault(ID, "textures/models/armor/mask_ichigo1_player.png");
        return new ResourceLocation("bleach_kd:" + tex);
    }

    public static ModelBiped getMaskModel(int ID) {
        ModelBiped model = IDtoMaskMapping.getOrDefault(ID, BleachMaskMappings.getDefault());
        return model;
    }

    public static int getMaskIDFromName(String name) {
        int ID = NametoIDMapping.getOrDefault(name, 8);
        return ID;
    }

    public static ModelBiped getDefault() {
        ModelBiped _default = new ModelBiped(1.0f);
        _default.field_78115_e.field_78807_k = true;
        _default.field_178724_i.field_78807_k = true;
        _default.field_178723_h.field_78807_k = true;
        _default.field_178722_k.field_78807_k = true;
        _default.field_178721_j.field_78807_k = true;
        return _default;
    }

    public static ModelBiped getModelMaskOnly(int id) {
        ModelBiped model = ClientProxy.getArmorModel(id);
        model.field_78115_e.field_78807_k = true;
        model.field_178724_i.field_78807_k = true;
        model.field_178723_h.field_78807_k = true;
        model.field_178722_k.field_78807_k = true;
        model.field_178721_j.field_78807_k = true;
        return model;
    }

    public static void createMaskMappings() {
        BleachMaskMappings.addMapping(0, "IchigoMaskHalf", BleachMaskMappings.getDefault(), "textures/models/armor/mask_ichigo1_player.png");
        BleachMaskMappings.addMapping(1, "Snake", BleachMaskMappings.getModelMaskOnly(2), "textures/models/armor/mask_snake_player.png");
        BleachMaskMappings.addMapping(2, "Wolf", BleachMaskMappings.getModelMaskOnly(3), "textures/models/armor/mask_wolf_player.png");
        BleachMaskMappings.addMapping(3, "Stalker", BleachMaskMappings.getModelMaskOnly(4), "textures/models/armor/mask_stalker_player.png");
        BleachMaskMappings.addMapping(4, "Pterodactyl", BleachMaskMappings.getModelMaskOnly(6), "textures/models/armor/mask_pterodactyl_player.png");
        BleachMaskMappings.addMapping(5, "Lizard", BleachMaskMappings.getModelMaskOnly(7), "textures/models/armor/mask_lizard_player.png");
        BleachMaskMappings.addMapping(6, "Mantis", BleachMaskMappings.getModelMaskOnly(8), "textures/models/armor/mask_mantis_player.png");
        BleachMaskMappings.addMapping(7, "HoneyBadger", BleachMaskMappings.getModelMaskOnly(9), "textures/models/armor/mask_honeybadger_player.png");
        BleachMaskMappings.addMapping(8, "IchigoMask", BleachMaskMappings.getDefault(), "textures/models/armor/mask_ichigo2_player.png");
        BleachMaskMappings.addMapping(9, "Ashido", BleachMaskMappings.getModelMaskOnly(18), "textures/models/armor/ashido_armour.png");
        BleachMaskMappings.addMapping(10, "IchigoVasto", BleachMaskMappings.getModelMaskOnly(17), "textures/models/armor/hollow_ichigo_full.png");
        BleachMaskMappings.addMapping(11, "Bird", BleachMaskMappings.getDefault(), "textures/models/armor/mask_bird_player.png");
        BleachMaskMappings.addMapping(12, "Worm", BleachMaskMappings.getDefault(), "textures/models/armor/mask_worm_player.png");
        BleachMaskMappings.addMapping(13, "Fisher", BleachMaskMappings.getDefault(), "textures/models/armor/mask_fisher_player.png");
        BleachMaskMappings.addMapping(14, "Spider", BleachMaskMappings.getDefault(), "textures/models/armor/mask_spider_player.png");
        BleachMaskMappings.addMapping(15, "Blaze", BleachMaskMappings.getDefault(), "textures/models/armor/mask_blaze_player.png");
        BleachMaskMappings.addMapping(16, "Wasp", BleachMaskMappings.getDefault(), "textures/models/armor/mask_wasp_player.png");
        BleachMaskMappings.addMapping(17, "Scorpion", BleachMaskMappings.getDefault(), "textures/models/armor/mask_scorpion_player.png");
        BleachMaskMappings.addMapping(18, "Monkey", BleachMaskMappings.getDefault(), "textures/models/armor/mask_monkey_player.png");
        BleachMaskMappings.addMapping(19, "Bat", BleachMaskMappings.getDefault(), "textures/models/armor/mask_bat_player.png");
        BleachMaskMappings.addMapping(20, "Golem", BleachMaskMappings.getModelMaskOnly(1), "textures/models/armor/mask_golem_player.png");
    }
}

