/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArrancarArmor
extends BleachItemArmor {
    int replenishTimer = 200;

    public ItemArrancarArmor(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4, String name) {
        super(par2, par3, par4, name);
        this.setFaction(3);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        if (stack.func_77973_b() == BleachArmor.ArrancarJacket || stack.func_77973_b() == BleachArmor.ArrancarShoes) {
            return "bleach_kd:textures/models/armor/arrancar_armor_1.png";
        }
        if (stack.func_77973_b() == BleachArmor.ArrancarPants) {
            return "bleach_kd:textures/models/armor/arrancar_armor_2.png";
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            --this.replenishTimer;
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (this.replenishTimer <= 0 && props.isArrancar()) {
                props.replenishSpiritEnergy(3);
                this.replenishTimer = 200;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ClientProxy.getArmorModel(0);
        if (itemStack != null && armorModel != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            armorModel.field_178720_f.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            armorModel.field_78115_e.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.LEGS;
            armorModel.field_178723_h.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            armorModel.field_178724_i.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            armorModel.field_178721_j.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            armorModel.field_178722_k.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_184218_aH();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_187075_l = _default.field_187075_l;
            armorModel.field_187076_m = _default.field_187076_m;
            return armorModel;
        }
        return null;
    }
}

