/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelAshidoArmour;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAshidoArmour
extends BleachItemArmor {
    public String cloakData = "cloakData";
    public String cloakVariation = "cloakVariation";

    public ItemAshidoArmour(ItemArmor.ArmorMaterial material, int render, EntityEquipmentSlot slot, String name) {
        super(material, render, slot, name);
        this.setFaction(0);
        this.useArmorModel(13);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float fx, float fy, float fz, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(pos).func_177230_c() == BleachBlocks.paperLamp) {
            int variation = this.getCloakVariation(stack) == 0 ? 1 : 0;
            this.setCloakVariation(stack, variation);
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, fx, fy, fz, hand);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        return "bleach_kd".toLowerCase() + ":textures/models/armor/ashido_armour.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ClientProxy.getArmorModel(13);
        if (itemStack != null && armorModel != null) {
            ModelAshidoArmour ashido = (ModelAshidoArmour)armorModel;
            if (entityLiving.func_184591_cq() == EnumHandSide.RIGHT) {
                ItemStack stackInOff = entityLiving.func_184582_a(EntityEquipmentSlot.OFFHAND);
                ashido.SHIELD.field_78807_k = !stackInOff.func_190926_b() && stackInOff.func_77973_b() instanceof ItemShield;
            }
            ashido.HEAD.field_78807_k = this.getCloakVariation(itemStack) != 0;
            ashido.field_78117_n = entityLiving.func_70093_af();
            ashido.field_78093_q = entityLiving.func_184218_aH();
            ashido.field_78091_s = entityLiving.func_70631_g_();
            return ashido;
        }
        return null;
    }

    public int getCloakVariation(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return 0;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(this.cloakData);
        return nbttagcompound1 == null ? 0 : (nbttagcompound1.func_74764_b(this.cloakVariation) ? nbttagcompound1.func_74762_e(this.cloakVariation) : 0);
    }

    public void setCloakVariation(ItemStack stack, int variation) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(this.cloakData);
        if (!nbttagcompound.func_74764_b(this.cloakData)) {
            nbttagcompound.func_74782_a(this.cloakData, (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a(this.cloakVariation, variation);
    }
}

