/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import littlebreadloaf.bleach_kd.armor.IHollowMask;
import littlebreadloaf.bleach_kd.armor.ItemBaseArmor;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemHollowHelmet
extends ItemBaseArmor
implements IHollowMask {
    int tickTime;
    int depleteTimer;

    public ItemHollowHelmet(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4) {
        super(par2, par3, par4, "hollowmask");
        this.depleteTimer = this.tickTime = 20;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (entity instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)entity).getCapability(BleachProvider.BLEACH_CAP, null)).getMaxSpirit() > 500) {
            return "bleach_kd:textures/models/armor/mask_ichigo2_player.png";
        }
        return "bleach_kd:textures/models/armor/mask_ichigo1_player.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        --this.depleteTimer;
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        if (props.isEnergyMoreThan(0) && !world.field_72995_K) {
            player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"resistance"), this.tickTime, 0));
            if (this.depleteTimer <= 0) {
                this.depleteTimer = this.tickTime;
                props.consumeSpiritEnergy(10, player);
            }
        }
    }

    @Override
    public int getJumpBoost() {
        return 0;
    }

    @Override
    public int getSpeedBoost() {
        return 1;
    }

    @Override
    public int getAttackBoost() {
        return 1;
    }

    @Override
    public void specialAttackEffect(EntityLivingBase wearer, EntityLivingBase attackee) {
    }
}

