/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.armor.IHollowMask;
import littlebreadloaf.bleach_kd.armor.ItemBaseArmor;
import littlebreadloaf.bleach_kd.armor.ItemShiniCaptain;
import littlebreadloaf.bleach_kd.entities.IBleachEntity;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelMaskIchigo;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHollowIchigoHelmet
extends ItemBaseArmor
implements IHollowMask {
    int tickTime;
    int depleteTimer;

    public ItemHollowIchigoHelmet(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4) {
        super(par2, par3, par4, "mask_ichigo_full");
        this.depleteTimer = this.tickTime = 20;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        String vasto = "bleach_kd".toLowerCase() + ":textures/models/armor/hollow_ichigo_full";
        if (BleachLib.vastoCheck(entity, stack, slot)) {
            ItemStack cloakStack = ((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.CHEST);
            ItemShiniCaptain cloak = (ItemShiniCaptain)cloakStack.func_77973_b();
            int[] cloakArray = cloak.getCLOAK(cloakStack);
            int shoulder = cloak.decodeCloakData(cloakArray, 5);
            int arm = cloak.decodeCloakData(cloakArray, 6);
            if (shoulder == 3 && arm == 3) {
                vasto = vasto + "_hollow";
            }
        }
        return vasto + ".png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        --this.depleteTimer;
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        if (props.isEnergyMoreThan(0) && !world.field_72995_K) {
            player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"resistance"), this.tickTime, 1));
            player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"regeneration"), this.tickTime, 0));
            if (this.depleteTimer <= 0) {
                this.depleteTimer = this.tickTime;
                props.consumeSpiritEnergy(40, player);
            }
        }
    }

    public boolean isVastoMask(EntityLivingBase entityLiving) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (entityLiving != null && entityLiving instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)entityLiving).getCapability(BleachProvider.BLEACH_CAP, null)).getMaxSpirit() >= 500 && props.getMaskData(0) == 0) {
            return true;
        }
        return entityLiving != null && entityLiving instanceof IBleachEntity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ClientProxy.getArmorModel(10);
        if (itemStack != null && armorModel != null && armorSlot == EntityEquipmentSlot.HEAD) {
            ModelMaskIchigo ichigoMask = (ModelMaskIchigo)armorModel;
            if (entityLiving instanceof EntityPlayer) {
                ichigoMask.resetHidden();
                EntityPlayer player = (EntityPlayer)entityLiving;
                IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
                if (props.getMaxSpirit() < 500) {
                    ichigoMask.frontOnly();
                    if (props.getMaskData(0) == 1 || props.getMaskData(0) == 3 || props.getMaskData(0) == 5) {
                        ichigoMask.FACELEFT.field_78807_k = false;
                        ichigoMask.JAWLEFT.field_78807_k = false;
                        ichigoMask.FACERIGHT.field_78807_k = true;
                        ichigoMask.JAWRIGHT.field_78807_k = true;
                    } else if (props.getMaskData(0) == 2 || props.getMaskData(0) == 4 || props.getMaskData(0) == 6) {
                        ichigoMask.FACELEFT.field_78807_k = true;
                        ichigoMask.JAWLEFT.field_78807_k = true;
                        ichigoMask.FACERIGHT.field_78807_k = false;
                        ichigoMask.JAWRIGHT.field_78807_k = false;
                    }
                    if (props.isEnergyLessThan(250)) {
                        ichigoMask.JAW.field_78807_k = true;
                    }
                } else if (props.getMaskData(0) == 1) {
                    ichigoMask.leftOnly(true);
                } else if (props.getMaskData(0) == 2) {
                    ichigoMask.leftOnly(false);
                } else if (props.getMaskData(0) == 3) {
                    ichigoMask.leftOnly(true);
                    ichigoMask.FACELEFT.field_78807_k = true;
                    ichigoMask.JAW.field_78807_k = true;
                } else if (props.getMaskData(0) == 4) {
                    ichigoMask.leftOnly(false);
                    ichigoMask.FACERIGHT.field_78807_k = true;
                    ichigoMask.JAW.field_78807_k = true;
                } else if (props.getMaskData(0) == 5) {
                    ichigoMask.hornLeftOnly(true);
                } else if (props.getMaskData(0) == 6) {
                    ichigoMask.hornLeftOnly(false);
                }
            } else {
                ichigoMask.resetHidden();
            }
            ichigoMask.field_78116_c.field_78806_j = false;
            ichigoMask.field_178720_f.field_78806_j = false;
            ichigoMask.field_78117_n = entityLiving.func_70093_af();
            ichigoMask.field_78093_q = entityLiving.func_184218_aH();
            ichigoMask.field_78091_s = entityLiving.func_70631_g_();
            return ichigoMask;
        }
        return null;
    }

    @Override
    public int getJumpBoost() {
        return 0;
    }

    @Override
    public int getSpeedBoost() {
        return 2;
    }

    @Override
    public int getAttackBoost() {
        return 2;
    }

    @Override
    public void specialAttackEffect(EntityLivingBase wearer, EntityLivingBase attackee) {
    }
}

