/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import java.util.List;
import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemQuincyLeztzStil
extends BleachItemArmor {
    public String cloakData = "cloakData";
    public String cloakVariation = "cloakVariation";

    public ItemQuincyLeztzStil(ItemArmor.ArmorMaterial par2, int par3, String name) {
        super(par2, par3, EntityEquipmentSlot.CHEST, name);
        this.setFaction(2);
        this.useArmorModel(12);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag bool) {
        this.addCLOAK(stack);
        list.add("Clothing Type : " + this.getCloakVariation(stack));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float fx, float fy, float fz) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() == BleachBlocks.paperLamp) {
            int variation = this.getCloakVariation(stack);
            if (++variation >= 5) {
                variation = 0;
            }
            this.setCloakVariation(stack, variation);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        String s = "";
        switch (this.getCloakVariation(stack)) {
            case 0: {
                s = ":textures/models/armor/quincy_leztzstil_bare.png";
                break;
            }
            case 1: {
                s = ":textures/models/armor/quincy_leztzstil_quincy1.png";
                break;
            }
            case 2: {
                s = ":textures/models/armor/quincy_leztzstil_quincy2.png";
                break;
            }
            case 3: {
                s = ":textures/models/armor/quincy_leztzstil_shinigami.png";
                break;
            }
            case 4: {
                s = ":textures/models/armor/quincy_leztzstil_shinigami_h.png";
            }
        }
        return "bleach_kd".toLowerCase() + s;
    }

    public int getCloakVariation(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_179543_a(this.cloakData);
        if (nbttagcompound != null && nbttagcompound.func_74764_b(this.cloakVariation)) {
            return nbttagcompound.func_74762_e(this.cloakVariation);
        }
        return 0;
    }

    public ItemStack setCloakVariation(ItemStack stack, int cloakData) {
        stack.func_190925_c(this.cloakData).func_74768_a(this.cloakVariation, cloakData);
        return stack;
    }

    public boolean hasCLOAK(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_74764_b(this.cloakData) ? nbttagcompound.func_74775_l(this.cloakData).func_74764_b(this.cloakVariation) : false;
    }

    public void addCLOAK(ItemStack stack) {
        if (!this.hasCLOAK(stack)) {
            this.setCloakVariation(stack, 0);
        }
    }
}

