/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import java.util.List;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelShihakusho;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSandals
extends BleachItemArmor {
    int replenishTimer = 200;

    public ItemSandals(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4, String name) {
        super(par2, par3, par4, name);
        this.setFaction(1);
        this.useArmorModel(14);
        this.func_185043_a(new ResourceLocation("hollow"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                ItemSandals sandal = (ItemSandals)stack.func_77973_b();
                int sandalVal = sandal.getSandal(stack);
                boolean isHollow = sandalVal == 1 || sandalVal == 3;
                return isHollow ? 1.0f : 0.0f;
            }
        });
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        String s = "bleach_kd".toLowerCase() + ":textures/models/armor/shinigami/sandals";
        int sandalVal = this.getSandal(stack);
        boolean isHollow = sandalVal == 1 || sandalVal == 3;
        s = s + (isHollow ? "_hollow" : "_base");
        return s + ".png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            --this.replenishTimer;
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (this.replenishTimer <= 0 && props.isShinigami()) {
                props.replenishSpiritEnergy(2);
                this.replenishTimer = 200;
            }
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag bool) {
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float fx, float fy, float fz, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        if (block == BleachBlocks.paperLamp) {
            int returntype = this.getSandal(stack) < 2 ? this.getSandal(stack) + 2 : this.getSandal(stack) - 2;
            this.setSandal(stack, returntype);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150484_ah) {
            int current = this.getSandal(stack);
            if (current == 0 || current == 2) {
                ItemStack shards;
                boolean missingBlock = false;
                block0: for (int valX = -1; valX < 2 && !missingBlock; ++valX) {
                    for (int valZ = -1; valZ < 2; ++valZ) {
                        if (valX == 0 && valZ == 0 || world.func_180495_p(pos.func_177982_a(valX, 0, valZ)).func_177230_c() == BleachBlocks.reiatsuBlock) continue;
                        missingBlock = true;
                        continue block0;
                    }
                }
                if (!missingBlock && player.field_71071_by.func_70431_c(shards = new ItemStack(BleachItems.maskshard, 2))) {
                    int shardSlot = player.field_71071_by.func_194014_c(shards);
                    player.field_71071_by.func_70298_a(shardSlot, 2);
                    this.setSandal(stack, current + 1);
                    return EnumActionResult.SUCCESS;
                }
            }
        } else {
            return super.onItemUseFirst(player, world, pos, side, fx, fy, fz, hand);
        }
        return EnumActionResult.FAIL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ClientProxy.getArmorModel(14);
        if (itemStack != null && itemStack.func_77973_b() == this) {
            if (BleachLib.vastoCheck((Entity)entityLiving, itemStack, armorSlot)) {
                armorModel.field_78116_c.field_78807_k = true;
                armorModel.field_178720_f.field_78807_k = true;
                armorModel.field_78115_e.field_78807_k = true;
                armorModel.field_178723_h.field_78807_k = true;
                armorModel.field_178724_i.field_78807_k = true;
                armorModel.field_178721_j.field_78807_k = true;
                armorModel.field_178722_k.field_78807_k = true;
                return armorModel;
            }
            if (armorModel != null) {
                ModelShihakusho shini = (ModelShihakusho)armorModel;
                shini.field_78116_c.field_78807_k = true;
                shini.field_178720_f.field_78807_k = true;
                shini.field_78116_c.field_78807_k = true;
                shini.field_178720_f.field_78807_k = true;
                shini.field_78115_e.field_78807_k = true;
                shini.field_178723_h.field_78807_k = true;
                shini.field_178724_i.field_78807_k = true;
                shini.field_178721_j.field_78807_k = true;
                shini.field_178722_k.field_78807_k = true;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_184218_aH();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                if (armorSlot == EntityEquipmentSlot.FEET) {
                    boolean sandals;
                    shini.field_178722_k.field_78806_j = true;
                    shini.field_178721_j.field_78806_j = true;
                    shini.field_178722_k.field_78807_k = false;
                    shini.field_178721_j.field_78807_k = false;
                    shini.FeetLeftShoe1.field_78807_k = sandals = this.getSandal(itemStack) < 2;
                    shini.FeetLeftShoe2.field_78807_k = !sandals;
                    shini.FeetRightShoe1.field_78807_k = sandals;
                    shini.FeetRightShoe2.field_78807_k = !sandals;
                    return shini;
                }
            }
        }
        return null;
    }

    public int getSandal(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_179543_a("data");
        if (nbttagcompound != null && nbttagcompound.func_74764_b("sandal")) {
            return nbttagcompound.func_74762_e("sandal");
        }
        return 0;
    }

    public ItemStack setSandal(ItemStack stack, int sandal) {
        stack.func_190925_c("data").func_74768_a("sandal", sandal);
        return stack;
    }

    public boolean hasSandal(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_74764_b("data") ? nbttagcompound.func_74775_l("data").func_74764_b("sandal") : false;
    }

    public void addSandal(ItemStack stack) {
        if (!this.hasSandal(stack)) {
            this.setSandal(stack, 0);
        }
    }
}

