/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import java.util.List;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.armor.ItemShinigamiRobes;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelCaptainJacket;
import littlebreadloaf.bleach_kd.render.models.armor.ModelIchigoVastoLorde;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShiniCaptain
extends BleachItemArmor {
    public String[] title = new String[]{"cloaktype", "leftarm", "rightarm", "scarf", "belt", "shoulders", "wrists", "hollow", "squad"};
    int replenishTimer = 200;
    private final int[] defaultCloak = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};

    public ItemShiniCaptain(ItemArmor.ArmorMaterial par2, int par3, String name) {
        super(par2, par3, EntityEquipmentSlot.CHEST, name);
        this.setFaction(1);
        this.useArmorModel(11);
        this.func_185043_a(new ResourceLocation("hollow"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                ItemShiniCaptain robes = (ItemShiniCaptain)stack.func_77973_b();
                boolean isHollow = robes.decodeCloakData(stack, 7) != 0;
                return isHollow ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag bool) {
        this.addCLOAK(stack);
        int[] cloakVals = this.getCLOAK(stack);
        for (int j = 0; j < 9; ++j) {
            int i = this.decodeCloakData(cloakVals, j);
            if (i == 0) continue;
            int val = i;
            if (j == 8 && i == 14) {
                val = 0;
            }
            String s = I18n.func_74838_a((String)("captainCloak." + this.title[j] + ".name"));
            if (j == 8 && (i == 15 || i == 16)) {
                String s1 = I18n.func_74838_a((String)("shihakusho.squad" + val + ".name"));
                list.add(s + " : " + s1);
                continue;
            }
            list.add(s + " : " + val);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float fx, float fy, float fz, EnumHand hand) {
        ItemStack shards;
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150325_L) {
            int blockMeta = block.func_176201_c(world.func_180495_p(pos));
            int scarf = player.func_70093_af() ? 4 : 3;
            this.recodeCloakData(stack, scarf, blockMeta + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150383_bp) {
            int scarf = player.func_70093_af() ? 4 : 3;
            this.recodeCloakData(stack, scarf, 0);
            return EnumActionResult.SUCCESS;
        }
        if (block == BleachBlocks.paperLamp) {
            if (player.func_70093_af()) {
                if ((!BleachConfiguration.restrictCaptainNumber || !player.field_71075_bZ.field_75098_d) && BleachConfiguration.restrictCaptainNumber) return EnumActionResult.FAIL;
                int[] data = this.getCLOAK(stack);
                this.recodeCloakData(stack, 8, data[8] + 1);
                return EnumActionResult.SUCCESS;
            }
            int[] data = this.getCLOAK(stack);
            this.recodeCloakData(stack, 0, data[0] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150344_f) {
            int[] data = this.getCLOAK(stack);
            int shoulder = player.func_70093_af() ? 6 : 5;
            this.recodeCloakData(stack, shoulder, data[shoulder] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150460_al) {
            int shoulder = player.func_70093_af() ? 6 : 5;
            this.recodeCloakData(stack, shoulder, 0);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150434_aF) {
            int[] data = this.getCLOAK(stack);
            int leftarm = player.func_70093_af() ? 1 : 2;
            this.recodeCloakData(stack, leftarm, data[leftarm] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == BleachBlocks.reiatsuBlock) {
            int leftarm = player.func_70093_af() ? 1 : 2;
            this.recodeCloakData(stack, leftarm, 0);
            if (!player.func_175151_a(pos, side, stack)) return EnumActionResult.SUCCESS;
            world.func_175698_g(pos);
            return EnumActionResult.SUCCESS;
        }
        if (block != Blocks.field_150484_ah) return super.onItemUseFirst(player, world, pos, side, fx, fy, fz, hand);
        if (this.decodeCloakData(stack, 7) != 0) return EnumActionResult.FAIL;
        boolean missingBlock = false;
        block0: for (int valX = -1; valX < 2 && !missingBlock; ++valX) {
            for (int valZ = -1; valZ < 2; ++valZ) {
                if (valX == 0 && valZ == 0 || world.func_180495_p(pos.func_177982_a(valX, 0, valZ)).func_177230_c() == BleachBlocks.reiatsuBlock) continue;
                missingBlock = true;
                continue block0;
            }
        }
        if (missingBlock || !player.field_71071_by.func_70431_c(shards = new ItemStack(BleachItems.maskshard, 9))) return EnumActionResult.FAIL;
        int shardSlot = player.field_71071_by.func_194014_c(shards);
        player.field_71071_by.func_70298_a(shardSlot, 9);
        this.recodeCloakData(stack, 7, 1);
        return EnumActionResult.SUCCESS;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        String s = "bleach_kd".toLowerCase() + ":textures/models/armor/captain_jacket/captain_jacket";
        String vasto = "bleach_kd".toLowerCase() + ":textures/models/armor/ichigovastoform";
        int[] cloakVals = this.getCLOAK(stack);
        if (BleachLib.vastoCheck(entity, stack, slot)) {
            int shoulder = this.decodeCloakData(cloakVals, 5);
            int arm = this.decodeCloakData(cloakVals, 6);
            if (shoulder == 3 && arm == 3) {
                vasto = vasto + "_hollow";
            }
            return vasto + ".png";
        }
        if (layer != null && layer.equalsIgnoreCase("overlay")) {
            int squad = this.decodeCloakData(cloakVals, 8);
            int n = squad = squad == 14 ? 0 : squad;
            String squadStr = squad == 15 ? "_kido" : (squad == 16 ? "_stealth" : "" + squad);
            return s + "_squad" + squadStr + ".png";
        }
        s = s + "_player";
        s = s + (this.decodeCloakData(cloakVals, 7) == 0 ? "" : "_h");
        return s + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack p_82790_1_, int p_82790_2_) {
        return 0xFFFFFF;
    }

    public boolean hasOverlay(ItemStack stack) {
        return this.decodeCloakData(stack, 8) != 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            --this.replenishTimer;
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (this.replenishTimer <= 0 && props.isShinigami()) {
                props.replenishSpiritEnergy(4);
                this.replenishTimer = 200;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ClientProxy.getArmorModel(11);
        if (itemStack != null) {
            if (BleachLib.vastoCheck((Entity)entityLiving, itemStack, armorSlot)) {
                armorModel = ClientProxy.getArmorModel(15);
                if (armorModel != null) {
                    ModelIchigoVastoLorde ichigo = (ModelIchigoVastoLorde)armorModel;
                    ItemStack pantsStack = entityLiving.func_184582_a(EntityEquipmentSlot.LEGS);
                    ItemShinigamiRobes pants = (ItemShinigamiRobes)pantsStack.func_77973_b();
                    int[] pantsArray = pants.getCLOAK(pantsStack);
                    int wraps = pants.decodeCloakData(pantsArray, 7);
                    int bands = pants.decodeCloakData(pantsArray, 8);
                    int leftleg = pants.decodeCloakData(pantsArray, 4);
                    int rightleg = pants.decodeCloakData(pantsArray, 5);
                    int[] cloakVals = this.getCLOAK(itemStack);
                    ichigo.setBodyType(this.decodeCloakData(cloakVals, 0));
                    ichigo.setLeftArm(this.decodeCloakData(cloakVals, 1));
                    ichigo.setRightArm(this.decodeCloakData(cloakVals, 2));
                    ichigo.setLeftLeg(leftleg, wraps, bands);
                    ichigo.setRightLeg(rightleg, wraps, bands);
                    return ichigo;
                }
            } else if (armorModel != null) {
                ModelCaptainJacket cloak = (ModelCaptainJacket)armorModel;
                int[] cloakVals = this.getCLOAK(itemStack);
                cloak.outfitType(this.decodeCloakData(cloakVals, 0));
                boolean bl = this.decodeCloakData(cloakVals, 7) == 0 ? this.decodeCloakData(cloakVals, 8) == 0 : (cloak.SquadLogo.field_78807_k = true);
                if (this.decodeCloakData(cloakVals, 0) != 2) {
                    cloak.setLeftArm(this.decodeCloakData(cloakVals, 1));
                    cloak.setRightArm(this.decodeCloakData(cloakVals, 2));
                }
                cloak.setColourScarf(this.decodeCloakData(cloakVals, 3) - 1);
                cloak.setColourBelt(this.decodeCloakData(cloakVals, 4) - 1);
                cloak.ShoulderLeftWood.field_78807_k = this.decodeCloakData(cloakVals, 5) != 0 ? this.decodeCloakData(cloakVals, 5) == 2 : true;
                cloak.ShoulderRightWood.field_78807_k = this.decodeCloakData(cloakVals, 5) != 0 ? this.decodeCloakData(cloakVals, 5) == 1 : true;
                cloak.LeftSleeveWood.field_78807_k = this.decodeCloakData(cloakVals, 6) != 0 ? this.decodeCloakData(cloakVals, 6) == 2 : true;
                cloak.RightSleeveWood.field_78807_k = this.decodeCloakData(cloakVals, 6) != 0 ? this.decodeCloakData(cloakVals, 6) == 1 : true;
                return cloak;
            }
        }
        return null;
    }

    public int decodeCloakData(ItemStack stack, int index) {
        int[] curVals = this.getCLOAK(stack);
        return curVals[index];
    }

    public int decodeCloakData(int[] array, int index) {
        return array[index];
    }

    public ItemStack recodeCloakData(ItemStack stack, int index, int value) {
        if (index > 8) {
            return stack;
        }
        int[] newVals = this.getCLOAK(stack);
        int maxVal = 0;
        switch (index) {
            case 0: {
                maxVal = 2;
                break;
            }
            case 1: {
                maxVal = 4;
                break;
            }
            case 2: {
                maxVal = 4;
                break;
            }
            case 3: {
                maxVal = 16;
                break;
            }
            case 4: {
                maxVal = 16;
                break;
            }
            case 5: {
                maxVal = 3;
                break;
            }
            case 6: {
                maxVal = 3;
                break;
            }
            case 7: {
                maxVal = 1;
                break;
            }
            case 8: {
                maxVal = 16;
            }
        }
        if (value > maxVal) {
            value = index == 0 || index == 8 ? 0 : maxVal;
        } else if (value < 0) {
            value = 0;
        }
        newVals[index] = value;
        return this.setCLOAK(stack, newVals);
    }

    public ItemStack randomizeJacket(ItemStack stack, boolean basic) {
        int squad = BleachConfiguration.restrictCaptainNumber ? 0 : field_77697_d.nextInt(16);
        int leftarm = field_77697_d.nextInt(5);
        int rightarm = field_77697_d.nextInt(5);
        this.recodeCloakData(stack, 8, squad);
        this.recodeCloakData(stack, 0, field_77697_d.nextInt(2));
        this.recodeCloakData(stack, 1, leftarm);
        this.recodeCloakData(stack, 2, rightarm);
        this.recodeCloakData(stack, 4, field_77697_d.nextInt(2));
        return stack;
    }

    public int[] getCLOAK(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_179543_a("data");
        if (nbttagcompound != null && nbttagcompound.func_74764_b("cloak")) {
            return nbttagcompound.func_74759_k("cloak");
        }
        return this.defaultCloak;
    }

    public ItemStack setCLOAK(ItemStack stack, int[] cloakData) {
        if (cloakData == null) {
            cloakData = this.defaultCloak;
        }
        stack.func_190925_c("data").func_74783_a("cloak", cloakData);
        return stack;
    }

    public boolean hasCLOAK(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_74764_b("data") ? nbttagcompound.func_74775_l("data").func_74764_b("cloak") : false;
    }

    public void addCLOAK(ItemStack stack) {
        if (!this.hasCLOAK(stack)) {
            this.setCLOAK(stack, this.defaultCloak);
        }
    }
}

