/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import java.util.List;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelShihakusho;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShinigamiRobes
extends BleachItemArmor {
    int replenishTimer = 200;
    public String[] title = new String[]{"bodytype", "leftarm", "rightarm", "scarf", "leftleg", "rightleg", "badge", "wraps", "bands", "hollow", "squad", "sash"};
    private final int[] defaultCloak = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public ItemShinigamiRobes(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4, String name) {
        super(par2, par3, par4, name);
        this.setFaction(1);
        this.useArmorModel(14);
        this.func_185043_a(new ResourceLocation("hollow"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                ItemShinigamiRobes robes = (ItemShinigamiRobes)stack.func_77973_b();
                boolean isHollow = robes.decodeCloakData(stack, 9) != 0;
                return isHollow ? 1.0f : 0.0f;
            }
        });
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        String s = "bleach_kd".toLowerCase() + ":textures/models/armor/shinigami/shinigami";
        if (layer != null && layer.equalsIgnoreCase("overlay")) {
            int squad = this.decodeCloakData(stack, 10);
            int n = squad = squad == 14 ? 0 : squad;
            String squadStr = squad == 15 ? "_kido" : (squad == 16 ? "_stealth" : "" + squad);
            return s + "_squad" + squadStr + ".png";
        }
        s = s + (this.decodeCloakData(stack, 9) == 0 ? "_base" : "_hollow");
        return s + ".png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            --this.replenishTimer;
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (this.replenishTimer <= 0 && props.isShinigami()) {
                props.replenishSpiritEnergy(2);
                this.replenishTimer = 200;
            }
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag bool) {
        this.addCLOAK(stack);
        int[] cloakVals = this.getCLOAK(stack);
        for (int j = 0; j < 12; ++j) {
            int i = this.decodeCloakData(cloakVals, j);
            if (i == 0) continue;
            int val = i;
            if (j == 10 && i == 14) {
                val = 0;
            }
            String s = I18n.func_74838_a((String)("shihakusho." + this.title[j] + ".name"));
            if (stack.func_77973_b() == BleachArmor.Sandals) {
                // empty if block
            }
            if (j == 10 && (i == 15 || i == 16)) {
                String s1 = I18n.func_74838_a((String)("shihakusho.squad" + val + ".name"));
                list.add(s + " : " + s1);
                continue;
            }
            list.add(s + " : " + val);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float fx, float fy, float fz, EnumHand hand) {
        int shardCount;
        ItemStack shards;
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        boolean isPants = stack.func_77973_b() == BleachArmor.ShiniPants;
        boolean isRobes = stack.func_77973_b() == BleachArmor.ShiniRobe;
        int[] data = this.getCLOAK(stack);
        if ((block == Blocks.field_150364_r || block == Blocks.field_150363_s) && isRobes) {
            this.recodeCloakData(stack, 6, data[6] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150325_L && isRobes) {
            int blockMeta = block.func_176201_c(world.func_180495_p(pos));
            int scarf = 3;
            if (player.func_70093_af()) {
                scarf = 11;
                blockMeta = data[11];
            }
            this.recodeCloakData(stack, scarf, blockMeta + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150383_bp && isRobes) {
            this.recodeCloakData(stack, 3, 0);
            return EnumActionResult.SUCCESS;
        }
        if (block == BleachBlocks.paperLamp) {
            if (!isRobes) return EnumActionResult.FAIL;
            if (player.func_70093_af()) {
                if ((!BleachConfiguration.restrictCaptainNumber || !player.field_71075_bZ.field_75098_d) && BleachConfiguration.restrictCaptainNumber) return EnumActionResult.FAIL;
                this.recodeCloakData(stack, 10, data[10] + 1);
                return EnumActionResult.SUCCESS;
            }
            this.recodeCloakData(stack, 0, data[0] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150344_f && (isRobes || isPants)) {
            int wraps = player.func_70093_af() ? 8 : 7;
            this.recodeCloakData(stack, wraps, data[wraps] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == Blocks.field_150434_aF) {
            int limb = player.func_70093_af() ? (isRobes ? 1 : 4) : (isRobes ? 2 : 5);
            this.recodeCloakData(stack, limb, data[limb] + 1);
            return EnumActionResult.SUCCESS;
        }
        if (block == BleachBlocks.reiatsuBlock && (isRobes || isPants)) {
            if (isRobes) {
                this.recodeCloakData(stack, 1, 0);
                this.recodeCloakData(stack, 2, 0);
            } else if (isPants) {
                this.recodeCloakData(stack, 4, 0);
                this.recodeCloakData(stack, 5, 0);
            }
            if (!player.func_175151_a(pos, side, stack)) return EnumActionResult.SUCCESS;
            world.func_175698_g(pos);
            return EnumActionResult.SUCCESS;
        }
        if (block != Blocks.field_150484_ah) return super.onItemUseFirst(player, world, pos, side, fx, fy, fz, hand);
        if (this.decodeCloakData(stack, 9) != 0) return EnumActionResult.FAIL;
        boolean missingBlock = false;
        block0: for (int valX = -1; valX < 2 && !missingBlock; ++valX) {
            for (int valZ = -1; valZ < 2; ++valZ) {
                if (valX == 0 && valZ == 0 || world.func_180495_p(pos.func_177982_a(valX, 0, valZ)).func_177230_c() == BleachBlocks.reiatsuBlock) continue;
                missingBlock = true;
                continue block0;
            }
        }
        if (missingBlock || !player.field_71071_by.func_70431_c(shards = new ItemStack(BleachItems.maskshard, shardCount = isRobes ? 6 : (isPants ? 3 : 2)))) return EnumActionResult.FAIL;
        int shardSlot = player.field_71071_by.func_194014_c(shards);
        player.field_71071_by.func_70298_a(shardSlot, shardCount);
        this.recodeCloakData(stack, 9, 1);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack p_82790_1_, int p_82790_2_) {
        return 0xFFFFFF;
    }

    public boolean hasOverlay(ItemStack stack) {
        return this.decodeCloakData(stack, 10) != 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ClientProxy.getArmorModel(14);
        if (itemStack != null && itemStack.func_77973_b() == this) {
            if (BleachLib.vastoCheck((Entity)entityLiving, itemStack, armorSlot)) {
                armorModel.field_78116_c.field_78807_k = true;
                armorModel.field_178720_f.field_78807_k = true;
                armorModel.field_78115_e.field_78807_k = true;
                armorModel.field_178723_h.field_78807_k = true;
                armorModel.field_178724_i.field_78807_k = true;
                armorModel.field_178721_j.field_78807_k = true;
                armorModel.field_178722_k.field_78807_k = true;
                return armorModel;
            }
            if (armorModel != null) {
                ModelShihakusho shini = (ModelShihakusho)armorModel;
                int[] cloakVals = this.getCLOAK(itemStack);
                shini.field_78116_c.field_78807_k = true;
                shini.field_178720_f.field_78807_k = true;
                shini.field_78116_c.field_78807_k = true;
                shini.field_178720_f.field_78807_k = true;
                shini.field_78115_e.field_78807_k = true;
                shini.field_178723_h.field_78807_k = true;
                shini.field_178724_i.field_78807_k = true;
                shini.field_178721_j.field_78807_k = true;
                shini.field_178722_k.field_78807_k = true;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_184218_aH();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                if (armorSlot == EntityEquipmentSlot.CHEST) {
                    shini.field_78115_e.field_78806_j = true;
                    shini.field_178724_i.field_78806_j = true;
                    shini.field_178723_h.field_78806_j = true;
                    shini.field_78115_e.field_78807_k = false;
                    shini.field_178724_i.field_78807_k = false;
                    shini.field_178723_h.field_78807_k = false;
                    shini.setBody(this.decodeCloakData(cloakVals, 0));
                    shini.setLeftArm(this.decodeCloakData(cloakVals, 1));
                    shini.setRightArm(this.decodeCloakData(cloakVals, 2));
                    shini.setColourScarf(this.decodeCloakData(cloakVals, 3) - 1);
                    shini.setBadge(this.decodeCloakData(cloakVals, 6));
                    shini.setWraps(this.decodeCloakData(cloakVals, 7));
                    shini.setBands(this.decodeCloakData(cloakVals, 8));
                    shini.BodySash1.field_78807_k = this.decodeCloakData(cloakVals, 11) == 0;
                    return shini;
                }
                if (armorSlot == EntityEquipmentSlot.LEGS) {
                    shini.field_178722_k.field_78806_j = true;
                    shini.field_178721_j.field_78806_j = true;
                    shini.field_178722_k.field_78807_k = false;
                    shini.field_178721_j.field_78807_k = false;
                    shini.setLeftLeg(this.decodeCloakData(cloakVals, 4) == 1);
                    shini.setRightLeg(this.decodeCloakData(cloakVals, 5) == 1);
                    return shini;
                }
            }
        }
        return null;
    }

    public int decodeCloakData(ItemStack stack, int index) {
        int[] curVals = this.getCLOAK(stack);
        return curVals[index];
    }

    public int decodeCloakData(int[] array, int index) {
        return array[index];
    }

    public void recodeCloakData(ItemStack stack, int index, int value) {
        if (index > 11) {
            return;
        }
        int[] newVals = this.getCLOAK(stack);
        int maxVal = 0;
        switch (index) {
            case 0: {
                maxVal = 6;
                break;
            }
            case 1: {
                maxVal = 6;
                break;
            }
            case 2: {
                maxVal = 6;
                break;
            }
            case 3: {
                maxVal = 16;
                break;
            }
            case 4: {
                maxVal = 1;
                break;
            }
            case 5: {
                maxVal = 1;
                break;
            }
            case 6: {
                maxVal = 2;
                break;
            }
            case 7: {
                maxVal = 3;
                break;
            }
            case 8: {
                maxVal = 3;
                break;
            }
            case 9: {
                maxVal = 1;
                break;
            }
            case 10: {
                maxVal = 16;
                break;
            }
            case 11: {
                maxVal = 1;
            }
        }
        if (value > maxVal) {
            value = index == 0 || index == 6 || index == 7 || index == 8 || index == 10 || index == 11 ? 0 : maxVal;
        } else if (value < 0) {
            value = 0;
        }
        newVals[index] = value;
        this.setCLOAK(stack, newVals);
    }

    public int[] getCLOAK(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_179543_a("data");
        if (nbttagcompound != null && nbttagcompound.func_74764_b("cloak")) {
            return nbttagcompound.func_74759_k("cloak");
        }
        return this.defaultCloak;
    }

    public ItemStack setCLOAK(ItemStack stack, int[] cloakData) {
        if (cloakData == null) {
            cloakData = this.defaultCloak;
        }
        stack.func_190925_c("data").func_74783_a("cloak", cloakData);
        return stack;
    }

    public boolean hasCLOAK(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_74764_b("data") ? nbttagcompound.func_74775_l("data").func_74764_b("cloak") : false;
    }

    public void addCLOAK(ItemStack stack) {
        if (!this.hasCLOAK(stack)) {
            this.setCLOAK(stack, this.defaultCloak);
        }
    }
}

