/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import littlebreadloaf.bleach_kd.armor.ItemBaseArmor;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemSoulChain
extends ItemBaseArmor {
    int depleteTimer = 40;
    public String chainData = "chainData";
    public String hollowActive = "hollowActive";

    public ItemSoulChain(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4) {
        super(par2, par3, par4, "soulchain");
        this.useArmorModel(21);
    }

    public String func_77653_i(ItemStack stack) {
        String name = ("" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
        if (this.getHollowActive(stack) == 1) {
            name = name + "!";
        }
        return name;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        return "bleach_kd".toLowerCase() + ":textures/models/armor/soul_chain.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean dimFlag;
        --this.depleteTimer;
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness"), 40, 0));
        boolean bl = dimFlag = player.field_71093_bK == BleachWorldGen.HuecoMundo_ID || player.field_71093_bK == BleachWorldGen.SoulSociety_ID;
        if (dimFlag) {
            // empty if block
        }
        if (!dimFlag) {
            if (props.isEnergyMoreThan(0) && this.depleteTimer <= 0) {
                this.depleteTimer = 40;
                if (!world.field_72995_K) {
                    props.consumeSpiritEnergy(3, player);
                }
            }
            if (this.getHollowActive(itemStack) == 1 && props.isEnergyLessThan(1) && this.depleteTimer <= 0) {
                this.depleteTimer = 40;
                if (!world.field_72995_K) {
                    player.func_70097_a(DamageSource.field_76376_m, 1.0f);
                }
            }
        }
    }

    public int getHollowActive(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return 0;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(this.chainData);
        return nbttagcompound1 == null ? 0 : (nbttagcompound1.func_74764_b(this.hollowActive) ? nbttagcompound1.func_74762_e(this.hollowActive) : 0);
    }

    public void setHollowActive(ItemStack stack, int extra) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(this.chainData);
        if (!nbttagcompound.func_74764_b(this.chainData)) {
            nbttagcompound.func_74782_a(this.chainData, (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a(this.hollowActive, 1);
        stack.func_151001_c(this.func_77653_i(stack));
    }
}

