/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.armor.IHollowMask;
import littlebreadloaf.bleach_kd.armor.ItemBaseArmor;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemWaspHelmet
extends ItemBaseArmor
implements IHollowMask {
    int depleteTimer = 40;

    public ItemWaspHelmet(ItemArmor.ArmorMaterial par2, int par3, EntityEquipmentSlot par4) {
        super(par2, par3, par4, "waspmask");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String layer) {
        return "bleach_kd".toLowerCase() + ":textures/models/armor/mask_wasp_player.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        --this.depleteTimer;
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        if (props.isEnergyMoreThan(0) && this.depleteTimer <= 0) {
            this.depleteTimer = 40;
            if (!world.field_72995_K) {
                props.consumeSpiritEnergy(2, player);
            }
        }
    }

    @Override
    public int getJumpBoost() {
        return 0;
    }

    @Override
    public int getSpeedBoost() {
        return 0;
    }

    @Override
    public int getAttackBoost() {
        return 0;
    }

    @Override
    public void specialAttackEffect(EntityLivingBase wearer, EntityLivingBase attackee) {
        if (wearer instanceof EntityPlayer) {
            int amount = 2;
            if (attackee.func_70668_bt() == Tools.SPIRIT) {
                ++amount;
            }
            IBleachPlayerCap propsWearer = (IBleachPlayerCap)((EntityPlayer)wearer).getCapability(BleachProvider.BLEACH_CAP, null);
            if (!wearer.field_70170_p.field_72995_K) {
                propsWearer.replenishSpiritEnergy(amount);
            }
        }
        if (attackee instanceof EntityPlayer) {
            IBleachPlayerCap propsAttackee = (IBleachPlayerCap)((EntityPlayer)attackee).getCapability(BleachProvider.BLEACH_CAP, null);
            if (!attackee.field_70170_p.field_72995_K) {
                propsAttackee.consumeSpiritEnergy(3, (EntityPlayer)attackee);
            }
        }
    }
}

