/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.blocks;

import java.util.Random;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.blocks.BleachBlockBase;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import littlebreadloaf.bleach_kd.world.HuecoMundoTeleporter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHuecoShadow
extends BleachBlockBase {
    protected static final AxisAlignedBB CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    protected BlockHuecoShadow() {
        super(Material.field_151567_E.func_76231_i(), "hueco_shadow");
        this.func_149715_a(0.1f);
        this.func_149675_a(true);
        this.setLayerType(3);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return this.field_149764_J.func_76222_j();
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && world.func_175724_o(pos) < 0.4f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CARPET_AABB;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canBlockStay(world, pos) && !world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? true : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player != null) {
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (player.func_184586_b(hand) == null && player.func_70093_af() && BleachConfiguration.allowShadowTeleport) {
                if (props.isHollow() && props.getAbilityLevel(4) >= 2 && props.getMaxSpirit() >= 75 && props.isEnergyMoreThan(25) && !BleachConfiguration.removeGargantaRequirements || BleachConfiguration.removeGargantaRequirements) {
                    props.consumeSpiritEnergy(25, player);
                    if (!player.field_70170_p.field_72995_K && player.field_71093_bK == BleachWorldGen.HuecoMundo_ID) {
                        player.changeDimension(0, (ITeleporter)HuecoMundoTeleporter.getTeleporterForDim(player.func_184102_h(), 0));
                    }
                }
                return true;
            }
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        for (int l = 0; l < 1; ++l) {
            double d0 = (float)x + rand.nextFloat();
            double d1 = (float)y + rand.nextFloat() * 0.5f;
            double d2 = (float)z + rand.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int i1 = rand.nextInt(2) * 2 - 1;
            d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            if (world.func_180495_p(new BlockPos(x - 1, y, z)) != this && world.func_180495_p(new BlockPos(x + 1, y, z)) != this) {
                d0 = (double)x + 0.5 + 0.25 * (double)i1;
                d3 = rand.nextFloat() * 2.0f * (float)i1;
            } else {
                d2 = (double)z + 0.5 + 0.25 * (double)i1;
                d5 = rand.nextFloat() * 2.0f * (float)i1;
            }
            world.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }
}

