/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.blocks;

import java.util.Random;
import littlebreadloaf.bleach_kd.blocks.BleachBlockBase;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHuecoStone
extends BleachBlockBase {
    protected BlockHuecoStone() {
        super(Material.field_151576_e, "hueco_stone");
        this.func_149675_a(true);
    }

    public int func_149738_a(World par1World) {
        return 2000;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.shadowCode(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), new Random(), true);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.shadowCode(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rand, false);
    }

    public void shadowCode(World world, int x, int y, int z, Random rand, boolean destroyCheck) {
        int range;
        BlockPos pos = new BlockPos(x, y, z);
        int count = 1;
        for (int i = 1; i < 7; ++i) {
            if (!(world.func_180495_p(pos.func_177984_a()) instanceof BlockStone)) continue;
            ++count;
        }
        int n = range = count == 1 ? 2 : (count - 1) * 2;
        if (world.func_72935_r() || destroyCheck) {
            for (int i = 0; i < range + 1; ++i) {
                for (int j = 0; j < range + 1; ++j) {
                    int a = x + i - range / 2;
                    int b = z + j - range / 2;
                    BlockPos newPos = new BlockPos(a, y, b);
                    Block block = world.func_180495_p(newPos).func_177230_c();
                    if (block != BleachBlocks.huecoShadow) continue;
                    world.func_175698_g(newPos);
                }
            }
            if (destroyCheck) {
                return;
            }
        } else if (!world.func_72935_r()) {
            for (int i = 0; i < range + 1; ++i) {
                for (int j = 0; j < range + 1; ++j) {
                    int a = x + i - range / 2;
                    int b = z + j - range / 2;
                    boolean skip = false;
                    if (i == range && j == range) {
                        skip = true;
                    }
                    if (i == range && j == range - 1) {
                        skip = true;
                    }
                    if (i == range && j == 0) {
                        skip = true;
                    }
                    if (i == range && j == 1) {
                        skip = true;
                    }
                    if (i == range - 1 && j == range) {
                        skip = true;
                    }
                    if (i == range - 1 && j == 0) {
                        skip = true;
                    }
                    if (i == 0 && j == range) {
                        skip = true;
                    }
                    if (i == 0 && j == range - 1) {
                        skip = true;
                    }
                    if (i == 0 && j == 0) {
                        skip = true;
                    }
                    if (i == 0 && j == 1) {
                        skip = true;
                    }
                    if (i == 1 && j == range) {
                        skip = true;
                    }
                    if (i == 1 && j == 0) {
                        skip = true;
                    }
                    if (skip) continue;
                    BlockPos newPos = new BlockPos(a, y, b);
                    boolean air = world.func_175623_d(newPos);
                    boolean light = world.func_175724_o(newPos) < 0.4f;
                    boolean blockBelow = world.isSideSolid(newPos.func_177977_b(), EnumFacing.UP);
                    if (!air || !light || !blockBelow) continue;
                    world.func_175656_a(newPos, BleachBlocks.huecoShadow.func_176223_P());
                }
            }
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int par3) {
        return Item.func_150898_a((Block)Blocks.field_150347_e);
    }
}

