/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.blocks;

import java.util.Random;
import littlebreadloaf.bleach_kd.blocks.BleachBlockBase;
import littlebreadloaf.bleach_kd.items.BleachItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPoisonShroom
extends BleachBlockBase {
    protected static final AxisAlignedBB MUSHROOM_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.4f, (double)0.7f);
    int iceMeltTimer = 1200;

    protected BlockPoisonShroom() {
        super(Material.field_151585_k, "poison_shroom");
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean func_176196_c(World par1World, BlockPos pos) {
        return super.func_176196_c(par1World, pos) && this.canBlockStay(par1World, pos, par1World.func_180495_p(pos));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MUSHROOM_AABB;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos thisPos, BlockPos neighbourPos) {
        super.onNeighborChange(world, thisPos, neighbourPos);
        this.checkFlowerChange((World)world, thisPos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    protected final void checkFlowerChange(World par1World, BlockPos pos) {
        if (!this.canBlockStay(par1World, pos, par1World.func_180495_p(pos))) {
            this.checkAndDropBlock(par1World, pos, par1World.func_180495_p(pos));
            this.func_176226_b(par1World, pos, par1World.func_180495_p(pos), 0);
            par1World.func_175698_g(pos);
        }
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean canBlockStay(World par1World, BlockPos pos, IBlockState state) {
        return par1World.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c ? true : par1World.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150346_d;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)entity;
            ItemStack heldMain = ent.func_184614_ca();
            ItemStack heldOff = ent.func_184592_cb();
            boolean flag = true;
            if (heldMain != null && heldMain.func_77973_b() == BleachItems.shikaipoison || heldOff != null && heldOff.func_77973_b() == BleachItems.shikaipoison) {
                flag = false;
            }
            if (ent.func_70660_b(Potion.func_180142_b((String)"poison")) == null && flag) {
                ent.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), 200, 0));
                world.func_175698_g(pos);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkFlowerChange(worldIn, pos);
        --this.iceMeltTimer;
        if (this.iceMeltTimer < 0) {
            worldIn.func_175698_g(pos);
            worldIn.func_180497_b(pos, (Block)this, 10, 2);
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }
}

