/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities;

import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.entities.BleachEntityList;
import littlebreadloaf.bleach_kd.entities.EntityCero;
import littlebreadloaf.bleach_kd.entities.EntityCeroCharge;
import littlebreadloaf.bleach_kd.entities.EntityDecoy;
import littlebreadloaf.bleach_kd.entities.EntityEnergyArrow;
import littlebreadloaf.bleach_kd.entities.EntityGetsuga;
import littlebreadloaf.bleach_kd.entities.EntityHellButterfly;
import littlebreadloaf.bleach_kd.entities.EntitySeeleArrow;
import littlebreadloaf.bleach_kd.entities.EntityShinigami;
import littlebreadloaf.bleach_kd.entities.EntityShotBlock;
import littlebreadloaf.bleach_kd.entities.EntityTestDummy;
import littlebreadloaf.bleach_kd.entities.EntityWhole;
import littlebreadloaf.bleach_kd.entities.hollows.EntityAdjuchasBasic;
import littlebreadloaf.bleach_kd.entities.hollows.EntityFisher;
import littlebreadloaf.bleach_kd.entities.hollows.EntityGillianMenos;
import littlebreadloaf.bleach_kd.entities.hollows.EntityGillianMenosGrande;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowBat;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowBird;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowBlaze;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowGolem;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowHoneyBadger;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowLizard;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowMantis;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowMonkey;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowOre;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowPterodactyl;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowScorpion;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowSnake;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowSpider;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowStalker;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowWasp;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowWolf;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowWorm;
import littlebreadloaf.bleach_kd.entities.hollows.EntitySmallHollowLizard;
import littlebreadloaf.bleach_kd.world.biomes.BleachBiomes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BleachEntities {
    static EntityEntry whole = BleachEntities.createEntityMapped(EntityWhole.class, "Whole", 0, 0x3366CC, 0x3300CC);
    static EntityEntry hollowBat = BleachEntities.createEntityMapped(EntityHollowBat.class, "HollowBat", 1, 0, 11735573);
    static EntityEntry hollowBlaze = BleachEntities.createEntityMapped(EntityHollowBlaze.class, "HollowBlaze", 2, 0, 3978097);
    static EntityEntry hollowSpider = BleachEntities.createEntityMapped(EntityHollowSpider.class, "HollowSpider", 3, 0, 1644912);
    static EntityEntry hollowGolem = BleachEntities.createEntityMapped(EntityHollowGolem.class, "HollowGolem", 4, 0x8B0000, 0xFFFFF0);
    static EntityEntry hollowSnake = BleachEntities.createEntityMapped(EntityHollowSnake.class, "HollowSnake", 5, 39219, 15787660);
    static EntityEntry hollowWasp = BleachEntities.createEntityMapped(EntityHollowWasp.class, "HollowWasp", 6, 0, 0xFFCC33);
    static EntityEntry hollowStalker = BleachEntities.createEntityMapped(EntityHollowStalker.class, "HollowStalker", 7, 0, 6506099);
    static EntityEntry hollowOre = BleachEntities.createEntityMapped(EntityHollowOre.class, "HollowOre", 8, 0, 357785);
    static EntityEntry hollowWolf = BleachEntities.createEntityMapped(EntityHollowWolf.class, "HollowWolf", 9, 1644912, 6506099);
    static EntityEntry hollowSmallGecko = BleachEntities.createEntityMapped(EntitySmallHollowLizard.class, "SmallHollowLizard", 10, 9127187, 0xB22222);
    static EntityEntry gillianMenos = BleachEntities.createEntityMapped(EntityGillianMenosGrande.class, "MenosGrande", 11, 0, 0xFFFFFF);
    static EntityEntry hollowGrandFisher = BleachEntities.createEntityMapped(EntityFisher.class, "Fisher", 12, 0, 0x663300);
    static EntityEntry decoy = BleachEntities.createEntityMapped(EntityDecoy.class, "Decoy", 13, 0, 0);
    static EntityEntry shinigami = BleachEntities.createEntityMapped(EntityShinigami.class, "Shinigami", 14, 0, 6779513);
    static EntityEntry hollowScorpion = BleachEntities.createEntityMapped(EntityHollowScorpion.class, "HollowScorpion", 15, 0xFADDFF, 5736078);
    static EntityEntry hollowLizard = BleachEntities.createEntityMapped(EntityHollowLizard.class, "HollowLizard", 16, 0xFADDFF, 1149838);
    static EntityEntry hollowMonkey = BleachEntities.createEntityMapped(EntityHollowMonkey.class, "HollowMonkey", 17, 0xFADDFF, 5660722);
    static EntityEntry hollowMantis = BleachEntities.createEntityMapped(EntityHollowMantis.class, "HollowMantis", 18, 0xFADDFF, 1933949);
    static EntityEntry hollowPterodactyl = BleachEntities.createEntityMapped(EntityHollowPterodactyl.class, "HollowPterodactyl", 19, 0xFADDFF, 14382390);
    static EntityEntry hollowHoneyBadger = BleachEntities.createEntityMapped(EntityHollowHoneyBadger.class, "HollowHoneyBadger", 20, 0xFADDFF, 9647436);
    static EntityEntry hellButterfly = BleachEntities.createEntityMapped(EntityHellButterfly.class, "HellButterfly", 21, 0xFFFFFF, 16440798);
    static EntityEntry adjuchasBasic = BleachEntities.createEntityMapped(EntityAdjuchasBasic.class, "HollowAdjuchasBasic", 22, 0xFFFFFF, 3978097);
    static EntityEntry testDummy = BleachEntities.createEntityMapped(EntityTestDummy.class, "TestDummy", 23, 15945522, 3407729);
    static EntityEntry gillianMenosGrande = BleachEntities.createEntityMapped(EntityGillianMenos.class, "GillianMenos", 24, 0xFFFFFF, 5219965);
    static EntityEntry hollowBird = BleachEntities.createEntityMapped(EntityHollowBird.class, "HollowBird", 25, 0, 4063011);
    static EntityEntry hollowWorm = BleachEntities.createEntityMapped(EntityHollowWorm.class, "HollowWorm", 26, 0, 11285727);
    static EntityEntry energyArrow = BleachEntities.createEntityMapped(EntityEnergyArrow.class, "EnergyArrow", 100);
    static EntityEntry seeleArrow = BleachEntities.createEntityMapped(EntitySeeleArrow.class, "SeeleArrow", 101);
    static EntityEntry getsugaWave = BleachEntities.createEntityMapped(EntityGetsuga.class, "Getsuga", 102);
    static EntityEntry shotBlock = BleachEntities.createEntityMapped(EntityShotBlock.class, "EntityShotBlock", 103);
    static EntityEntry ceroBeam = BleachEntities.createEntityMapped(EntityCero.class, "EntityCero", 105);
    static EntityEntry ceroCharge = BleachEntities.createEntityMapped(EntityCeroCharge.class, "EntityCeroCharge", 106);

    public static EntityEntry createEntityMapped(Class<? extends Entity> entityClass, String entityName, int randomID) {
        ResourceLocation resLoc = new ResourceLocation("bleach_kd", "entity_" + randomID);
        EntityEntry entry = EntityEntryBuilder.create().entity(entityClass).id(resLoc, randomID).name(entityName).tracker(80, 3, true).build();
        BleachEntityList.addMapping(entityClass, resLoc, randomID);
        return entry;
    }

    public static EntityEntry createEntityMap(Class<? extends Entity> entityClass, String entityName, int randomID, int solidColour, int spotColour) {
        Biome[] basic = new Biome[]{Biomes.field_76767_f};
        return BleachEntities.createEntityMapped(entityClass, entityName, randomID, solidColour, spotColour, EnumCreatureType.AMBIENT, 0, 0, 0, basic);
    }

    public static EntityEntry createEntityMap2(Class<? extends Entity> entityClass, String entityName, int randomID, int solidColour, int spotColour) {
        return BleachEntities.createEntityMapped(entityClass, entityName, randomID, solidColour, spotColour);
    }

    public static EntityEntry createEntityMapped(Class<? extends Entity> entityClass, String entityName, int randomID, int solidColour, int spotColour, EnumCreatureType type, int weight, int min, int max, Biome[] biome) {
        ResourceLocation resLoc = new ResourceLocation("bleach_kd", "entity_" + randomID);
        EntityEntry entry = EntityEntryBuilder.create().entity(entityClass).id(resLoc, randomID).name(entityName).tracker(80, 3, true).spawn(type, weight, min, max, biome).egg(solidColour, spotColour).build();
        BleachEntityList.addMapping(entityClass, resLoc, randomID, solidColour, spotColour);
        return entry;
    }

    public static EntityEntry createEntityMapped(Class<? extends Entity> entityClass, String entityName, int randomID, int solidColour, int spotColour) {
        ResourceLocation resLoc = new ResourceLocation("bleach_kd", "entity_" + randomID);
        EntityEntry entry = EntityEntryBuilder.create().entity(entityClass).id(resLoc, randomID).name(entityName).tracker(80, 3, true).egg(solidColour, spotColour).build();
        BleachEntityList.addMapping(entityClass, resLoc, randomID, solidColour, spotColour);
        return entry;
    }

    public static void addSpawns() {
        if (!BleachConfiguration.disableOtherSpawns) {
            EntityRegistry.addSpawn(EntityShinigami.class, (int)1, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityShinigami.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76787_r, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150577_O, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150576_N, Biomes.field_76780_h, Biomes.field_76768_g, Biomes.field_76784_u});
            EntityRegistry.addSpawn(EntityHellButterfly.class, (int)10, (int)0, (int)3, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_76785_t, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_76767_f});
            EntityRegistry.addSpawn(EntityWhole.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76787_r, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150577_O, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150576_N, Biomes.field_76780_h, Biomes.field_76768_g, Biomes.field_76784_u});
        }
        if (!BleachConfiguration.disableHollowSpawns) {
            int spawnRate = BleachConfiguration.spawnRate;
            Biome[] basicList = new Biome[]{BleachBiomes.HuecoMundoBase, Biomes.field_76787_r, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150577_O, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150576_N, Biomes.field_76780_h, Biomes.field_76768_g, Biomes.field_76784_u};
            EntityRegistry.addSpawn(EntityHollowBat.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowBlaze.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowSpider.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowGolem.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowSnake.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowWasp.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowStalker.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowOre.class, (int)Math.round(spawnRate / 6), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntityHollowWolf.class, (int)spawnRate, (int)2, (int)5, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])basicList);
            EntityRegistry.addSpawn(EntitySmallHollowLizard.class, (int)(spawnRate * 4), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityGillianMenosGrande.class, (int)Math.round(5 * spawnRate / 3), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityFisher.class, (int)Math.round(4 * spawnRate / 3), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase, Biomes.field_76778_j});
            EntityRegistry.addSpawn(EntityDecoy.class, (int)Math.round(3 * spawnRate / 2), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76787_r, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150577_O, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150576_N, Biomes.field_76780_h, Biomes.field_76768_g, Biomes.field_76784_u});
            EntityRegistry.addSpawn(EntityHollowScorpion.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowLizard.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowWorm.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowBird.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowMonkey.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase, Biomes.field_76787_r, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150577_O, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150576_N, Biomes.field_76780_h, Biomes.field_76768_g, Biomes.field_76784_u});
            EntityRegistry.addSpawn(EntityHollowMantis.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowPterodactyl.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowHoneyBadger.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase, Biomes.field_76787_r, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150577_O, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76776_l, Biomes.field_76777_m, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_76772_c, Biomes.field_76781_i, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150576_N, Biomes.field_76780_h, Biomes.field_76768_g, Biomes.field_76784_u});
            EntityRegistry.addSpawn(EntityGillianMenos.class, (int)Math.round(spawnRate / 3), (int)0, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowBird.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
            EntityRegistry.addSpawn(EntityHollowWorm.class, (int)spawnRate, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{BleachBiomes.HuecoMundoBase});
        }
    }

    @Mod.EventBusSubscriber(modid="bleach_kd")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<EntityEntry> event) {
            event.getRegistry().register((IForgeRegistryEntry)whole);
            event.getRegistry().register((IForgeRegistryEntry)hollowBat);
            event.getRegistry().register((IForgeRegistryEntry)hollowBlaze);
            event.getRegistry().register((IForgeRegistryEntry)hollowSpider);
            event.getRegistry().register((IForgeRegistryEntry)hollowGolem);
            event.getRegistry().register((IForgeRegistryEntry)hollowSnake);
            event.getRegistry().register((IForgeRegistryEntry)hollowWasp);
            event.getRegistry().register((IForgeRegistryEntry)hollowStalker);
            event.getRegistry().register((IForgeRegistryEntry)hollowOre);
            event.getRegistry().register((IForgeRegistryEntry)hollowWolf);
            event.getRegistry().register((IForgeRegistryEntry)hollowSmallGecko);
            event.getRegistry().register((IForgeRegistryEntry)gillianMenos);
            event.getRegistry().register((IForgeRegistryEntry)hollowGrandFisher);
            event.getRegistry().register((IForgeRegistryEntry)decoy);
            event.getRegistry().register((IForgeRegistryEntry)shinigami);
            event.getRegistry().register((IForgeRegistryEntry)hollowScorpion);
            event.getRegistry().register((IForgeRegistryEntry)hollowLizard);
            event.getRegistry().register((IForgeRegistryEntry)hollowMonkey);
            event.getRegistry().register((IForgeRegistryEntry)hollowMantis);
            event.getRegistry().register((IForgeRegistryEntry)hollowPterodactyl);
            event.getRegistry().register((IForgeRegistryEntry)hollowHoneyBadger);
            event.getRegistry().register((IForgeRegistryEntry)hellButterfly);
            event.getRegistry().register((IForgeRegistryEntry)adjuchasBasic);
            event.getRegistry().register((IForgeRegistryEntry)testDummy);
            event.getRegistry().register((IForgeRegistryEntry)gillianMenosGrande);
            event.getRegistry().register((IForgeRegistryEntry)hollowBird);
            event.getRegistry().register((IForgeRegistryEntry)hollowWorm);
            event.getRegistry().register((IForgeRegistryEntry)energyArrow);
            event.getRegistry().register((IForgeRegistryEntry)seeleArrow);
            event.getRegistry().register((IForgeRegistryEntry)getsugaWave);
            event.getRegistry().register((IForgeRegistryEntry)shotBlock);
            event.getRegistry().register((IForgeRegistryEntry)ceroBeam);
            event.getRegistry().register((IForgeRegistryEntry)ceroCharge);
        }
    }
}

