/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BleachEntityList {
    private static final Logger logger = LogManager.getLogger();
    public static Map<String, Class<?>> stringToClassMapping = new HashMap();
    public static Map<Class<?>, String> classToStringMapping = new HashMap();
    public static Map<Integer, Class<?>> IDtoClassMapping = new HashMap();
    private static Map<Class<?>, Integer> classToIDMapping = new HashMap();
    private static Map<String, Integer> stringToIDMapping = new HashMap<String, Integer>();
    public static final Map<ResourceLocation, EntityEggInfo> ENTITY_EGGS = Maps.newLinkedHashMap();

    public static void addMapping(Class<?> par1Class, ResourceLocation resLoc, int par3Id) {
        String par2String = resLoc.toString();
        if (stringToClassMapping.containsKey(par2String)) {
            throw new IllegalArgumentException("ID is already registered: " + par2String);
        }
        if (IDtoClassMapping.containsKey(par3Id)) {
            throw new IllegalArgumentException("ID is already registered: " + par3Id);
        }
        stringToClassMapping.put(par2String, par1Class);
        classToStringMapping.put(par1Class, par2String);
        IDtoClassMapping.put(par3Id, par1Class);
        classToIDMapping.put(par1Class, par3Id);
        stringToIDMapping.put(par2String, par3Id);
    }

    public static void addMapping(Class entity, ResourceLocation resLoc, int id, int solidColour, int spotcolour) {
        BleachEntityList.addMapping(entity, resLoc, id);
        BleachEntityList.addSpawnInfo(resLoc, solidColour, spotcolour);
    }

    protected static EntityEggInfo addSpawnInfo(ResourceLocation id, int primaryColor, int secondaryColor) {
        ResourceLocation resourcelocation = id;
        EntityEggInfo egg = new EntityEggInfo(resourcelocation, primaryColor, secondaryColor);
        return ENTITY_EGGS.put(resourcelocation, egg);
    }

    public static Entity createEntityByName(String name, World world) {
        Entity entity = null;
        try {
            Class<?> oclass = stringToClassMapping.get(name);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound compound, World world) {
        Entity entity = null;
        if ("Minecart".equals(compound.func_74779_i("id"))) {
            switch (compound.func_74762_e("Type")) {
                case 0: {
                    compound.func_74778_a("id", "MinecartRideable");
                    break;
                }
                case 1: {
                    compound.func_74778_a("id", "MinecartChest");
                    break;
                }
                case 2: {
                    compound.func_74778_a("id", "MinecartFurnace");
                }
            }
            compound.func_82580_o("Type");
        }
        Class<?> oclass = null;
        try {
            oclass = stringToClassMapping.get(compound.func_74779_i("id"));
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            try {
                entity.func_70020_e(compound);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{compound.func_74779_i("id"), oclass.getName()});
                entity = null;
            }
        } else {
            logger.warn("Skipping Entity with id " + compound.func_74779_i("id"));
        }
        return entity;
    }

    @Nullable
    public static Entity createEntityByIDFromName(ResourceLocation name, World worldIn) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(name);
        return entry == null ? null : entry.newInstance(worldIn);
    }

    public static Entity createEntityByID(int entityid, World world) {
        Entity entity = null;
        try {
            Class oclass = BleachEntityList.getClassFromID(entityid);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            logger.warn("Skipping Entity with id " + entityid);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        Class<?> oclass = entity.getClass();
        return classToIDMapping.containsKey(oclass) ? classToIDMapping.get(oclass) : 0;
    }

    public static Class getClassFromID(int entityid) {
        return IDtoClassMapping.get(entityid);
    }

    public static String getEntityString(Entity entityName) {
        return classToStringMapping.get(entityName.getClass());
    }

    public static String getStringFromID(int p_75617_0_) {
        Class oclass = BleachEntityList.getClassFromID(p_75617_0_);
        return oclass != null ? classToStringMapping.get(oclass) : null;
    }

    public static void func_151514_a() {
    }

    public static Set func_151515_b() {
        return Collections.unmodifiableSet(stringToIDMapping.keySet());
    }

    @Nullable
    public static String getTranslationName(@Nullable ResourceLocation entityType) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityType);
        return entry == null ? null : entry.getName();
    }

    public static class EntityEggInfo {
        public final ResourceLocation spawnedID;
        public final int primaryColour;
        public final int secondaryColour;

        public EntityEggInfo(ResourceLocation resourcelocation, int solidColour, int spotColour) {
            this.spawnedID = resourcelocation;
            this.primaryColour = solidColour;
            this.secondaryColour = spotColour;
        }
    }
}

