/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.BleachMod;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.network.ParticleMessage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCero
extends Entity
implements IProjectile {
    private static final Predicate<Entity> CERO_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    public double startingX;
    public double startingY;
    public double startingZ;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData = 0;
    private boolean inGround = false;
    public Entity shootingEntity;
    private double damage = 10.0;
    private double damageboost;
    private int inGroundTick = 0;

    public EntityCero(World var1) {
        super(var1);
    }

    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    public EntityCero(World var1, Entity var2, EntityLivingBase var4) {
        this(var1);
        this.shootingEntity = var4;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(var2.field_70165_t, var2.field_70163_u, var2.field_70161_v);
        this.startingX = this.field_70165_t;
        this.startingY = this.field_70163_u;
        this.startingZ = this.field_70161_v;
        Vec3d lookVec = var4.func_70676_i(1.0f);
        float speedScale = 2.0f;
        this.func_70016_h(lookVec.field_72450_a * (double)speedScale, lookVec.field_72448_b * (double)speedScale, lookVec.field_72449_c * (double)speedScale);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_70088_a() {
    }

    public void func_70016_h(double var1, double var3, double var5) {
        this.field_70159_w = var1;
        this.field_70181_x = var3;
        this.field_70179_y = var5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        Entity entity;
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        int ar1 = MathHelper.func_76128_c((double)this.field_70163_u);
        int ar2 = MathHelper.func_76128_c((double)this.field_70165_t);
        int ar3 = MathHelper.func_76128_c((double)this.field_70161_v);
        this.xTile = ar1;
        this.yTile = ar2;
        this.zTile = ar3;
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.inGround) {
            ++this.inGroundTick;
            if (this.inGroundTick > 6) {
                this.func_70106_y();
            }
        }
        if (this.field_70173_aa > 10) {
            this.func_70106_y();
        }
        for (int ar5 = -1; ar5 <= 1; ++ar5) {
            for (int ar6 = -1; ar6 <= 1; ++ar6) {
                for (int ar7 = -2; ar7 <= 2; ++ar7) {
                    int ar8 = ar2 + ar5;
                    int ar9 = ar1 + ar7;
                    int ar10 = ar3 + ar6;
                    BlockPos blocksPos = new BlockPos(ar8, ar9, ar10);
                    Block block1 = this.field_70170_p.func_180495_p(blocksPos).func_177230_c();
                    if (this.field_70146_Z.nextBoolean() && !this.field_70170_p.field_72995_K && this.shootingEntity instanceof EntityPlayer) {
                        BleachMod.network.sendToAll((IMessage)new ParticleMessage(0, ar8, ar9, ar10));
                    }
                    if (this.field_70170_p.field_72995_K || block1 == null || block1 == Blocks.field_150357_h || block1 == Blocks.field_150343_Z || block1 == Blocks.field_150427_aO || block1 == BleachBlocks.reiatsuBlock || block1 == BleachBlocks.soulQuartzBlock) continue;
                    int cero = BleachConfiguration.ceroBlockDestruction;
                    boolean griefFlag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                    if (cero != 0 && (cero != 2 || !griefFlag)) continue;
                    this.field_70170_p.func_175698_g(blocksPos);
                }
            }
        }
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70014_b(NBTTagCompound var1) {
        var1.func_74777_a("xTile", (short)this.xTile);
        var1.func_74777_a("yTile", (short)this.yTile);
        var1.func_74777_a("zTile", (short)this.zTile);
        var1.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        var1.func_74774_a("inData", (byte)this.inData);
        var1.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        var1.func_74780_a("damage", this.damage);
    }

    public void func_70037_a(NBTTagCompound var1) {
        this.xTile = var1.func_74765_d("xTile");
        this.yTile = var1.func_74765_d("yTile");
        this.zTile = var1.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(var1.func_74771_c("inTile") & 0xFF));
        this.inData = var1.func_74771_c("inData") & 0xFF;
        boolean bl = this.inGround = var1.func_74771_c("inGround") == 1;
        if (var1.func_74764_b("damage")) {
            this.damage = var1.func_74769_h("damage");
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float getShadowSize() {
        return 0.0f;
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), CERO_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            int i;
            DamageSource damagesource;
            if (entity instanceof EntityLivingBase) {
                double ddamage;
                int sxpToAdd = 0;
                int hollowsxpToAdd = 0;
                double spirit = 0.0;
                EntityLivingBase entLiving = (EntityLivingBase)entity;
                if (entLiving.func_70668_bt() == Tools.SPIRIT) {
                    ++sxpToAdd;
                    this.damageboost += 2.0;
                }
                if (this.shootingEntity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.shootingEntity;
                    IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
                    if (props.fullArrancar(player)) {
                        ++sxpToAdd;
                        hollowsxpToAdd += 2;
                        this.damageboost += 2.0;
                    }
                    if (!player.field_70170_p.field_72995_K) {
                        spirit = props.getMaxSpirit() / 100;
                        props.addSXP(++sxpToAdd);
                        props.addSXP(3 + hollowsxpToAdd, 3);
                    }
                }
                ddamage = (ddamage = this.damageboost + spirit) > 20.0 ? 20.0 : ddamage;
                this.setDamage(this.damage + ddamage);
            }
            if (entity.func_70097_a(damagesource = this.shootingEntity == null ? DamageSource.func_76354_b((Entity)this, (Entity)this) : DamageSource.func_76354_b((Entity)this, (Entity)this.shootingEntity), (float)(i = MathHelper.func_76143_f((double)this.getDamage())))) {
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            }
            this.func_70106_y();
        } else {
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.inGround = true;
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
    }
}

