/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.entities.EntityCero;
import littlebreadloaf.bleach_kd.entities.IBleachEntity;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityCeroCharge
extends Entity {
    public EntityLivingBase shootingEntity;
    public String shootingEntityName;
    private int charge;
    private int maxCharge;
    private float maxScale;

    public EntityCeroCharge(World worldIn) {
        super(worldIn);
    }

    public EntityCeroCharge(World worldIn, EntityLivingBase entity) {
        this(worldIn);
        this.shootingEntity = entity;
        this.shootingEntityName = entity instanceof EntityPlayer ? entity.func_70005_c_() : entity.func_110124_au().toString();
        this.maxScale = entity.field_70131_O * 0.75f;
        this.maxCharge = this.setMaxCharge(entity);
    }

    public int setMaxCharge(EntityLivingBase entity) {
        IBleachEntity blEntity;
        int max;
        int chargeToSet = 0;
        chargeToSet = entity instanceof IBleachEntity ? (max = (max = (blEntity = (IBleachEntity)entity).getSPEnergy() / 5) > 140 ? 140 : max) : 100;
        return chargeToSet;
    }

    public int getCharge() {
        return this.charge;
    }

    public int getMaxCharge() {
        return this.maxCharge;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.shootingEntity == null || this.shootingEntity.field_70128_L) {
                this.func_70106_y();
            } else {
                EntityPlayer player;
                IBleachPlayerCap props;
                if (this.shootingEntity.field_70173_aa - this.shootingEntity.func_142015_aE() < 20) {
                    this.func_70106_y();
                }
                if (this.shootingEntity instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)this.shootingEntity).getCapability(BleachProvider.BLEACH_CAP, null)).getTrackedData(1) != 3) {
                    this.func_70106_y();
                }
                this.infrontUser(this.shootingEntity);
                ++this.charge;
                if (this.shootingEntity instanceof EntityPlayer && this.charge % 20 == 0) {
                    player = (EntityPlayer)this.shootingEntity;
                    props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
                    props.consumeSpiritEnergy(10, player);
                }
                if (this.getCharge() >= this.getMaxCharge()) {
                    EntityCero cero = new EntityCero(this.field_70170_p, this, this.getShootingEntity());
                    this.field_70170_p.func_72838_d((Entity)cero);
                    this.func_184185_a(BleachSounds.bowfire, 0.4f, 1.0f);
                    this.func_70106_y();
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70106_y() {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (this.shootingEntity instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)this.shootingEntity).getCapability(BleachProvider.BLEACH_CAP, null)).getTrackedData(1) == 3) {
            props.setTrackedData(1, -1);
        }
        super.func_70106_y();
    }

    protected void infrontUser(EntityLivingBase user) {
        if (user != null) {
            float f = -MathHelper.func_76126_a((float)(user.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(user.field_70125_A * ((float)Math.PI / 180)));
            float f1 = -MathHelper.func_76126_a((float)(user.field_70125_A * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(user.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(user.field_70125_A * ((float)Math.PI / 180)));
            double xVal = user.field_70165_t + (double)f;
            double yVal = user.field_70163_u + 1.0 + (double)user.field_70131_O + (double)f1;
            double zVal = user.field_70161_v + (double)f2;
            this.func_70107_b(xVal, yVal, zVal);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("charge", this.getCharge());
        compound.func_74768_a("maxCharge", this.getMaxCharge());
        compound.func_74776_a("maxScale", this.getMaxScale());
        compound.func_74778_a("shootingEntityName", this.getShootingEntity().func_70005_c_());
        if ((this.shootingEntityName == null || this.shootingEntityName.isEmpty()) && this.shootingEntity instanceof EntityPlayer) {
            this.shootingEntityName = this.shootingEntity.func_70005_c_();
        }
        compound.func_74778_a("shootingEntityName", this.shootingEntityName == null ? "" : this.shootingEntityName);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.charge = compound.func_74762_e("charge");
        this.maxCharge = compound.func_74762_e("maxCharge");
        this.maxScale = compound.func_74760_g("maxScale");
        this.shootingEntity = null;
        this.shootingEntityName = compound.func_74779_i("shootingEntityName");
        if (this.shootingEntityName != null && this.shootingEntityName.isEmpty()) {
            this.shootingEntityName = null;
        }
        this.shootingEntity = this.getShootingEntity();
    }

    @Nullable
    public EntityLivingBase getShootingEntity() {
        if (this.shootingEntity == null && this.shootingEntityName != null && !this.shootingEntityName.isEmpty()) {
            this.shootingEntity = this.field_70170_p.func_72924_a(this.shootingEntityName);
            if (this.shootingEntity == null && this.field_70170_p instanceof WorldServer) {
                try {
                    Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(UUID.fromString(this.shootingEntityName));
                    if (entity instanceof EntityLivingBase) {
                        this.shootingEntity = (EntityLivingBase)entity;
                    }
                }
                catch (Throwable var2) {
                    this.shootingEntity = null;
                }
            }
        }
        return this.shootingEntity;
    }
}

