/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities;

import java.util.Random;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.ItemShiniCaptain;
import littlebreadloaf.bleach_kd.entities.EntityBleachBiped;
import littlebreadloaf.bleach_kd.entities.hollows.BleachShinigamiAINearestAttackableTarget;
import littlebreadloaf.bleach_kd.entities.hollows.EntityFisher;
import littlebreadloaf.bleach_kd.entities.hollows.EntityGillianMenos;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollow;
import littlebreadloaf.bleach_kd.entities.hollows.EntitySmallHollowLizard;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.ItemHollowHand;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityShinigami
extends EntityBleachBiped {
    private static Random rand = new Random();
    private boolean angry;
    private static final ResourceLocation texture1 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami.png");
    private static final ResourceLocation texture2 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami1.png");
    private static final ResourceLocation texture3 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami2.png");
    private static final ResourceLocation texture4 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami3.png");
    private static final ResourceLocation texture5 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami4.png");
    private static final ResourceLocation texture6 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami5.png");
    private static final ResourceLocation texture7 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami6.png");
    private static final ResourceLocation texture8 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami7.png");
    private static final ResourceLocation texture9 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami8.png");
    private static final ResourceLocation texture10 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami9.png");
    private static final ResourceLocation texture11 = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/shinigami10.png");
    private static final DataParameter<Integer> TEXTURE = EntityDataManager.func_187226_a(EntityShinigami.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityShinigami(World par1) {
        this(par1, rand.nextInt(11));
        this.func_184641_n(rand.nextFloat() > 0.85f);
    }

    public EntityShinigami(World par1World, int par2) {
        super(par1World);
        this.setTexture(par2);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityHollow.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFisher.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGillianMenos.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(3, new BleachShinigamiAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 0, false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySmallHollowLizard.class, 0, false, true, null));
        this.field_70728_aV = 15;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public int func_70658_aO() {
        return super.func_70658_aO() + 3;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(120.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entity) {
        boolean flag = this.field_71093_bK == BleachWorldGen.HuecoMundo_ID && rand.nextInt(100) == 67;
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(BleachItems.zanpakuto, 1));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(BleachArmor.ShiniRobe, 1));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(BleachArmor.ShiniPants, 1));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(BleachArmor.Sandals, 1));
        if (rand.nextFloat() < 0.03f && !flag) {
            this.setAsCaptain();
            String name = this.func_70005_c_();
            this.func_96094_a(name + " Captain");
        }
        if (flag) {
            this.setAsSpecial();
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(BleachArmor.AshidoArmour, 1));
            this.func_96094_a("Ashido");
        }
        return super.func_180482_a(difficulty, entity);
    }

    public void setAsCaptain() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack cloak = new ItemStack(BleachArmor.ShiniCaptain, 1);
            ItemShiniCaptain jacket = (ItemShiniCaptain)cloak.func_77973_b();
            jacket.setCLOAK(cloak, null);
            jacket.randomizeJacket(cloak, true);
            this.func_184201_a(EntityEquipmentSlot.CHEST, cloak);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Captain health bonus", rand.nextDouble() * 10.0 * 40.0, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Captain attack bonus", rand.nextDouble() * 2.0 + 3.5, 1));
            this.func_70691_i(this.func_110138_aP());
        }
    }

    public void setAsSpecial() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Special health bonus", rand.nextDouble() * 10.0 * 40.0, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Special attack bonus", rand.nextDouble() * 2.0 + 3.5, 1));
            this.func_70691_i(this.func_110138_aP());
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return Tools.SPIRIT;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (props.isHollow()) {
                props.addSXP(2, 3);
                player.func_71024_bL().func_75122_a(3, 1.0f);
                if (props.getReiryoku(1) < 100) {
                    int exp = (int)(par2 * (float)(props.getBleachStat(8) / props.getBleachStat(1))) / 5;
                    exp = exp < 2 ? 2 : (exp > 20 ? 20 : exp);
                    props.addSXP(exp, 1);
                }
            }
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        }
        this.setAngry(true);
        return super.func_70097_a(par1DamageSource, par2);
    }

    protected String getHurtSound() {
        if (rand.nextInt(100) >= 50) {
            return null;
        }
        return null;
    }

    protected String getLivingSound() {
        if (rand.nextInt(100) >= 25) {
            return null;
        }
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        this.func_70099_a(new ItemStack(BleachItems.reiatsu, 2 + rand.nextInt(3) + par2), 0.0f);
        if (rand.nextInt(50 - par2) == 0) {
            this.func_145779_a(BleachItems.zanpakuto, 1);
        }
        if (rand.nextInt(150 - par2) == 0) {
            this.func_145779_a(BleachArmor.ShiniRobe, 1);
        }
        if (rand.nextInt(150 - par2) == 0) {
            this.func_145779_a(BleachArmor.ShiniPants, 1);
        }
        if (rand.nextInt(150 - par2) == 0) {
            this.func_145779_a(BleachArmor.Sandals, 1);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void fall(float var1) {
    }

    public void setTexture(int par1) {
        this.field_70180_af.func_187227_b(TEXTURE, (Object)par1);
    }

    public int getTexture() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TEXTURE, (Object)0);
    }

    @Override
    public ResourceLocation getEntityTexture() {
        switch (this.getTexture()) {
            case 0: {
                return texture2;
            }
            case 1: {
                return texture3;
            }
            case 2: {
                return texture4;
            }
            case 3: {
                return texture5;
            }
            case 4: {
                return texture6;
            }
            case 5: {
                return texture7;
            }
            case 6: {
                return texture8;
            }
            case 7: {
                return texture9;
            }
            case 8: {
                return texture10;
            }
            case 9: {
                return texture11;
            }
        }
        return texture1;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("Texture", this.getTexture());
        super.func_70014_b(par1NBTTagCompound);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setTexture(par1NBTTagCompound.func_74762_e("Texture"));
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            boolean flag;
            double d0;
            ItemStack itemstack = this.func_184582_a(entityequipmentslot);
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    d0 = this.field_82174_bp[entityequipmentslot.func_188454_b()];
                    break;
                }
                case ARMOR: {
                    d0 = this.field_184655_bs[entityequipmentslot.func_188454_b()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            boolean bl = flag = d0 > 1.0;
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack) || !wasRecentlyHit && !flag || !((double)(rand.nextFloat() - (float)lootingModifier * 0.01f) < d0)) continue;
            if (!flag && itemstack.func_77984_f()) {
                itemstack.func_77964_b(itemstack.func_77958_k() - rand.nextInt(1 + rand.nextInt(Math.max(itemstack.func_77958_k() - 3, 1))));
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer var7 = (EntityPlayer)par1DamageSource.func_76346_g();
            ItemStack stack = var7.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!(stack.func_190926_b() || stack.func_77973_b() != BleachArmor.HollowHelmet && stack.func_77973_b() != BleachArmor.HollowIchigoHelmet || rand.nextInt(50) != 0 || this.field_70170_p.field_72995_K)) {
                Item var2 = BleachItems.recordEscalon;
                this.func_145779_a(var2, 1);
            }
            IBleachPlayerCap props = (IBleachPlayerCap)var7.getCapability(BleachProvider.BLEACH_CAP, null);
            if ((stack.func_190926_b() || !stack.func_190926_b() && stack.func_77973_b() instanceof ItemHollowHand) && props.isHollow() && props.getAttackMode() == 1 && props.getReiryoku(1) < 60) {
                props.addSXP(50, 1);
            }
        }
    }

    public boolean isAngry() {
        return this.angry;
    }

    public void setAngry(boolean angry) {
        this.angry = angry;
    }
}

