/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities.hollows;

import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.entities.EntityWhole;
import littlebreadloaf.bleach_kd.entities.hollows.BleachHollowAINearestAttackableTarget;
import littlebreadloaf.bleach_kd.entities.hollows.IHollow;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityFisher
extends EntityMob
implements IHollow {
    int invis = 0;
    private static final ResourceLocation texture = new ResourceLocation("bleach_kd".toLowerCase() + ":textures/models/mobs/grand_fisher.png");
    private boolean baitSpawned = false;

    public EntityFisher(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.4, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityIronGolem.class, 6.0f, (double)0.3f, (double)0.3f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityWhole.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new BleachHollowAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWhole.class, 0, false, true, null));
        this.func_70105_a(2.1f, 4.2f);
        this.field_70728_aV = 15;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        int length = 10;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            length = 15;
        }
        if (!this.func_82150_aj()) {
            ++this.invis;
            if (this.invis == 1800) {
                this.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"invisibility"), 20 * length, 0));
                this.invis = 0;
            }
        }
    }

    public int func_70658_aO() {
        return 4;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(70.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return Tools.SPIRIT;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    protected String getHurtSound() {
        if (this.field_70146_Z.nextInt(100) >= BleachConfiguration.hollowScreamHurt) {
            return BleachSounds.hollowscream.toString();
        }
        return null;
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(5) < 2) {
            if (this.field_70146_Z.nextInt(10) < 4) {
                return BleachSounds.fisherlaugh1;
            }
            if (this.field_70146_Z.nextInt(10) < 4) {
                return BleachSounds.fisherlaugh2;
            }
            return BleachSounds.fisherlaugh3;
        }
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return BleachSounds.hollowscream;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        this.func_70099_a(new ItemStack(BleachItems.reiatsu, 2 + this.field_70146_Z.nextInt(3) + par2), 0.0f);
        if (this.field_70146_Z.nextInt(20 - par2) == 0) {
            this.func_145779_a(BleachArmor.FisherHelmet, 1);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void fall(float var1) {
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            IBleachPlayerCap props = (IBleachPlayerCap)this.field_70717_bb.getCapability(BleachProvider.BLEACH_CAP, null);
            int flagShiniAddPoints = 0;
            ItemStack held = this.field_70717_bb.field_71071_by.func_70448_g();
            if (!held.func_190926_b() && held.func_77973_b() == BleachItems.zanpakuto && props.getPointTotal() < 400 && props.getUnlockedPower(2) < 2) {
                flagShiniAddPoints = 1;
            }
            if (!held.func_190926_b() && held.func_77973_b() instanceof ItemShikai && props.getUnlockedPower(2) >= 2) {
                flagShiniAddPoints = 2;
            }
            if (props.isShinigami() && !held.func_190926_b() && (held.func_77973_b() instanceof ItemShikai || held.func_77973_b() == BleachItems.zanpakuto)) {
                props.addHollowKill(this.getHollowKillType(), 1);
            }
            if (props.isShinigami() && flagShiniAddPoints != 0 && props.getPointTotal() + 5 < 1000) {
                props.addPoints(3, 5);
                props.addPoints(7, 2);
                if (flagShiniAddPoints != 2) {
                    props.addPoints(4, -2);
                }
            }
            if (props.isHollow() && (held.func_190926_b() || held.func_77973_b() == BleachItems.hollowHand)) {
                if (props.getAttackMode() == 1) {
                    if (props.getPointTotal() + 5 < 1000) {
                        props.addPoints(3, 5);
                        props.addPoints(7, 2);
                        props.addPoints(4, -2);
                    }
                    props.addHollowKill(this.getHollowKillType(), 1);
                    props.addSXP(70);
                    props.replenishSpiritEnergy(20);
                    this.field_70717_bb.func_71024_bL().func_75122_a(3, 1.0f);
                }
                if (props.getAbilityLevel(4) == 0) {
                    props.setAbilityUnlock(4, 4);
                } else if (props.getAbilityLevel(4) == 1) {
                    props.setAbilityUnlock(4, 3);
                }
            }
        }
        if (this.field_70146_Z.nextInt(150) == 0 && !this.field_70170_p.field_72995_K) {
            Item var2 = BleachItems.recordAsterisk;
            this.func_145779_a(var2, 1);
        }
    }

    @Override
    public ResourceLocation getEntityTexture() {
        return texture;
    }

    @Override
    public boolean spawnedFromBait() {
        return this.baitSpawned;
    }

    @Override
    public void baitSpawn(boolean check) {
        this.baitSpawned = check;
    }

    @Override
    public int getSPEnergy() {
        return 10;
    }

    @Override
    public void setHollowKillType(int par1) {
    }

    @Override
    public int getHollowKillType() {
        return 3;
    }
}

