/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities.hollows;

import java.util.Random;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.entities.EntityShinigami;
import littlebreadloaf.bleach_kd.entities.EntityWhole;
import littlebreadloaf.bleach_kd.entities.hollows.BleachHollowAINearestAttackableTarget;
import littlebreadloaf.bleach_kd.entities.hollows.IHollow;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGillianMenos
extends EntityMob
implements IHollow {
    private static Random rand = new Random();
    public EntityAIBase restrictionAI = new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4);
    public int spEnergy = 100;
    int[] POINTS = new int[]{5, 5, 5, 5, 5, 5, 5, 5};
    int[] HOLLOWTYPE = new int[]{0, 2, 0, 0, 2, 5};
    public String[] textures = new String[]{"grande", "1", "2", "3", "golem", "lizard", "snake", "mantis", "pterodactyl", "ichigo"};
    private static final DataParameter<Integer> MENOS = EntityDataManager.func_187226_a(EntityGillianMenos.class, (DataSerializer)DataSerializers.field_187192_b);
    private int ceroCharging = 60;
    private boolean baitSpawned = false;
    private int deathUpdate = 0;
    public int deathTicks = 0;

    public EntityGillianMenos(World world) {
        this(world, rand.nextInt(9));
    }

    public EntityGillianMenos(World world, int type) {
        super(world);
        this.setMenosType(type);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.4, false));
        this.field_70714_bg.func_75776_a(5, this.restrictionAI);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityWhole.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new BleachHollowAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWhole.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityShinigami.class, 0, false, true, null));
        this.field_70728_aV = 15;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.func_70105_a(2.9f, 18.9f);
        this.field_70138_W = 3.5f;
        this.deathUpdate = 0;
    }

    public int func_70658_aO() {
        if (this.getMenosType() == 0) {
            return 6;
        }
        return 12;
    }

    public float func_70047_e() {
        return 0.9f * this.field_70131_O;
    }

    public boolean func_70652_k(Entity attackedEnt) {
        EntityPlayer player;
        if (attackedEnt instanceof EntityPlayer && !(player = (EntityPlayer)attackedEnt).func_184585_cz()) {
            int currVal;
            IBleachPlayerCap props = (IBleachPlayerCap)((EntityPlayer)attackedEnt).getCapability(BleachProvider.BLEACH_CAP, null);
            if (props.isHumanFac()) {
                props.addSXP(3 * (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 3);
            }
            if (props.isQuincy()) {
                props.addSXP(5, 3);
            }
            if (props.isAWhole() && (currVal = props.getChainLife()) != -1) {
                props.setChainLife(currVal - 10);
            }
        }
        return super.func_70652_k(attackedEnt);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        float multiplier = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 1.75f : 1.0f;
        double baseHP = this.getMenosType() == 0 ? 130.0 : 200.0;
        double baseAtt = this.getMenosType() == 0 ? 6.0 : 10.0;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(baseHP * (double)multiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(baseAtt * (double)multiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(10.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return Tools.SPIRIT;
    }

    protected SoundEvent func_184601_bQ(DamageSource dam) {
        if (rand.nextInt(101) >= BleachConfiguration.hollowScreamHurt) {
            return BleachSounds.hollowscream;
        }
        return null;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.8f;
    }

    protected float func_70599_aP() {
        return 3.0f;
    }

    protected SoundEvent func_184639_G() {
        if (rand.nextInt(101) >= BleachConfiguration.hollowScreamLiving) {
            return BleachSounds.hollowscream;
        }
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return BleachSounds.hollowscream;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected Item getSpecialDrop() {
        if (this.getMenosType() == 0) {
            return BleachItems.menosmask;
        }
        return BleachItems.soulquartz;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        this.func_70099_a(new ItemStack(BleachItems.reiatsu, 2 + rand.nextInt(3) + par2), 0.0f);
        if (rand.nextInt(20 - par2) == 0) {
            this.func_145779_a(this.getSpecialDrop(), 1);
        }
        if (rand.nextInt(5) == 0) {
            this.func_145779_a(BleachItems.soulquartz, rand.nextInt(3) + 1);
        }
        if (rand.nextInt(6) - par2 <= 0 && this.field_71093_bK == 0 && !BleachConfiguration.restrictHuecoMundo) {
            this.func_145779_a(BleachItems.gargantaItem, 1);
        }
    }

    public int func_70641_bl() {
        if (this.getMenosType() == 0) {
            return 3;
        }
        return 1;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        IBleachPlayerCap props;
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer && !(props = (IBleachPlayerCap)this.field_70717_bb.getCapability(BleachProvider.BLEACH_CAP, null)).isHollow() && this.field_71093_bK == 0 && props.getAbilityLevel(4) < 2) {
            if (props.getAbilityLevel(4) == 0) {
                props.setAbilityUnlock(4, 2);
            } else {
                props.setAbilityUnlock(4, 3);
            }
        }
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = this.field_70717_bb = (EntityPlayer)par1DamageSource.func_76346_g();
            IBleachPlayerCap props2 = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            int flagShiniAddPoints = 0;
            ItemStack held = player.func_184614_ca();
            if (!held.func_190926_b() && held.func_77973_b() == BleachItems.zanpakuto && props2.getPointTotal() < 400 && props2.getUnlockedPower(2) < 2) {
                flagShiniAddPoints = 1;
            }
            if (!held.func_190926_b() && held.func_77973_b() instanceof ItemShikai && props2.getUnlockedPower(2) >= 2) {
                flagShiniAddPoints = 2;
            }
            if (props2.isShinigami() & !held.func_190926_b() && (held.func_77973_b() instanceof ItemShikai || held.func_77973_b() == BleachItems.zanpakuto)) {
                props2.addHollowKill(this.getHollowKillType(), 1);
            }
            if (props2.isShinigami() && flagShiniAddPoints != 0 && props2.getPointTotal() + this.getPOINTSTotal() < 1000) {
                for (int i = 0; i < this.POINTS.length; ++i) {
                    int toadd = this.POINTS[i];
                    if (toadd < 0 && flagShiniAddPoints == 2) {
                        toadd = 0;
                    }
                    props2.addPoints(i, toadd);
                }
            }
            if (props2.isHollow() && (held.func_190926_b() || held.func_77973_b() == BleachItems.hollowHand) && props2.getAttackMode() == 1) {
                props2.addHollowKill(this.getHollowKillType(), 1);
                int exp = Math.abs(this.getPOINTSTotal()) * 4;
                props2.addSXP(exp / 2, 0);
                props2.addSXP(exp, 3);
                props2.replenishSpiritEnergy(20);
                this.field_70717_bb.func_71024_bL().func_75122_a(3, 1.0f);
                if (props2.getHollowPart(5) == 0) {
                    if (props2.getHollowTypeTotal(true) < 500) {
                        for (int i = 0; i < this.HOLLOWTYPE.length; ++i) {
                            props2.addHollowType(i, this.HOLLOWTYPE[i]);
                        }
                    } else {
                        props2.setHollowPart(5, 1);
                    }
                }
            }
        }
        super.func_70645_a(par1DamageSource);
    }

    public ResourceLocation getTextureResource() {
        String path = this.textures[this.getMenosType()];
        return new ResourceLocation("bleach_kd", "textures/models/mobs/menos_" + path + ".png");
    }

    public void setMenosType(int par1) {
        this.field_70180_af.func_187227_b(MENOS, (Object)par1);
    }

    public int getMenosType() {
        return (Integer)this.field_70180_af.func_187225_a(MENOS);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MENOS, (Object)0);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("MenosType", this.getMenosType());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setMenosType(par1NBTTagCompound.func_74762_e("MenosType"));
    }

    public int getPOINTSTotal() {
        int sum = 0;
        for (int i = 0; i < this.POINTS.length; ++i) {
            sum += this.POINTS[i];
        }
        return sum;
    }

    protected boolean func_70814_o() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175671_l(pos) > rand.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_175699_k(pos);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            l = this.field_70170_p.getBlockLightOpacity(pos);
            this.field_70170_p.func_175692_b(i1);
        }
        int ran = rand.nextInt(10);
        boolean flag = this.field_70170_p.field_73011_w.getDimension() == BleachWorldGen.HuecoMundo_ID;
        return l <= rand.nextInt(8) || ran < 3 && !BleachConfiguration.disableHollowDaytimeSpawns || flag;
    }

    public int getChargingProgress() {
        return this.ceroCharging;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entity) {
        return super.func_180482_a(difficulty, entity);
    }

    public boolean func_70601_bi() {
        return (this.field_71093_bK == 0 || this.field_70163_u < 40.0) && super.func_70601_bi();
    }

    public boolean func_70692_ba() {
        return false;
    }

    @Override
    public ResourceLocation getEntityTexture() {
        return this.getTextureResource();
    }

    @Override
    public boolean spawnedFromBait() {
        return this.baitSpawned;
    }

    @Override
    public void baitSpawn(boolean check) {
        this.baitSpawned = check;
    }

    @Override
    public int getSPEnergy() {
        return this.spEnergy;
    }

    @Override
    public void setHollowKillType(int par1) {
    }

    @Override
    public int getHollowKillType() {
        return 5;
    }

    protected void func_70609_aI() {
        if (this.deathUpdate == -1) {
            super.func_70609_aI();
        }
        if (this.deathUpdate == 0) {
            if (rand.nextInt(30) == 4) {
                this.deathUpdate = 1;
            } else {
                this.deathUpdate = -1;
                super.func_70609_aI();
            }
        }
        if (this.deathUpdate == 1) {
            int var5;
            int var4;
            ++this.deathTicks;
            int var1 = MathHelper.func_76128_c((double)this.field_70163_u);
            int var2 = MathHelper.func_76128_c((double)this.field_70165_t);
            int var3 = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.deathTicks <= 200) {
                for (var4 = -3; var4 <= 3; ++var4) {
                    for (var5 = -3; var5 <= 3; ++var5) {
                        for (int var6 = -1; var6 <= 20; ++var6) {
                            if (rand.nextInt(1500) != 0) continue;
                            int var7 = var2 + var4;
                            int var8 = var1 + var6;
                            int var9 = var3 + var5;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)var7, (double)var8, (double)var9, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                    for (var4 = 10; var4 > 0; var4 -= var5) {
                        var5 = EntityXPOrb.func_70527_a((int)var4);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, var5));
                    }
                }
                if (this.deathTicks == 1) {
                    boolean deathSound = false;
                    switch (BleachConfiguration.menosDeathSound) {
                        case 0: {
                            deathSound = true;
                            break;
                        }
                        case 1: {
                            if (this.field_71093_bK != 0) break;
                            deathSound = true;
                            break;
                        }
                        case 2: {
                            deathSound = false;
                        }
                    }
                    if (deathSound) {
                        this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
                    }
                }
            }
            if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
                for (var4 = 10; var4 > 0; var4 -= var5) {
                    var5 = EntityXPOrb.func_70527_a((int)var4);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, var5));
                }
                this.func_70106_y();
            }
        }
    }
}

