/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities.hollows;

import java.util.Random;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.entities.EntityShinigami;
import littlebreadloaf.bleach_kd.entities.EntityWhole;
import littlebreadloaf.bleach_kd.entities.hollows.BleachHollowAINearestAttackableTarget;
import littlebreadloaf.bleach_kd.entities.hollows.EntitySmallHollowLizard;
import littlebreadloaf.bleach_kd.entities.hollows.IHollow;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHollow
extends EntityMob
implements IHollow {
    private static Random rand = new Random();
    protected int[] POINTS = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected int[] HOLLOWTYPE = new int[]{0, 0, 0, 0, 0, 0};
    protected int hollowKillType = 0;
    public EntityAIBase restrictionAI = new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4);
    private Item specialDrop = BleachItems.reiatsu;
    public String[] textures = new String[]{""};
    private static final DataParameter<Integer> TEXTURE = EntityDataManager.func_187226_a(EntityHollow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STATS = EntityDataManager.func_187226_a(EntityHollow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityHollow.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean baitSpawned = false;

    public EntityHollow(World world) {
        this(world, 0);
    }

    public EntityHollow(World world, int texture) {
        super(world);
        this.setTexture(texture);
        this.setIntelligent();
        this.setRenderScale(rand.nextInt(50) + rand.nextInt(50));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.4, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityIronGolem.class, 6.0f, (double)0.3f, (double)0.3f));
        this.field_70714_bg.func_75776_a(5, this.restrictionAI);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityWhole.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new BleachHollowAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWhole.class, 0, false, false, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityShinigami.class, 0, false, false, null));
        this.field_70728_aV = 15;
    }

    protected boolean func_70692_ba() {
        if (this.func_70643_av() != null && this.field_70173_aa - this.func_142013_aG() > 2000) {
            return false;
        }
        return super.func_70692_ba();
    }

    public int func_70658_aO() {
        return 4;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(70.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return Tools.SPIRIT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damSource) {
        if (rand.nextInt(101) >= BleachConfiguration.hollowScreamHurt) {
            return BleachSounds.hollowscream;
        }
        return null;
    }

    protected SoundEvent func_184639_G() {
        if (rand.nextInt(101) >= BleachConfiguration.hollowScreamLiving) {
            return BleachSounds.hollowscream;
        }
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return BleachSounds.hollowscream;
    }

    protected void setSpecialDrop(Item item) {
        this.specialDrop = item;
    }

    protected Item getSpecialDrop() {
        return this.specialDrop;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        this.func_70099_a(new ItemStack(BleachItems.reiatsu, 1 + rand.nextInt(3) + par2), 0.0f);
        if (rand.nextInt(20 - par2) == 0) {
            this.func_145779_a(this.getSpecialDrop(), 1);
        }
        if (this.getStatType() != 0) {
            this.func_70099_a(new ItemStack(BleachItems.statPoints, 1, this.getStatType() - 1), 0.0f);
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70652_k(Entity attackedEnt) {
        EntityPlayer player;
        if (attackedEnt instanceof EntityPlayer && !(player = (EntityPlayer)attackedEnt).func_184585_cz()) {
            int currVal;
            IBleachPlayerCap props = (IBleachPlayerCap)((EntityPlayer)attackedEnt).getCapability(BleachProvider.BLEACH_CAP, null);
            if (props.isHumanFac()) {
                props.addSXP(3 * (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 3);
            }
            if (props.isQuincy()) {
                props.addSXP(5, 3);
            }
            if (props.isAWhole() && (currVal = props.getChainLife()) != -1) {
                props.setChainLife(currVal - 10);
            }
        }
        return super.func_70652_k(attackedEnt);
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = this.field_70717_bb = (EntityPlayer)par1DamageSource.func_76346_g();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            int flagShiniAddPoints = 0;
            ItemStack held = player.func_184614_ca();
            if (!held.func_190926_b() && held.func_77973_b() == BleachItems.zanpakuto && props.getPointTotal() < 400 && props.getUnlockedPower(2) < 2) {
                flagShiniAddPoints = 1;
            }
            if (!held.func_190926_b() && held.func_77973_b() instanceof ItemShikai && props.getUnlockedPower(2) >= 2) {
                flagShiniAddPoints = 2;
            }
            if (props.isShinigami() & !held.func_190926_b() && (held.func_77973_b() instanceof ItemShikai || held.func_77973_b() == BleachItems.zanpakuto)) {
                props.addHollowKill(this.getHollowKillType(), 1);
            }
            if (props.isShinigami() && flagShiniAddPoints != 0 && props.getPointTotal() + this.getPOINTSTotal() < 1000) {
                for (int i = 0; i < this.POINTS.length; ++i) {
                    int toadd = this.POINTS[i];
                    if (toadd < 0 && flagShiniAddPoints == 2) {
                        toadd = 0;
                    }
                    props.addPoints(i, toadd);
                }
            }
            if (props.isHollow() && (held.func_190926_b() || held.func_77973_b() == BleachItems.hollowHand)) {
                if (props.getAttackMode() == 0 && rand.nextInt(15) <= 4 && !this.field_70170_p.field_72995_K) {
                    EntitySmallHollowLizard gecko = new EntitySmallHollowLizard(this.field_70170_p);
                    gecko.func_70107_b(this.field_70165_t + 0.5, this.field_70163_u, this.field_70161_v + 0.5);
                    this.field_70170_p.func_72838_d((Entity)gecko);
                }
                if (props.getAttackMode() == 1) {
                    int i;
                    props.addHollowKill(this.getHollowKillType(), 1);
                    int exp = Math.abs(this.getPOINTSTotal()) * 4;
                    props.addSXP(exp / 2, 0);
                    props.addSXP(exp, 3);
                    props.replenishSpiritEnergy(20);
                    this.field_70717_bb.func_71024_bL().func_75122_a(3, 1.0f);
                    if (props.getPointTotal() + this.getPOINTSTotal() < 1000) {
                        for (i = 0; i < this.POINTS.length; ++i) {
                            props.addPoints(i, this.POINTS[i]);
                        }
                    }
                    if (props.getHollowPart(5) == 0) {
                        if (props.getHollowTypeTotal(true) <= 500) {
                            for (i = 0; i < this.HOLLOWTYPE.length; ++i) {
                                props.addHollowType(i, this.HOLLOWTYPE[i]);
                            }
                        } else {
                            if (!BleachConfiguration.debugDISABLE) {
                                player.func_145747_a((ITextComponent)new TextComponentString("Full mutation unlocked."));
                            }
                            props.setHollowPart(5, 1);
                        }
                    }
                }
            }
        }
        super.func_70645_a(par1DamageSource);
    }

    public ResourceLocation getTextureResource() {
        String path = this.textures[this.getTexture()];
        return new ResourceLocation("bleach_kd", "textures/models/mobs/hollow_" + path + ".png");
    }

    public void setTexture(int par1) {
        this.field_70180_af.func_187227_b(TEXTURE, (Object)par1);
    }

    public int getTexture() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(STATS, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Texture", this.getTexture());
        par1NBTTagCompound.func_74768_a("StatType", this.getStatType());
        par1NBTTagCompound.func_74768_a("RenderScale", this.getRenderScale());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setTexture(par1NBTTagCompound.func_74762_e("Texture"));
        this.setStatType(par1NBTTagCompound.func_74762_e("StatType"));
        this.setRenderScale(par1NBTTagCompound.func_74762_e("RenderScale"));
    }

    public int getPOINTSTotal() {
        int sum = 0;
        for (int i = 0; i < this.POINTS.length; ++i) {
            sum += this.POINTS[i];
        }
        return sum;
    }

    protected boolean func_70814_o() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175671_l(pos) > rand.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_175699_k(pos);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            l = this.field_70170_p.getBlockLightOpacity(pos);
            this.field_70170_p.func_175692_b(i1);
        }
        int ran = rand.nextInt(10);
        float spawnScale = BleachConfiguration.spawnRate / 6;
        l = (int)((float)l - spawnScale);
        boolean flag = this.field_70170_p.field_73011_w.getDimension() == BleachWorldGen.HuecoMundo_ID;
        return l <= 8 || (float)ran < 2.0f + spawnScale && !BleachConfiguration.disableHollowDaytimeSpawns || flag;
    }

    public void setIntelligent() {
        int statTyping = 0;
        if (rand.nextInt(30) == 23) {
            statTyping = rand.nextInt(7) + 1;
        }
        this.setStatType(statTyping);
    }

    public void setStatType(int type) {
        this.field_70180_af.func_187227_b(STATS, (Object)type);
    }

    public int getStatType() {
        return (Integer)this.field_70180_af.func_187225_a(STATS);
    }

    public void setRenderScale(int scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)scale);
    }

    public int getRenderScale() {
        return (Integer)this.field_70180_af.func_187225_a(SCALE);
    }

    @Override
    public ResourceLocation getEntityTexture() {
        return this.getTextureResource();
    }

    @Override
    public boolean spawnedFromBait() {
        return this.baitSpawned;
    }

    @Override
    public void baitSpawn(boolean check) {
        this.baitSpawned = check;
    }

    @Override
    public void setHollowKillType(int par1) {
        this.hollowKillType = par1;
    }

    @Override
    public int getHollowKillType() {
        return this.hollowKillType;
    }

    @Override
    public int getSPEnergy() {
        return 10;
    }
}

