/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.events;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.BleachMod;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.IHollowMask;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowOre;
import littlebreadloaf.bleach_kd.entities.hollows.IHollow;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.ISpiritFood;
import littlebreadloaf.bleach_kd.items.ItemHollowHand;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import littlebreadloaf.bleach_kd.network.ParticleMessage;
import littlebreadloaf.bleach_kd.network.PropertiesPacket;
import littlebreadloaf.bleach_kd.network.SyncConfigMessage;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BleachEvents {
    Random rand = new Random();
    public static final UUID spiritHealthModifierUUID = UUID.fromString("81a548d8-8365-4ba7-8389-881fe302bc2a");
    public static final UUID spiritSpeedModifierUUID = UUID.fromString("36c948d8-8365-4ba7-8389-881fe302bc2a");
    public static final UUID spiritDamageModifierUUID = UUID.fromString("6414cac2-8365-4ba7-8389-881fe302bc2a");
    public static final UUID maskSpeedModifierUUID = UUID.fromString("36c954d8-152f-455b-8f10-247f51afbc23");
    public static final UUID maskDamageModifierUUID = UUID.fromString("6414cac2-152f-455b-8f10-247f51afbc23");
    public static final UUID visoredSpeedModifierUUID = UUID.fromString("36c954d8-312f-455b-8f10-247f51afbc23");
    public static final UUID visoredDamageModifierUUID = UUID.fromString("6414cac2-312f-455b-8f10-247f51afbc23");
    public static final UUID bankaiSpeedModifierUUID = UUID.fromString("36c954d8-239c-455b-8f10-247f51afbc23");
    public static final UUID bankaiDamageModifierUUID = UUID.fromString("6414cac2-239c-455b-8f10-247f51afbc23");
    public static final UUID ressSpeedModifierUUID = UUID.fromString("36c954d8-714d-455b-8f10-247f51afbc23");
    public static final UUID ressDamageModifierUUID = UUID.fromString("6414cac2-714d-455b-8f10-247f51afbc23");
    public static AttributeModifier spiritHealthModifier = new AttributeModifier(spiritHealthModifierUUID, "Spirit Enhanced Health", 0.0, 0);
    public static AttributeModifier spiritSpeedModifier = new AttributeModifier(spiritSpeedModifierUUID, "Spirit Enhanced Speed", 0.01, 0);
    public static AttributeModifier spiritDamageModifier = new AttributeModifier(spiritDamageModifierUUID, "Spirit Enhanced Damage", 1.0, 0);
    public static AttributeModifier maskSpeedModifier = new AttributeModifier(maskSpeedModifierUUID, "Mask Enhanced Speed", 0.01, 0);
    public static AttributeModifier maskDamageModifier = new AttributeModifier(maskDamageModifierUUID, "Mask Enhanced Damage", 1.0, 0);
    public static AttributeModifier visoredSpeedModifier = new AttributeModifier(visoredSpeedModifierUUID, "Visored Enhanced Speed", 0.01, 0);
    public static AttributeModifier visoredDamageModifier = new AttributeModifier(visoredDamageModifierUUID, "Visored Enhanced Damage", 1.0, 0);
    public static AttributeModifier bankaiSpeedModifier = new AttributeModifier(bankaiSpeedModifierUUID, "Bankai Enhanced Speed", 0.01, 0);
    public static AttributeModifier bankaiDamageModifier = new AttributeModifier(bankaiDamageModifierUUID, "Bankai Enhanced Damage", 1.0, 0);
    public static AttributeModifier ressSpeedModifier = new AttributeModifier(ressSpeedModifierUUID, "Ress Enhanced Speed", 0.01, 0);
    public static AttributeModifier ressDamageModifier = new AttributeModifier(ressDamageModifierUUID, "Ress Enhanced Damage", 1.0, 0);
    private int seeleDamageTimer = 60;

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        IBleachPlayerCap oldProps = (IBleachPlayerCap)event.getOriginal().getCapability(BleachProvider.BLEACH_CAP, null);
        props.cloneSaveFunction(oldProps);
        props.deactivateAllAbilities();
        if (event.isWasDeath()) {
            props.deactivateAllPowers();
            if (BleachConfiguration.deathSPRecover && props.getSpiritEnergy() < 20) {
                props.setCurrentSpiritEnergy(20);
            }
        }
        if (event.isWasDeath() && !BleachConfiguration.disableFactionItem && props.getFaction() == -1 && !player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70431_c(new ItemStack(BleachItems.factionSelect))) {
            ItemStack factionSelector = new ItemStack(BleachItems.factionSelect, 1);
            player.field_71071_by.func_70441_a(factionSelector);
        }
        if (!(!event.isWasDeath() || BleachConfiguration.removeTempGarganta || player.field_71075_bZ.field_75098_d || player.field_70170_p.func_82736_K().func_82766_b("keepInventory") || player.field_71093_bK != BleachWorldGen.HuecoMundo_ID || player.field_71071_by.func_70431_c(new ItemStack(BleachItems.tempGargantaItem)))) {
            ItemStack tempGarganta = new ItemStack(BleachItems.tempGargantaItem, 1);
            player.field_71071_by.func_70441_a(tempGarganta);
        }
        if (event.isWasDeath() && BleachConfiguration.humanEvo && props.isHumanFac() && BleachConfiguration.disablePathing[0] == 0) {
            ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!chest.func_190926_b() && chest.func_77973_b() == BleachArmor.SoulChain && props.getReiryoku(0) >= 15) {
                props.setAsWhole(1, 0);
                player.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
                player.field_71071_by.func_70296_d();
            }
            if (props.getReiryoku(0) >= 100) {
                props.setAsWhole(1, 1);
            }
        }
        if (event.isWasDeath() && (props.isAWhole() || props.isHuman() && props.isSpirit())) {
            int newVal = props.getChainLife() - 1000;
            props.setChainLife(newVal);
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        IBleachPlayerCap props;
        EntityPlayer player;
        if (BleachConfiguration.allowExpFromEntities && event.getEntityLiving() != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            int reircheck;
            Random rand1;
            int index;
            player = (EntityPlayer)event.getSource().func_76346_g();
            props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (props.getBleachStat(index = (rand1 = new Random()).nextInt(3)) < 50) {
                props.addStatExp(index, 5);
            }
            int n = reircheck = props.isHollow() ? 100 : 200;
            if (props.getReiryoku(0) < reircheck) {
                props.addSXP(1);
            }
        }
        if (event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntityLiving();
            props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!chest.func_190926_b() && chest.func_77973_b() == BleachArmor.SoulChain && props.getReiryoku(0) >= 15 && BleachConfiguration.disablePathing[0] == 0) {
                props.setAsWhole(1, 0);
                player.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
                player.field_71071_by.func_70296_d();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        props.setupData();
        props.deactivateAllAbilities();
        props.unlockedPowerFIX();
        if (!player.field_70170_p.field_72995_K) {
            BleachMod.network.sendTo((IMessage)new SyncConfigMessage(BleachConfiguration.ignoreSpiritForRender ? 1 : 0), player);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityPlayer) {
            PropertiesPacket packet;
            EntityTracker et;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!player.field_70170_p.field_72995_K && (et = ((WorldServer)player.field_70170_p).func_73039_n()) != null && (packet = new PropertiesPacket(player, player.field_70170_p)) != null) {
                et.func_151248_b((Entity)player, BleachMod.network.getPacketFrom((IMessage)packet));
            }
        }
    }

    @SubscribeEvent
    public void timerCOUNT(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
        if (props != null) {
            props.setRegenVsConsume(props.getRegenVsConsume() - 1);
            if (props.getRegenVsConsume() <= 0) {
                props.setTimer(0, props.getTimer(0) - 1);
            }
            props.setTimer(3, props.getTimer(3) - 1);
            props.setTimer(1, props.getTimer(1) - 1);
            props.setTimer(2, props.getTimer(2) - 1);
            if (props.getReiryoku(3) > 30 && props.getHollowPercent() < 0.95f) {
                props.setTimer(4, props.getTimer(4) + 1);
            }
        }
    }

    @SubscribeEvent
    public void timerMASK(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (event.getEntity() instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)).getTimer(3) <= 0) {
            if (props.getUnlockedPower(3) > 0) {
                IAttributeInstance movement = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111263_d);
                IAttributeInstance damage = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (props.getActivePower(2) == 0) {
                    if (props.getMaskTime() < props.getMaskTimerMax()) {
                        props.recoverMaskEnergy(0);
                        props.setTimer(3, 40);
                    }
                } else if (props.getActivePower(2) >= 1) {
                    int boost;
                    if (!player.field_71075_bZ.field_75098_d) {
                        props.decreaseMaskTimer(0);
                    }
                    props.setTimer(3, 20);
                    if (movement != null) {
                        boost = props.getUnlockedPower(3);
                        if (movement.func_111127_a(visoredSpeedModifierUUID) != null) {
                            movement.func_111124_b(visoredSpeedModifier);
                        }
                        if (boost != 0) {
                            visoredSpeedModifier = new AttributeModifier(visoredSpeedModifierUUID, "Visored Enhanced Speed", 0.1 * (double)boost, 1);
                            movement.func_111121_a(visoredSpeedModifier);
                        }
                    }
                    if (damage != null) {
                        boost = props.getUnlockedPower(3);
                        if (damage.func_111127_a(visoredDamageModifierUUID) != null) {
                            damage.func_111124_b(visoredDamageModifier);
                        }
                        if (boost != 0) {
                            visoredDamageModifier = new AttributeModifier(visoredDamageModifierUUID, "Visored Enhanced Damage", 2.0 * (double)boost, 1);
                            damage.func_111121_a(visoredDamageModifier);
                        }
                    }
                } else {
                    if (movement != null && movement.func_111127_a(visoredSpeedModifierUUID) != null) {
                        movement.func_111124_b(visoredSpeedModifier);
                    }
                    if (damage != null && damage.func_111127_a(visoredDamageModifierUUID) != null) {
                        damage.func_111124_b(visoredDamageModifier);
                    }
                }
            } else if (props.isShinigamiFac()) {
                if (props.getReiryoku(3) > 0) {
                    props.reduceReiryoku(3, 1);
                    props.setTimer(3, 12000);
                } else {
                    props.setTimer(3, 20);
                }
            } else if (props.isHuman()) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public void timerCONSUME(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (event.getEntity() instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)).getTimer(1) <= 0) {
            props.trackActivePowers(player);
            props.setTimer(1, 40);
        }
    }

    @SubscribeEvent
    public void timerBANKAI(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (event.getEntity() instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)).getTimer(2) <= 0) {
            IAttributeInstance movement = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111263_d);
            IAttributeInstance damage = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (props.getActivePower(0) >= 1) {
                int boost;
                props.setTimer(2, 20);
                if (movement != null) {
                    boost = props.getActivePower(0);
                    if (movement.func_111127_a(bankaiSpeedModifierUUID) != null) {
                        movement.func_111124_b(bankaiSpeedModifier);
                    }
                    if (boost != 0) {
                        bankaiSpeedModifier = new AttributeModifier(bankaiSpeedModifierUUID, "Bankai Enhanced Speed", 0.1 * (double)boost, 1);
                        movement.func_111121_a(bankaiSpeedModifier);
                    }
                }
                if (damage != null) {
                    boost = props.getActivePower(0);
                    if (damage.func_111127_a(bankaiDamageModifierUUID) != null) {
                        damage.func_111124_b(bankaiDamageModifier);
                    }
                    if (boost != 0) {
                        bankaiDamageModifier = new AttributeModifier(bankaiDamageModifierUUID, "Bankai Enhanced Damage", 2.0 * (double)boost, 1);
                        damage.func_111121_a(bankaiDamageModifier);
                    }
                }
            } else {
                if (movement != null && movement.func_111127_a(bankaiSpeedModifierUUID) != null) {
                    movement.func_111124_b(bankaiSpeedModifier);
                }
                if (damage != null && damage.func_111127_a(bankaiDamageModifierUUID) != null) {
                    damage.func_111124_b(bankaiDamageModifier);
                }
            }
        }
    }

    @SubscribeEvent
    public void timerRESS(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (event.getEntity() instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)).getTimer(5) <= 0) {
            IAttributeInstance movement = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111263_d);
            IAttributeInstance damage = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (props.getActivePower(1) >= 1) {
                int boost;
                props.setTimer(5, 20);
                if (movement != null) {
                    boost = props.getActivePower(1);
                    if (movement.func_111127_a(ressSpeedModifierUUID) != null) {
                        movement.func_111124_b(ressSpeedModifier);
                    }
                    if (boost != 0) {
                        ressSpeedModifier = new AttributeModifier(ressSpeedModifierUUID, "Ress Enhanced Speed", 0.1 * (double)boost, 1);
                        movement.func_111121_a(ressSpeedModifier);
                    }
                }
                if (damage != null) {
                    boost = props.getActivePower(1);
                    if (damage.func_111127_a(ressDamageModifierUUID) != null) {
                        damage.func_111124_b(ressDamageModifier);
                    }
                    if (boost != 0) {
                        ressDamageModifier = new AttributeModifier(ressDamageModifierUUID, "Ress Enhanced Damage", 2.0 * (double)boost, 1);
                        damage.func_111121_a(ressDamageModifier);
                    }
                }
            } else {
                if (movement != null && movement.func_111127_a(ressSpeedModifierUUID) != null) {
                    movement.func_111124_b(ressSpeedModifier);
                }
                if (damage != null && damage.func_111127_a(ressDamageModifierUUID) != null) {
                    damage.func_111124_b(ressDamageModifier);
                }
            }
        }
    }

    @SubscribeEvent
    public void timerREPLEN(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            boolean activeFlag = false;
            for (int i = 0; i < 5; ++i) {
                if (props.getActivePower(i) == 0) continue;
                activeFlag = true;
                break;
            }
            if (!activeFlag && props.getTimer(0) <= 0) {
                boolean soul;
                boolean hueco = player.field_71093_bK == BleachWorldGen.HuecoMundo_ID;
                boolean bl = soul = player.field_71093_bK == BleachWorldGen.SoulSociety_ID;
                int dim = hueco ? 0 : (soul ? 1 : (player.field_71093_bK == -1 ? 2 : (player.field_71093_bK == 0 ? 3 : (player.field_71093_bK == 1 ? 4 : 5))));
                float dimensionBoost = (float)BleachConfiguration.regenWorlds[dim] / 2.0f;
                int regenRate = props.getSpiritRecoverySpeed(player);
                int regenAmount = props.getSpiritRecoveryAmount();
                float reishiManip = (float)props.getBleachStat(8) / (float)BleachConfiguration.statMax[8];
                int dimManip = (int)(dimensionBoost * reishiManip);
                props.replenishSpiritEnergy(dimManip + regenAmount);
                props.setTimer(0, regenRate);
                if (props.isHollow()) {
                    // empty if block
                }
                boolean reiatsuFlag = false;
                Block blockCheck = player.field_70170_p.func_180495_p(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v)).func_177230_c();
                if (blockCheck != null && blockCheck == BleachBlocks.reiatsuBlock) {
                    reiatsuFlag = true;
                }
                if (player.field_71093_bK == BleachWorldGen.HuecoMundo_ID || player.field_71093_bK == BleachConfiguration.worldSoulSocietyID) {
                    props.replenishSpiritEnergy((int)(3.5 * (1.0 + 0.001 * (double)props.getMaxSpirit())));
                } else if (!reiatsuFlag && props.isEnergyMoreThan(50) && !BleachConfiguration.hollowSpiritDecay) {
                    props.consumeSpiritEnergy((int)(1.0 + 0.001 * (double)props.getMaxSpirit()), player);
                }
                if (reiatsuFlag || props.isEnergyLessThan(50)) {
                    props.replenishSpiritEnergy((int)(1.5 * (1.0 + 0.001 * (double)props.getMaxSpirit())));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer thePlayer;
        IBleachPlayerCap props;
        if (event.getEntityLiving() instanceof EntityPlayer && (props = (IBleachPlayerCap)(thePlayer = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)) != null) {
            ItemStack helm;
            float newStepHeight;
            if ((props.isAWhole() || props.isHuman() && props.isSpirit()) && !thePlayer.field_71075_bZ.field_75098_d) {
                int hollow = props.getReiryoku(3) / 10;
                int currVal = props.getChainLife();
                if (currVal != -1) {
                    props.setChainLife(currVal - 1 - hollow);
                }
                if (currVal == 0) {
                    props.setChainLife(-2);
                }
            }
            if (props.getActivePower(4) != 0 && (props.getSpiritEnergy() < 1 || props.getUnlockedPower(7) == 0)) {
                props.deactivateFullBring();
            }
            float f = newStepHeight = props.getSpeed() >= 0.036 ? 1.0f : 0.5f;
            float hollowBonus = props.getFactionId() == 3 || props.getFactionId() == 10 ? 0.5f : (props.getFactionId() == 9 ? 3.0f : 0.0f);
            thePlayer.field_70138_W = newStepHeight + hollowBonus;
            if (!thePlayer.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (helm = thePlayer.func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b() instanceof IHollowMask) {
                boolean dropFlag = false;
                if (!thePlayer.field_70170_p.field_72995_K) {
                    if (!thePlayer.field_71075_bZ.field_75098_d) {
                        if (!BleachConfiguration.canWearFisherMask && helm.func_77973_b() == BleachArmor.FisherHelmet && props.isEnergyLessThan(100)) {
                            dropFlag = true;
                        } else if (props.isEnergyLessThan(100)) {
                            dropFlag = true;
                        } else if (BleachConfiguration.maskFactionSpecific && !props.isVisored()) {
                            dropFlag = true;
                        }
                    }
                    if (props.getActivePower(2) != 0) {
                        dropFlag = true;
                    }
                    if (dropFlag) {
                        BleachLib.unequipItem(thePlayer, EntityEquipmentSlot.HEAD);
                    }
                }
            }
            if (thePlayer.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && !thePlayer.field_70170_p.field_72995_K && !thePlayer.field_71075_bZ.field_75098_d && props.getActivePower(3) == 1) {
                props.deactivateQuincy();
            }
            if (!thePlayer.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                ItemStack chest = thePlayer.func_184582_a(EntityEquipmentSlot.CHEST);
                if (!thePlayer.field_70170_p.field_72995_K && !thePlayer.field_71075_bZ.field_75098_d) {
                    if (chest.func_77973_b() == BleachArmor.QuincyLeztzStil) {
                        if (props.getActivePower(3) != 1) {
                            BleachLib.unequipItem(thePlayer, EntityEquipmentSlot.CHEST);
                        }
                    } else if (props.getActivePower(3) == 1) {
                        props.deactivateQuincy();
                    }
                }
            }
        }
        if (!event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (BleachLib.isEntityInCube(event.getEntity())) {
                --this.seeleDamageTimer;
                event.getEntity().field_70159_w *= (double)0.01f;
                event.getEntity().field_70179_y *= (double)0.01f;
                if (event.getEntity().field_70181_x > 0.0) {
                    event.getEntity().field_70181_x *= (double)0.01f;
                }
                if (event.getEntityLiving().func_70668_bt() == Tools.SPIRIT && this.seeleDamageTimer <= 0) {
                    event.getEntityLiving().func_70097_a(DamageSource.field_76376_m, 2.0f);
                }
                if (event.getEntityLiving() instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)) != null && this.seeleDamageTimer <= 0 && !props.isHumanFac() && props.isQuincy()) {
                    float hollowDam = props.isHollow() ? 1.5f : (props.isArrancar() ? 2.5f : (props.isVisored() ? 0.5f : 0.0f));
                    event.getEntityLiving().func_70097_a(DamageSource.field_76376_m, 1.0f + hollowDam);
                }
            }
            if (event.getEntityLiving() != null) {
                ItemStack helm = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD);
                IAttributeInstance movement = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111263_d);
                IAttributeInstance damage = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (!helm.func_190926_b() && helm.func_77973_b() instanceof IHollowMask) {
                    IHollowMask mask = (IHollowMask)helm.func_77973_b();
                    if (movement != null) {
                        int boost = mask.getSpeedBoost();
                        if (movement.func_111127_a(maskSpeedModifierUUID) != null) {
                            movement.func_111124_b(maskSpeedModifier);
                        }
                        if (boost != 0) {
                            maskSpeedModifier = new AttributeModifier(maskSpeedModifierUUID, "Mask Enhanced Speed", 0.1 * (double)boost, 1);
                            movement.func_111121_a(maskSpeedModifier);
                        }
                    }
                    if (damage != null) {
                        int boost = mask.getAttackBoost();
                        if (damage.func_111127_a(maskDamageModifierUUID) != null) {
                            damage.func_111124_b(maskDamageModifier);
                        }
                        if (boost != 0) {
                            maskDamageModifier = new AttributeModifier(maskDamageModifierUUID, "Mask Enhanced Damage", 2.0 * (double)boost, 1);
                            damage.func_111121_a(maskDamageModifier);
                        }
                    }
                } else {
                    if (movement != null && movement.func_111127_a(maskSpeedModifierUUID) != null) {
                        movement.func_111124_b(maskSpeedModifier);
                    }
                    if (damage != null && damage.func_111127_a(maskDamageModifierUUID) != null) {
                        damage.func_111124_b(maskDamageModifier);
                    }
                }
            }
            if (event.getEntityLiving() instanceof EntityPlayer) {
                player = (EntityPlayer)event.getEntityLiving();
                props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
                if (props != null) {
                    boolean affectFlag;
                    IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
                    IAttributeInstance movement = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    IAttributeInstance damage = player.func_110148_a(SharedMonsterAttributes.field_111264_e);
                    if (health != null) {
                        if (health.func_111127_a(spiritHealthModifierUUID) != null) {
                            health.func_111124_b(spiritHealthModifier);
                        }
                        spiritHealthModifier = new AttributeModifier(spiritHealthModifierUUID, "Spirit Enhanced Health", (double)props.getBonusHealth(), 0);
                        health.func_111121_a(spiritHealthModifier);
                    }
                    if (movement != null) {
                        if (movement.func_111127_a(spiritSpeedModifierUUID) != null) {
                            movement.func_111124_b(spiritSpeedModifier);
                        }
                        double timesFaster = props.getSpeed();
                        double hollowBoost = player.func_70051_ag() && props.isHollowBASE() ? (double)props.getHollowBoost(0) : 0.0;
                        spiritSpeedModifier = new AttributeModifier(spiritSpeedModifierUUID, "Spirit Enhanced Speed", timesFaster + hollowBoost, 0);
                        movement.func_111121_a(spiritSpeedModifier);
                    }
                    if (damage != null) {
                        if (damage.func_111127_a(spiritDamageModifierUUID) != null) {
                            damage.func_111124_b(spiritDamageModifier);
                        }
                        double damageBoost = props.getBaseDamage();
                        double hollowDam = props.isHollowBASE() ? (double)props.getHollowBoost(1) : 0.0;
                        spiritDamageModifier = new AttributeModifier(spiritDamageModifierUUID, "Spirit Enhanced Damage", damageBoost + hollowDam, 0);
                        damage.func_111121_a(spiritDamageModifier);
                    }
                    boolean bl = props.getUnlockedPower(3) == 0 ? props.getUnlockedPower(7) == 0 : (affectFlag = false);
                    if (props.isQuincy() && affectFlag) {
                        if (props.getReiryoku(3) > 30 && props.getHollowPercent() < 0.95f) {
                            int holPois = Math.abs(300 - props.getReiryoku(3) + props.getReiryoku(1)) + 20;
                            if (props.getTimer(4) > holPois) {
                                if (!BleachConfiguration.debugDISABLE) {
                                    System.out.println("Hollow Poison time = " + holPois);
                                }
                                float dam = 0.01f * (float)(300 + props.getReiryoku(3)) + 0.1f * props.getHollowPercent();
                                float hollowPoiDam = dam * 0.01f + this.rand.nextFloat() * 0.00263f * ((float)BleachConfiguration.hollowPoisonSpeed / 50.0f);
                                props.adjustHollowPercent(hollowPoiDam);
                                props.setTimer(4, 0);
                            }
                        }
                        if (props.getHollowPercent() >= 0.95f) {
                            props.reduceReiryoku(3, 30);
                            props.adjustHollowPercent(-0.5f);
                            player.func_174812_G();
                        }
                    }
                }
                if (props.isHollowBASE() && props.getHead() == 2 && player.func_70051_ag() && props.getAttackMode() == 1) {
                    List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_186662_g(0.25));
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity1 = (Entity)list.get(l);
                        if (!(entity1 instanceof EntityLivingBase)) continue;
                        double moveX = entity1.field_70165_t - player.field_70165_t;
                        double moveY = entity1.field_70163_u - player.field_70163_u;
                        double moveZ = entity1.field_70161_v - player.field_70161_v;
                        double angle = Math.atan2(moveZ, moveX);
                        moveX = 0.8 * Math.cos(angle);
                        moveZ = 0.8 * Math.sin(angle);
                        moveY = 0.5;
                        entity1.func_70024_g(moveX, moveY, moveZ);
                        ((EntityLivingBase)entity1).func_70097_a(DamageSource.field_76377_j, 1.0f);
                    }
                }
                if (props.isHollowBASE() && props.getHead() == 5 && player.func_70089_S() && player.func_70055_a(Material.field_151586_h)) {
                    player.func_70050_g(300);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (event.getEntityLiving() instanceof EntityPlayer && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)) != null) {
            float multiply;
            int jumpBoost;
            int n = jumpBoost = props.getMaxSpirit() < BleachConfiguration.spiritJumpBoost ? props.getMaxSpirit() : BleachConfiguration.spiritJumpBoost;
            float f = player.func_70051_ag() ? 0.001f : (multiply = player.func_70093_af() ? 0.0f : 5.0E-4f);
            if (player.field_70122_E) {
                event.getEntityLiving().field_70181_x += (double)((float)jumpBoost * multiply + props.getHollowBoost(2));
                ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!helmet.func_190926_b() && helmet.func_77973_b() instanceof IHollowMask) {
                    IHollowMask mask = (IHollowMask)helmet.func_77973_b();
                    event.getEntityLiving().field_70181_x += (double)((float)mask.getJumpBoost() * 0.1f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        IBleachPlayerCap props;
        if (event.getEntityLiving() instanceof EntityPlayer && event.getDistance() > 3.0f && (props = (IBleachPlayerCap)(player = (EntityPlayer)event.getEntityLiving()).getCapability(BleachProvider.BLEACH_CAP, null)) != null) {
            if (event.getEntityLiving().field_71093_bK == BleachWorldGen.HuecoMundo_ID) {
                event.setDamageMultiplier(0.1f);
            }
            if (props.isHollow() && props.getBack() == 3) {
                event.setCanceled(true);
                return;
            }
            if (!player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == BleachArmor.LizardHelmet) {
                event.setCanceled(true);
                return;
            }
            if (BleachConfiguration.negateFallDamage && props.fullOutfit(0, player)) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.getItem().func_92059_d().func_77973_b().equals(BleachItems.heart) && event.getEntityPlayer() != null) {
            event.getEntityPlayer().func_70691_i(8.0f);
            for (int i = 0; i < 5; ++i) {
                BleachMod.network.sendToAll((IMessage)new ParticleMessage(4, (int)event.getEntityPlayer().field_70165_t, (int)event.getEntityPlayer().field_70163_u, (int)event.getEntityPlayer().field_70161_v));
            }
            event.getItem().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() != null) {
            EntityLivingBase entLiving;
            ItemStack helm;
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
                IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
                if (event.getEntityLiving().func_70668_bt() == Tools.SPIRIT && props.getReiryoku(0) < 30 && props.isHumanFac() && (player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() || player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() != BleachArmor.SoulChain)) {
                    event.setCanceled(true);
                }
                if (props.isHollow() && props.isTailUsable() && props.getTail() == 3 && player.func_70093_af() && props.isEnergyMoreThan(20) && !event.getEntityLiving().field_70170_p.field_72995_K) {
                    props.consumeSpiritEnergy(20, player);
                    event.getEntityLiving().func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), 80, 0));
                    return;
                }
            }
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && !(helm = (entLiving = (EntityLivingBase)event.getSource().func_76346_g()).func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && helm.func_77973_b() instanceof IHollowMask) {
                IHollowMask mask = (IHollowMask)helm.func_77973_b();
                mask.specialAttackEffect(entLiving, event.getEntityLiving());
            }
        }
        if (event.getEntityLiving() instanceof EntityHollowOre && event.getSource().equals(DamageSource.field_76368_d)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        EntityPlayer player;
        ItemStack heldItem;
        if (event.getEntity() != null && event.getEntity() instanceof EntityPlayer && !(heldItem = (player = (EntityPlayer)event.getEntity()).func_184607_cu()).func_190926_b() && heldItem.func_77973_b() == BleachItems.shikailightning) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        IHollow iHollow;
        if (event.getEntityLiving() instanceof IHollow && event.getSource().equals(DamageSource.field_76379_h) && (iHollow = (IHollow)event.getEntityLiving()).spawnedFromBait()) {
            iHollow.baitSpawn(false);
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (event.getSource().equals(DamageSource.field_76379_h)) {
                int capMax = props.getMaxSpirit() < 750 ? props.getMaxSpirit() : 750;
                float multiply = (float)capMax * 0.01f;
                float fallLimit = 6.0f + multiply;
                float fallDamage = event.getAmount();
                float spiritDamage = 0.0f;
                int currentSpirit = props.getSpiritEnergy();
                if (fallDamage >= fallLimit) {
                    spiritDamage = fallLimit;
                    fallDamage -= fallLimit;
                } else if (fallDamage < fallLimit) {
                    spiritDamage = fallDamage;
                    fallDamage = 0.0f;
                }
                if (spiritDamage > (float)(currentSpirit * 2)) {
                    fallDamage += spiritDamage - (float)(currentSpirit * 2);
                    spiritDamage = currentSpirit * 2;
                }
                fallDamage = fallDamage < 0.0f ? 0.0f : fallDamage;
                props.consumeSpiritEnergy((int)(spiritDamage * 2.0f), player);
                event.setAmount(fallDamage);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        Entity entity = event.getSource().func_76346_g();
        if (entity != null && entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
            ItemStack heldItem = player.func_184607_cu();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (props.isHollow()) {
                float hollowDamage = 0.0f;
                if (!heldItem.func_190926_b() && !(heldItem.func_77973_b() instanceof ItemHollowHand)) {
                    hollowDamage += heldItem.func_77973_b() instanceof ItemSword ? 2.0f : 5.0f;
                } else {
                    int spiritUse = props.getAttackMode() == 0 ? 0 : 3;
                    props.consumeSpiritEnergy(spiritUse, player);
                    hollowDamage += props.getAttackMode() == 0 ? 6.0f : 10.0f;
                    if (props.getArms() == 1 || props.getArms() == 2) {
                        hollowDamage += 4.0f;
                    }
                }
                event.setAmount(event.getAmount() + hollowDamage);
            }
            float extraDamg = (float)(props.getMaxSpirit() > BleachConfiguration.spiritDamageBoost ? BleachConfiguration.spiritDamageBoost : props.getMaxSpirit()) * 0.01f;
            extraDamg = props.isHollow() ? extraDamg * 0.5f : extraDamg;
            event.setAmount(event.getAmount() + extraDamg);
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            boolean configOverride;
            player = (EntityPlayer)event.getEntityLiving();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            ItemStack heldItem = player.func_184607_cu();
            ItemStack var9 = player.func_184582_a(EntityEquipmentSlot.FEET);
            ItemStack var10 = player.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack var11 = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == BleachItems.shikaipoison && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase var5 = (EntityLivingBase)event.getSource().func_76346_g();
                var5.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), 80, 0));
            }
            boolean bl = configOverride = BleachConfiguration.spiritFlashandArmour == 1 || BleachConfiguration.spiritFlashandArmour == 3;
            if ((!var9.func_190926_b() && !var10.func_190926_b() && !var11.func_190926_b() || props.isHollow() || configOverride) && (props.fullOutfit(0, player) || props.isHollow() || configOverride)) {
                boolean sword;
                float amountToConsume = 0.0f;
                boolean fallFlag = event.getSource().equals(DamageSource.field_76379_h);
                boolean bl2 = sword = !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemShikai;
                float f = sword ? (player.func_184607_cu().func_77975_n().equals((Object)EnumAction.BLOCK) ? event.getAmount() * 0.5f : event.getAmount()) : (amountToConsume = event.getAmount() * 1.5f);
                if (!fallFlag) {
                    int upperDamLimit = BleachConfiguration.upperDamLimit;
                    boolean flagDam = false;
                    if (upperDamLimit != -1) {
                        int maxBase = props.totalBaseReiryoku();
                        if (amountToConsume >= (float)(upperDamLimit = (int)((float)upperDamLimit + (float)maxBase / 10.0f))) {
                            int remainder = props.consumeAndUseSpirit(upperDamLimit, player);
                            amountToConsume -= (float)(upperDamLimit - remainder);
                            flagDam = true;
                        } else {
                            int remainder = props.consumeAndUseSpirit((int)amountToConsume, player);
                            if (remainder > 0) {
                                flagDam = true;
                                amountToConsume = remainder;
                            } else {
                                event.setCanceled(true);
                            }
                        }
                    } else {
                        int remainder = props.consumeAndUseSpirit((int)amountToConsume, player);
                        if (remainder > 0) {
                            flagDam = true;
                            amountToConsume = remainder;
                        } else {
                            event.setCanceled(true);
                        }
                    }
                    if (flagDam) {
                        event.setAmount(amountToConsume > 0.0f ? (amountToConsume / 3.5f > 0.0f ? amountToConsume / 3.5f : 0.0f) : 0.0f);
                    }
                } else {
                    int capMax = props.getMaxSpirit() < 750 ? props.getMaxSpirit() : 750;
                    float multiply = (float)capMax * 0.01f;
                    float fallLimit = 6.0f + multiply;
                    float fallDamage = event.getAmount();
                    if (fallDamage > fallLimit) {
                        event.setAmount(fallDamage - fallLimit);
                    }
                }
            }
            if (props.isHollow() && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase hurter = (EntityLivingBase)event.getSource().func_76346_g();
                if (props.getBack() == 2) {
                    hurter.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        int hollowOreID;
        boolean flagGol;
        boolean flagDia = event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() == BleachBlocks.hollowdiamond;
        boolean flagEme = event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() == BleachBlocks.hollowemerald;
        boolean bl = flagGol = event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() == BleachBlocks.hollowgold;
        int n = flagDia ? 0 : (flagEme ? 2 : (hollowOreID = flagGol ? 1 : -1));
        if ((flagDia || flagEme || flagGol) && hollowOreID != -1 && event.getCancellationResult() != EnumActionResult.FAIL) {
            EntityHollowOre var18 = new EntityHollowOre(event.getEntityPlayer().field_70170_p, hollowOreID);
            int var10 = event.getPos().func_177958_n();
            int var11 = event.getPos().func_177956_o();
            int var12 = event.getPos().func_177952_p();
            var18.func_70012_b(var10, var11, var12, 0.0f, 0.0f);
            event.getEntityPlayer().field_70170_p.func_72876_a(null, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), 1.0f, true);
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    for (int k = -2; k <= 2; ++k) {
                        BlockPos newPos = new BlockPos((Vec3i)event.getPos().func_177982_a(i, k, j));
                        if (event.getEntityPlayer().field_70170_p.func_180495_p(newPos).func_177230_c() == Blocks.field_150357_h) continue;
                        event.getEntityPlayer().field_70170_p.func_175698_g(newPos);
                    }
                }
            }
            event.getEntityPlayer().field_70170_p.func_72838_d((Entity)var18);
            event.getEntityPlayer().field_70170_p.func_184133_a(event.getEntityPlayer(), event.getPos(), BleachSounds.ore_hollow, var18.func_184176_by(), 1.4f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerEat(PlayerInteractEvent.RightClickItem event) {
        IBleachPlayerCap props;
        if (!event.getItemStack().func_190926_b() && (props = (IBleachPlayerCap)event.getEntityPlayer().getCapability(BleachProvider.BLEACH_CAP, null)).isHollow() && event.getItemStack().func_77973_b() instanceof ItemFood && !BleachLib.acceptedHollowFood(event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerFinishEat(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() != null && event.getEntity() instanceof EntityPlayer) {
            ItemStack stack;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            if (!event.getItem().func_190926_b() && (stack = event.getItem()).func_77973_b() instanceof ISpiritFood && !(stack.func_77973_b() instanceof ItemFood)) {
                ISpiritFood foodItem = (ISpiritFood)stack.func_77973_b();
                props.replenishSpiritEnergy(foodItem.getFood() + Math.round(foodItem.getSaturation() * 4.0f) + 2);
                player.func_71024_bL().func_75122_a(foodItem.getFood(), foodItem.getSaturation());
            }
        }
    }
}

