/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.events;

import java.util.List;
import java.util.Random;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.BleachMod;
import littlebreadloaf.bleach_kd.Names;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.ISpiritArmour;
import littlebreadloaf.bleach_kd.armor.ItemQuincyLeztzStil;
import littlebreadloaf.bleach_kd.armor.ItemShinigamiRobes;
import littlebreadloaf.bleach_kd.entities.EntityCeroCharge;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.ItemReiatsu;
import littlebreadloaf.bleach_kd.items.ItemZanpakuto;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import littlebreadloaf.bleach_kd.network.MoveMessage;
import littlebreadloaf.bleach_kd.network.ParticleMessage;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import littlebreadloaf.bleach_kd.world.SoulSocietyTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BleachPlayerCapabilities
implements IBleachPlayerCap {
    private int debugEXPmultiply = 1;
    private Random rand = new Random();
    private float[] SoulXP = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float SpiritEnergy = 1.0f;
    private float hollowEnergy = 0.0f;
    private int faction = -1;
    private int[] elementPoints = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private String ZName = "";
    private String ZShikaiCommand = "";
    private String ZBankaiCommand = "";
    private int[] Zanpakuto = new int[]{-1, -1, -1, -1};
    private int[] ZanpakutoDefault = new int[]{-1, -1, -1, -1};
    private int[] maskData = new int[]{0, 0, 0, 0, 0, 0};
    private int[] HollowKillCount = new int[]{0, 0, 0, 0, 0, 0};
    private int[] HollowDeathType = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int attackMode = 0;
    private int[] hollowType = new int[]{0, 0, 0, 0, 0, 0};
    private int menosType = 0;
    private int chainLife = -1;
    private int firstSpawnSetup = 0;
    private int[] bleachStats = new int[]{5, 5, 5, 0, 0, 0, 0, 1, 1};
    private int[] bleachExp = new int[]{0, 0, 0, -1, 0, 0, 0, 0, 0};
    private int[] factionRep = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int[] soulsocietysquad = new int[]{0, 0, 0, 0};
    private int[] abilities = new int[]{0, 0, 0, 0, 0};
    private int[] spellLevels = new int[]{0, 0, 0, 0};
    private int[] trackedData = new int[]{0, -1, 0};
    private int[] activePower = new int[]{0, 0, 0, 0, 0};
    private int[] activePowerXP = new int[]{0, 0, 0, 0, 0};
    private int[] reiryokuCreative = new int[]{0, 0, 0, 0};
    private int upgradeCount = 0;
    private int maskTimerMax = 0;
    private int maskTimer = 0;
    private int[] bleachTimers = new int[]{0, 0, 0, 0, 0, 0};
    private int[] battleInfo = new int[]{0, 0, 0};
    private int[] reiryoku = new int[]{5, 0, 0, 0};
    private int[] UnlockedPower = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int[] hollowParts = new int[]{0, 0, 0, 0, 0, 0};
    private int HTex = 0;
    private float HColorR = 1.0f;
    private float HColorB = 1.0f;
    private float HColorG = 1.0f;
    private int maxSpirit = 0;
    private int regenVsConsume = 0;
    public static int headCount = 5;
    public static int backCount = 5;
    public static int armsCount = 6;
    public static int legsCount = 5;
    public static int tailCount = 4;
    public static int texCount = 2;
    ItemStack[] Shikai = new ItemStack[]{new ItemStack(BleachItems.shikaifire, 1), new ItemStack(BleachItems.shikaiice, 1), new ItemStack(BleachItems.shikaipoison, 1), new ItemStack(BleachItems.shikaiheal, 1), new ItemStack(BleachItems.shikaiearth, 1), new ItemStack(BleachItems.shikaiwind, 1), new ItemStack(BleachItems.shikailight, 1), new ItemStack(BleachItems.shikaidark, 1), new ItemStack(BleachItems.shikailunar, 1), new ItemStack(BleachItems.shikailightning, 1), new ItemStack(BleachItems.shikaiwater, 1), new ItemStack(BleachItems.shikainormal, 1)};
    public static int[] getShikaiTex = new int[]{Names.ShikaiFire_UnlocalizedName.length - 1, Names.ShikaiIce_UnlocalizedName.length - 1, Names.ShikaiPoison_UnlocalizedName.length - 1, Names.ShikaiHeal_UnlocalizedName.length - 1, Names.ShikaiEarth_UnlocalizedName.length - 1, Names.ShikaiWind_UnlocalizedName.length - 1, Names.ShikaiLight_UnlocalizedName.length - 1, Names.ShikaiDark_UnlocalizedName.length - 1, Names.ShikaiLunar_UnlocalizedName.length - 1, Names.ShikaiLightning_UnlocalizedName.length - 1, Names.ShikaiWater_UnlocalizedName.length - 1, Names.ShikaiNormal_UnlocalizedName.length - 1};
    public static String[] getPower = new String[]{"human", "whole", "shinigami", "hollow", "quincy", "bount", "sinner", "fullbring", "visored", "menos", "adjuchas", "vastolorde", "arrancar", "ascended"};
    public static String[] getFaction = new String[]{"shinigami", "hollow", "quincy", "bount", "sinner", "xcution", "visored", "arrancar"};
    public static String[] getReiryokuName = new String[]{"base", "shinigami", "quincy", "hollow"};
    public static String[] getStatName = new String[]{"strength", "agility", "endurance", "discipline", "weapon", "ranged", "magic", "reiatsucontrol", "reishimanipulation"};

    @Override
    public int getFirstSETUP() {
        return this.firstSpawnSetup;
    }

    @Override
    public void setFirstSETUP(int value) {
        this.firstSpawnSetup = value;
    }

    @Override
    public void setupData() {
        if (this.firstSpawnSetup == 0) {
            boolean randomize = false;
            boolean randMaskSkin = false;
            if (BleachConfiguration.removeHollowEvolution) {
                randomize = true;
                randMaskSkin = true;
                if (BleachConfiguration.defaultHollow) {
                    randomize = false;
                    randomize = false;
                }
            }
            if (randomize) {
                this.randomizeHollow(false);
            }
            if (randMaskSkin) {
                this.randMaskSkin();
            }
        }
        this.firstSpawnSetup = 1;
    }

    @Override
    public void cloneSaveFunction(IBleachPlayerCap props) {
        this.setFirstSETUP(this.getFirstSETUP());
        this.setCurrentSXP(0, props.getCurrentSXP(0));
        this.setCurrentSXP(1, props.getCurrentSXP(1));
        this.setCurrentSXP(2, props.getCurrentSXP(2));
        this.setCurrentSXP(3, props.getCurrentSXP(3));
        this.setPercentSpiritEnergy(props.getPercentSpiritEnergy());
        this.setHollowPercent(props.getHollowPercent());
        this.setMaxSpirit(props.getMaxSpirit());
        this.setReiryokuArray(props.getReiryokuArray());
        this.setReiryokuCreativeArray(props.getReiryokuCreativeArray());
        this.setUpgradeCount(props.getUpgradeCount());
        this.setFaction(props.getFaction());
        this.setFactionRepArray(props.getFactionRepArray());
        this.setSoulSocietySquadArray(props.getSoulSocietySquadArray());
        this.setUnlockedPowerArray(props.getUnlockedPowerArray());
        this.setElementPointsArray(props.getElementPointsArray());
        this.setAttackMode(props.getAttackMode());
        this.setZanpakutoArray(props.getZanpakutoArray());
        this.setZName(props.getZName());
        this.setZShikaiCommand(props.getZShikaiCommand());
        this.setZBankaiCommand(props.getZBankaiCommand());
        this.setMaskDataArray(props.getMaskDataArray());
        this.setMaskTime(props.getMaskTime());
        this.setMaskTimerMax(props.getMaskTimerMax());
        this.setChainLife(props.getChainLife());
        this.setHollowKillCountArray(props.getHollowKillCountArray());
        this.setHollowDeathTypeArray(props.getHollowDeathTypeArray());
        this.setHollowTypeArray(props.getHollowTypeArray());
        this.setHollowPartArray(props.getHollowPartArray());
        this.setHTex(props.getHTex());
        this.setHColorR(props.getHColorR());
        this.setHColorB(props.getHColorB());
        this.setHColorG(props.getHColorG());
        this.setMenosType(props.getMenosType());
        this.setBleachStatsArray(props.getBleachStatsArray());
        this.setBleachExpArray(props.getBleachExpArray());
        this.setAbilitiesArray(props.getAbilitiesArray());
        this.setSpellLevelsArray(props.getSpellLevelsArray());
        this.setTrackedDataArray(props.getTrackedDataArray());
        this.setActivePowerArray(props.getActivePowerArray());
        this.setActivePowerXPArray(props.getActivePowerXPArray());
        this.setBattleInfoArray(props.getBattleInfoArray());
        this.setUpgradeCount(props.getUpgradeCount());
        this.setTimerArray(props.getTimerArray());
        this.setRegenVsConsume(props.getRegenVsConsume());
    }

    @Override
    public void setZName(String name) {
        this.ZName = name;
    }

    @Override
    public void setZShikaiCommand(String var1) {
        this.ZShikaiCommand = var1;
    }

    @Override
    public void setZBankaiCommand(String var1) {
        this.ZBankaiCommand = var1;
    }

    @Override
    public void setZType(int var1) {
        this.Zanpakuto[0] = var1;
    }

    @Override
    public void setZTexture(int var1) {
        if (var1 < 0) {
            var1 = this.rand.nextInt(5);
        }
        this.Zanpakuto[1] = var1;
    }

    @Override
    public void setZCombatStyle(int var1) {
        this.Zanpakuto[2] = var1;
    }

    @Override
    public void setZType2(int var1) {
        this.Zanpakuto[3] = var1;
    }

    @Override
    public String getZName() {
        return this.ZName;
    }

    @Override
    public String getZShikaiCommand() {
        return this.ZShikaiCommand;
    }

    @Override
    public String getZBankaiCommand() {
        return this.ZBankaiCommand;
    }

    @Override
    public int getZType() {
        return this.Zanpakuto[0];
    }

    @Override
    public int getZTexture() {
        return this.Zanpakuto[1];
    }

    @Override
    public int getZCombatStyle() {
        return this.Zanpakuto[2];
    }

    @Override
    public int getZType2() {
        return this.Zanpakuto[3];
    }

    @Override
    public void addSXPReiryoku(int amount, int index) {
        amount *= this.debugEXPmultiply;
        int n = index;
        this.SoulXP[n] = this.SoulXP[n] + (float)(amount *= BleachConfiguration.reiryokuXPRate) / (float)this.getMaxReiryoku(index);
        if ((double)this.SoulXP[index] >= 1.0) {
            this.addReiryoku(index, 1 + this.rand.nextInt(4));
            this.SoulXP[index] = 0.0f;
        }
    }

    @Override
    public void addSXP(int amount) {
        this.addSXP(amount, 0);
    }

    @Override
    public void addSXP(int amount, int index) {
        this.addSXPReiryoku(amount, index);
    }

    @Override
    public float getCurrentSXP(int index) {
        return this.SoulXP[index];
    }

    @Override
    public void setCurrentSXP(int index, float value) {
        this.SoulXP[index] = value;
    }

    @Override
    public void setCurrentSpiritEnergy(int amount) {
        float energy = (float)amount / (float)this.getMaxSpirit();
        this.SpiritEnergy = energy > 0.0f ? (energy > 1.0f ? 1.0f : energy) : 0.0f;
    }

    @Override
    public void setMaxSpirit(int amount) {
        this.maxSpirit = amount >= 5 ? amount : 5;
    }

    @Override
    public int getMaxSpirit() {
        return this.maxSpirit;
    }

    @Override
    public int getTrackedData(int index) {
        return this.trackedData[index];
    }

    @Override
    public void setTrackedData(int index, int value) {
        this.trackedData[index] = value;
    }

    @Override
    public void deactivateAllAbilities() {
        if (this.trackedData[1] != -1) {
            this.trackedData[1] = -1;
            this.trackedData[2] = 0;
        }
    }

    @Override
    public boolean useAbility(int ability, int lvl, EntityPlayer player) {
        if (this.trackedData[1] == 3) {
            Vec3d normalizer = new Vec3d(0.008, 0.008, 0.008).func_72432_b();
            List list = player.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(player.func_180425_c()).func_72321_a(Math.abs(normalizer.field_72450_a * 15.0), Math.abs(normalizer.field_72448_b * 15.0), Math.abs(normalizer.field_72449_c * 15.0)));
            boolean ceroFlag = false;
            for (int l = 0; l < list.size(); ++l) {
                EntityCeroCharge ceroCharge;
                Entity entity1 = (Entity)list.get(l);
                if (entity1 == null || !(entity1 instanceof EntityCeroCharge) || (ceroCharge = (EntityCeroCharge)entity1).getShootingEntity() == null || ceroCharge.getShootingEntity() != player) continue;
                ceroFlag = true;
                break;
            }
            if (ceroFlag) {
                this.trackedData[1] = -1;
            }
        }
        if (this.getTrackedData(1) != ability) {
            this.trackedData[1] = ability;
            this.trackedData[2] = lvl;
            boolean worked = false;
            switch (ability) {
                case 0: {
                    worked = this.activateFlashStep(lvl, player);
                    break;
                }
                case 1: {
                    worked = this.activateKidoSpell(lvl, player);
                    break;
                }
                case 3: {
                    worked = this.activateCero(lvl, player);
                    break;
                }
                case 4: {
                    worked = this.activatePortal(lvl, player);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (worked) {
                return this.consumeFromAbility(player);
            }
        }
        return false;
    }

    @Override
    public boolean activateFlashStep(int lvl, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean activateKidoSpell(int lvl, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean activateCero(int lvl, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            EntityCeroCharge ceroCharge = new EntityCeroCharge(player.field_70170_p, (EntityLivingBase)player);
            ceroCharge.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70726_aT);
            player.field_70170_p.func_72838_d((Entity)ceroCharge);
        }
        return true;
    }

    @Override
    public boolean activatePortal(int lvl, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean consumeFromAbility(EntityPlayer player) {
        int amount = 10;
        return this.consumeSpiritEnergy(amount, player);
    }

    @Override
    public float getFinalPercentEnergy() {
        return this.getPercentSpiritEnergy() - this.getHollowPercent();
    }

    @Override
    public float getPercentSpiritEnergy() {
        return this.SpiritEnergy;
    }

    @Override
    public void setPercentSpiritEnergy(float value) {
        this.SpiritEnergy = value > 1.0f ? 1.0f : (value < 0.0f ? 0.0f : value);
    }

    @Override
    public int getSpiritEnergy() {
        return (int)(this.getFinalPercentEnergy() * (float)this.getMaxSpirit());
    }

    @Override
    public int consumeAndUseSpirit(int amount, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            int remainder = this.consumeSpiritEnergy(amount, player) ? 0 : amount - this.getSpiritEnergy();
            return remainder;
        }
        return 0;
    }

    @Override
    public boolean consumeSpiritEnergy(int amount, EntityPlayer player) {
        if (amount != 0 && !player.field_71075_bZ.field_75098_d) {
            this.setRegenVsConsume(40);
            boolean sufficient = this.isEnergyMoreThan(amount);
            this.SpiritEnergy -= (float)amount / (float)this.getMaxSpirit();
            this.SpiritEnergy = this.SpiritEnergy < 0.0f ? 0.0f : (this.SpiritEnergy > 1.0f ? 1.0f : this.SpiritEnergy);
            return sufficient;
        }
        return true;
    }

    @Override
    public boolean replenishSpiritEnergy(int amount) {
        if (amount != 0) {
            boolean sufficient = this.SpiritEnergy < 1.0f;
            this.SpiritEnergy += (float)amount / (float)this.getMaxSpirit();
            float f = this.SpiritEnergy > 1.0f ? 1.0f : (this.SpiritEnergy = this.SpiritEnergy < 0.0f ? 0.0f : this.SpiritEnergy);
            if (Float.isNaN(this.SpiritEnergy)) {
                this.SpiritEnergy = 0.0f;
            }
            return sufficient;
        }
        return false;
    }

    @Override
    public boolean isEnergyMoreThan(int compareTo) {
        return this.getSpiritEnergy() > compareTo;
    }

    @Override
    public boolean isEnergyLessThan(int compareTo) {
        return this.getSpiritEnergy() < compareTo;
    }

    @Override
    public float getHollowPercent() {
        return this.hollowEnergy;
    }

    @Override
    public void setHollowPercent(float value) {
        this.hollowEnergy = value > 1.0f ? 1.0f : (value < 0.0f ? 0.0f : value);
    }

    @Override
    public void adjustHollowPercent(float value) {
        this.setHollowPercent(this.hollowEnergy += value);
    }

    @Override
    public void setPoints(int index, int amount) {
        this.elementPoints[index] = amount;
    }

    @Override
    public void addPoints(int type, int amount) {
        int n = type;
        this.elementPoints[n] = this.elementPoints[n] + amount;
    }

    @Override
    public int getPointTotal() {
        int sum = 0;
        for (int value : this.elementPoints) {
            sum += value;
        }
        return sum;
    }

    @Override
    public int getPoints(int index) {
        if (index >= 8) {
            return this.getPointTotal();
        }
        return this.elementPoints[index];
    }

    @Override
    public void setType(int type) {
        int i;
        for (i = 0; i < this.elementPoints.length; ++i) {
            this.elementPoints[i] = i == type ? 400 : 0;
        }
        switch (type) {
            case 8: {
                this.elementPoints[7] = 200;
                this.elementPoints[6] = 200;
                break;
            }
            case 9: {
                this.elementPoints[6] = 200;
                this.elementPoints[5] = 200;
                break;
            }
            case 10: {
                this.elementPoints[1] = 200;
                this.elementPoints[0] = 200;
                break;
            }
            case 11: {
                for (i = 0; i < this.elementPoints.length; ++i) {
                    this.elementPoints[i] = 50;
                }
                break;
            }
        }
        if (this.isShinigami() && this.getUnlockedPower(2) < 2) {
            this.setUnlockedPower(2, 2);
        }
    }

    @Override
    public void setType2(int type) {
        int element = this.elementPoints[type];
        int current = this.getPointTotal();
        int toAdd = 1000 - current;
        if (element + toAdd > 1000) {
            this.elementPoints[type] = 1000;
            toAdd = element + toAdd - 1000;
        }
        int i = 0;
        while (i < this.elementPoints.length) {
            if (this.elementPoints[i] + toAdd <= 1000) {
                int n = i;
                this.elementPoints[n] = this.elementPoints[n] + toAdd;
                break;
            }
            int diff = this.elementPoints[i] + toAdd - 1000;
            int n = i++;
            this.elementPoints[n] = this.elementPoints[n] + (toAdd - diff);
            toAdd = diff;
            if (toAdd <= 0) break;
        }
        if (this.isShinigami() && this.getUnlockedPower(2) < 4) {
            this.setUnlockedPower(2, 4);
        }
    }

    @Override
    public void resetPlayerData() {
        this.SoulXP = new float[4];
        this.setPercentSpiritEnergy(1.0f);
        this.setHollowPercent(0.0f);
        this.setMaxSpirit(0);
        this.resetReiryoku();
        this.setUpgradeCount(0);
        this.setFaction(-1);
        this.setFactionRepArray(new int[7]);
        this.setSoulSocietySquadArray(new int[4]);
        this.setUnlockedPowerArray(new int[8]);
        this.setElementPointsArray(new int[8]);
        this.setAttackMode(0);
        this.setZanpakutoArray(this.ZanpakutoDefault);
        this.setZName("");
        this.setZShikaiCommand("");
        this.setZBankaiCommand("");
        this.resetMask();
        this.resetChainLife();
        this.setHollowKillCountArray(new int[6]);
        this.resetHollow();
        int[] tempbleachStats = new int[]{5, 5, 5, 0, 0, 0, 0, 1, 1};
        this.setBleachStatsArray(tempbleachStats);
        int[] tempbleachExp = new int[]{0, 0, 0, -1, 0, 0, 0, 0, 0};
        this.setBleachExpArray(tempbleachExp);
        this.setAbilitiesArray(new int[5]);
        this.setSpellLevelsArray(new int[4]);
        int[] tempData = new int[]{0, -1, 0};
        this.setTrackedDataArray(tempData);
        this.setActivePowerArray(new int[5]);
        this.setActivePowerXPArray(new int[5]);
        this.setBattleInfoArray(new int[3]);
    }

    @Override
    public void resetType() {
        this.elementPoints = new int[8];
        this.Zanpakuto = this.ZanpakutoDefault;
        this.setZName("");
        if (this.getUnlockedPower(0) >= 2) {
            this.setUnlockedPower(2, 1);
        }
    }

    @Override
    public void randomTexture() {
        this.setZTexture(this.rand.nextInt(5));
    }

    @Override
    public void setAttackMode(int var1) {
        this.attackMode = var1;
    }

    @Override
    public int getAttackMode() {
        return this.attackMode;
    }

    @Override
    public void resetMask() {
        this.maskData = new int[6];
        this.maskTimer = 0;
        this.maskTimerMax = 0;
    }

    @Override
    public int getMaskData(int index) {
        return this.maskData[index];
    }

    @Override
    public void setMaskData(int index, int value) {
        this.maskData[index] = value;
    }

    @Override
    public void updateMaskVariant() {
        int maskNBT = this.getMaskData(0);
        maskNBT = ++maskNBT >= 7 ? 0 : (maskNBT < 0 ? 0 : maskNBT);
        this.setMaskData(0, maskNBT);
    }

    @Override
    public boolean checkValidFlash(EntityPlayer player) {
        if (!this.isQuincy() && BleachLib.isEntityInCube((Entity)player)) {
            return false;
        }
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (player.field_70170_p.func_180495_p(new BlockPos((int)player.field_70165_t, (int)(player.field_70163_u + (double)j), (int)(player.field_70161_v + (double)k))) == Blocks.field_150350_a) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void decideWhatToDo(int readInt, EntityPlayer player) {
        if (readInt == 1) {
            if (player.field_70122_E && this.checkValidFlash(player)) {
                boolean configOverride;
                int distance = 9;
                boolean bl = configOverride = BleachConfiguration.spiritFlashandArmour == 2 || BleachConfiguration.spiritFlashandArmour == 3;
                if ((this.getUnlockedPower(7) != 0 && this.getActivePower(4) != 0 || this.fullOutfit(0, player) || configOverride) && this.isEnergyMoreThan(5)) {
                    if (player instanceof EntityPlayerMP) {
                        BleachMod.network.sendTo((IMessage)new MoveMessage(distance), (EntityPlayerMP)player);
                    }
                    this.consumeSpiritEnergy(5, player);
                    player.field_70170_p.func_184133_a(null, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), BleachSounds.shunpo, SoundCategory.PLAYERS, 0.4f, 1.0f);
                }
            }
        } else if (readInt == 2) {
            Item curr;
            if (this.isQuincy() && this.getUnlockedPower(4) >= 3 && this.getFinalPercentEnergy() > 0.2f && player.func_184614_ca() != null && player.func_184614_ca().func_190916_E() == 1 && ((curr = player.func_184614_ca().func_77973_b()) == BleachItems.sanreiGlove || curr == BleachArmor.QuincyLeztzStil)) {
                this.activateLeztzStil(player);
            }
            if (!this.isHollow() && !this.isFullBring() && this.getUnlockedPower(3) != 0) {
                if (this.getActivePower(2) == 0) {
                    this.activateMask(player);
                } else if (this.getActivePower(2) == 1) {
                    this.deactivateMask();
                }
            }
            if (this.isHollow()) {
                if (player.func_70093_af() && this.getFaction() != 3) {
                    this.useAbility(3, 1, player);
                    return;
                }
                if (this.getAttackMode() == 0) {
                    this.setAttackMode(1);
                    return;
                }
                if (this.getAttackMode() == 1) {
                    this.setAttackMode(0);
                    return;
                }
            }
            if (this.isArrancar() && player.func_70093_af() && this.getFactionId() != 3) {
                this.useAbility(3, 1, player);
                return;
            }
        } else {
            if (readInt == 3) {
                ItemStack bleachGuide = new ItemStack(BleachItems.bleachGuideBook);
                if (!player.field_71071_by.func_70441_a(bleachGuide)) {
                    player.func_191521_c(bleachGuide);
                }
                return;
            }
            if (readInt == 11) {
                if (this.reiryoku[0] < 50) {
                    this.setReiryoku(0, 50);
                }
                this.setAsShinigami(0, 0);
            } else if (readInt == 12) {
                if (this.reiryoku[0] < 50) {
                    this.setReiryoku(0, 50);
                }
                this.setAsHollow(0, 0);
            } else if (readInt == 13) {
                if (this.reiryoku[0] < 50) {
                    this.setReiryoku(0, 50);
                }
                this.setAsQuincy(0, 0);
            } else if (readInt == 14) {
                this.setAsHuman(0);
                this.powerUpdate();
            }
        }
    }

    @Override
    public void activate(ItemStack stack, int attackMode, EntityPlayer player) {
        if (attackMode == -1) {
            ItemReiatsu reiatsu;
            if (!BleachConfiguration.debugDISABLE && stack.func_77973_b() == BleachItems.gargantaItem && player.field_71075_bZ.field_75098_d && (player.func_110124_au().toString().equals("7b074877-010a-4941-b8c4-d18dd6705fd1") || stack.func_82833_r().equals("KNIGHT_userpass-13522456")) && !player.field_70170_p.field_72995_K) {
                if (player.field_71093_bK == BleachWorldGen.SoulSociety_ID) {
                    player.changeDimension(0, (ITeleporter)SoulSocietyTeleporter.getTeleporterForDim(player.func_184102_h(), 0));
                } else if (!BleachConfiguration.restrictSoulSociety || player.field_71075_bZ.field_75098_d) {
                    player.changeDimension(BleachWorldGen.SoulSociety_ID, (ITeleporter)SoulSocietyTeleporter.getTeleporterForDim(player.func_184102_h(), BleachWorldGen.SoulSociety_ID));
                }
            }
            if (this.isHollow() && stack.func_77973_b() == BleachItems.shinai && stack.func_190916_E() == 1) {
                ItemStack hand = new ItemStack(BleachItems.hollowHand);
                player.func_184201_a(EntityEquipmentSlot.MAINHAND, hand);
            }
            if (this.isHollowBASE() && stack.func_77973_b() == BleachItems.reiatsu && stack.func_190916_E() == 1 && (this.getReiryoku(3) >= 5 && this.getAbilityLevel(4) >= 2 || player.field_71075_bZ.field_75098_d) && (reiatsu = (ItemReiatsu)stack.func_77973_b()).getHollowActive(stack) == 0) {
                this.reduceReiryoku(3, 5);
                reiatsu.setHollowActive(stack, 0);
                return;
            }
            if (stack.func_77973_b() == BleachItems.zanpakuto && !this.isArrancar()) {
                boolean nameFlag;
                if (this.getZType() == -1) {
                    return;
                }
                if (this.getUnlockedPower(2) < 2 && this.isShinigami() && this.getBleachStat(4) >= 15 && this.getZType() != -1) {
                    double var2 = player.field_70165_t;
                    double var3 = player.field_70163_u;
                    double var4 = player.field_70161_v;
                    if (!player.field_70170_p.field_72995_K) {
                        BleachMod.network.sendToAll((IMessage)new ParticleMessage(5, var2 - 0.9, var3 + 1.0, var4 + 0.5));
                    }
                    this.setUnlockedPower(2, 2);
                    return;
                }
                boolean bl = nameFlag = stack.func_82837_s() && stack.func_82833_r().equalsIgnoreCase(this.getZName()) || !stack.func_82837_s();
                if (this.getZType() > -1 && this.getUnlockedPower(2) >= 2 && this.reiryoku[0] >= 200 && nameFlag && this.isShinigami()) {
                    if (!player.field_70170_p.field_72995_K) {
                        if (this.getZTexture() == -1) {
                            this.randomTexture();
                            if (this.getZType() == 0 && this.getZName().equalsIgnoreCase("vox populi")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 1) {
                                if (this.getZName().equalsIgnoreCase("ice cream")) {
                                    this.setZTexture(5);
                                } else if (this.getZName().equalsIgnoreCase("mizore")) {
                                    this.setZTexture(6);
                                }
                            } else if (this.getZType() == 2 && this.getZName().equalsIgnoreCase("ashisogi jizo")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 3 && this.getZName().equalsIgnoreCase("love")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 4 && this.getZName().equalsIgnoreCase("piko piko")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 5) {
                                if (this.getZName().equalsIgnoreCase("fightin words")) {
                                    this.setZTexture(5);
                                } else if (this.getZName().equalsIgnoreCase("undulatis")) {
                                    this.setZTexture(6);
                                } else if (this.getZName().equalsIgnoreCase("anduril")) {
                                    this.setZTexture(7);
                                } else if (this.getZName().equalsIgnoreCase("kros")) {
                                    this.setZTexture(8);
                                }
                            } else if (this.getZType() == 6 && this.getZName().equalsIgnoreCase("master sword")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 7) {
                                if (this.getZName().equalsIgnoreCase("souledge")) {
                                    this.setZTexture(5);
                                } else if (this.getZName().equalsIgnoreCase("kage kishi")) {
                                    this.setZTexture(6);
                                } else if (this.getZName().equalsIgnoreCase("onmyo")) {
                                    this.setZTexture(7);
                                } else if (this.getZName().equalsIgnoreCase("neko senro")) {
                                    this.setZTexture(8);
                                } else if (this.getZName().equalsIgnoreCase("kumori tora tsume")) {
                                    this.setZTexture(9);
                                }
                            } else if (this.getZType() == 8 && this.getZName().equalsIgnoreCase("zangetsu")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 9 && this.getZName().equalsIgnoreCase("mjolnir")) {
                                this.setZTexture(5);
                            } else if (this.getZType() == 10) {
                                if (this.getZName().equalsIgnoreCase("sakana")) {
                                    this.setZTexture(5);
                                } else if (this.getZName().equalsIgnoreCase("hi-yari")) {
                                    this.setZTexture(6);
                                }
                            } else if (this.getZType() == 11) {
                                if (this.getZName().equalsIgnoreCase("ticonderoga")) {
                                    this.setZTexture(5);
                                } else if (this.getZName().equalsIgnoreCase("setsuna")) {
                                    this.setZTexture(6);
                                } else if (this.getZName().equalsIgnoreCase("zenhansha")) {
                                    this.setZTexture(7);
                                }
                            }
                        }
                        ItemStack shikai = new ItemStack(this.Shikai[this.getZType()].func_77973_b(), 1, this.getZTexture());
                        shikai.func_151001_c(stack.func_82833_r());
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, shikai);
                        Vec3d normalizer = new Vec3d(0.008, 0.008, 0.008).func_72432_b();
                        List list = player.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(player.func_180425_c()).func_72321_a(Math.abs(normalizer.field_72450_a * 15.0), Math.abs(normalizer.field_72448_b * 15.0), Math.abs(normalizer.field_72449_c * 15.0)));
                        for (int l = 0; l < list.size(); ++l) {
                            Entity entity1 = (Entity)list.get(l);
                            if (entity1 == null || !(entity1 instanceof EntityPlayer)) continue;
                            EntityPlayer surroundingPlayers = (EntityPlayer)entity1;
                            surroundingPlayers.func_145747_a((ITextComponent)new TextComponentTranslation(Names.ShikaiPhrases[6 * this.getZType() + this.getZTexture()] + " " + stack.func_82833_r() + "!", new Object[0]));
                        }
                    }
                    this.addStatExp(7, 1);
                    this.addStatExp(8, 3);
                    this.consumeSpiritEnergy(50, player);
                    return;
                }
            }
            if (stack.func_77973_b() instanceof ItemZanpakuto && this.isArrancar()) {
                ItemZanpakuto zan = (ItemZanpakuto)stack.func_77973_b();
                if (zan.getHollowActive(stack) == 0) {
                    zan.setHollowActive(stack, 1);
                } else if (zan.getHollowActive(stack) == 1) {
                    if (this.getActivePower(1) == 0 && this.getSpiritEnergy() > 100) {
                        this.activateResurrecion();
                    } else if (this.getActivePower(1) != 0) {
                        this.deactivateHollow();
                    }
                }
                return;
            }
            if (stack.func_77973_b() instanceof ItemShikai) {
                if (this.getZType2() == -1) {
                    return;
                }
                if (this.getZType2() > -1 && this.getUnlockedPower(2) >= 3 && this.reiryoku[0] >= 200 && this.isShinigami() && this.getBleachStat(7) >= 40) {
                    if (this.getUnlockedPower(2) == 3) {
                        this.setUnlockedPower(2, 4);
                    }
                    if (this.getActivePower(0) == 0) {
                        if (!player.field_70170_p.field_72995_K) {
                            Vec3d normalizer = new Vec3d(0.008, 0.008, 0.008).func_72432_b();
                            List list = player.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(player.func_180425_c()).func_72321_a(Math.abs(normalizer.field_72450_a * 15.0), Math.abs(normalizer.field_72448_b * 15.0), Math.abs(normalizer.field_72449_c * 15.0)));
                            for (int l = 0; l < list.size(); ++l) {
                                Entity entity1 = (Entity)list.get(l);
                                if (entity1 == null || !(entity1 instanceof EntityPlayer)) continue;
                                EntityPlayer surroundingPlayers = (EntityPlayer)entity1;
                                surroundingPlayers.func_145747_a((ITextComponent)new TextComponentTranslation("BANKAI!", new Object[0]));
                            }
                        }
                        this.activateBankai();
                        this.addStatExp(7, 20);
                        this.addStatExp(8, 30);
                        this.consumeSpiritEnergy(200, player);
                    } else {
                        this.deactivateBankai();
                    }
                    return;
                }
            }
        }
        if ((this.isFullBring() || this.getUnlockedPower(7) != 0) && !this.isHollow()) {
            if (this.getActivePower(4) == 0) {
                this.activateFullBring();
                if (attackMode == -1) {
                    // empty if block
                }
                return;
            }
            this.deactivateFullBring();
            return;
        }
    }

    @Override
    public void deactivate(ItemStack theItemStack, int itemSlot, EntityPlayer player) {
        if (theItemStack == null) {
            return;
        }
        boolean offHandFlag = false;
        Item theItem = theItemStack.func_77973_b();
        ItemStack toGive = ItemStack.field_190927_a;
        if (player.func_184582_a(EntityEquipmentSlot.OFFHAND) == theItemStack) {
            offHandFlag = true;
        }
        if (theItem instanceof ItemShikai) {
            toGive = new ItemStack(BleachItems.zanpakuto);
            if (theItemStack.func_82837_s()) {
                toGive.func_151001_c(theItemStack.func_82833_r());
            }
            if (this.activePower[0] > 0) {
                this.deactivateBankai();
            }
        } else if (theItem == BleachItems.quincybow) {
            toGive = new ItemStack(BleachItems.quincypendant);
        } else if (theItem == BleachItems.quincyweb) {
            toGive = new ItemStack(BleachItems.quincypentacle);
        } else if (theItem == BleachItems.seeleactive) {
            toGive = new ItemStack(BleachItems.seele);
        } else if (theItem == BleachItems.quincybanglebow) {
            int damage = theItem.getDamage(theItemStack);
            toGive = new ItemStack(BleachItems.quincybangle);
            toGive.func_77964_b(damage);
        }
        if (toGive.func_190926_b()) {
            return;
        }
        if (offHandFlag) {
            player.func_184201_a(EntityEquipmentSlot.OFFHAND, toGive);
        } else {
            player.field_71071_by.func_70299_a(itemSlot, toGive);
        }
    }

    @Override
    public int armourCheck(int armorSlot, EntityPlayer player) {
        ItemStack armour = (ItemStack)player.field_71071_by.field_70460_b.get(armorSlot);
        if (!armour.func_190926_b() && armour.func_77973_b() instanceof ISpiritArmour) {
            ISpiritArmour spiritArmour = (ISpiritArmour)armour.func_77973_b();
            return spiritArmour.getFaction();
        }
        return -1;
    }

    @Override
    public boolean fullOutfit(int factionCheck, EntityPlayer player) {
        int sum = 0;
        for (int i = 0; i < 3; ++i) {
            if (factionCheck != 0) {
                if (this.armourCheck(i, player) != factionCheck) continue;
                ++sum;
                continue;
            }
            if (this.armourCheck(i, player) == -1) continue;
            ++sum;
        }
        return sum == 3;
    }

    @Override
    public boolean fullQuincy(EntityPlayer player) {
        ItemStack shoes = player.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack pants = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return this.fullOutfit(2, player) && this.isQuincy() && shoes != null && shoes.func_77973_b() == BleachArmor.QuincyShoes && pants != null && pants.func_77973_b() == BleachArmor.QuincyPants && chest != null && chest.func_77973_b() == BleachArmor.QuincyRobe;
    }

    @Override
    public boolean fullShinigami(EntityPlayer player) {
        ItemStack shoes = player.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack pants = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return this.fullOutfit(1, player) && this.isShinigami() && shoes != null && shoes.func_77973_b() == BleachArmor.Sandals && pants != null && pants.func_77973_b() == BleachArmor.ShiniPants && chest != null && (chest.func_77973_b() == BleachArmor.ShiniRobe || chest.func_77973_b() == BleachArmor.ShiniCaptain);
    }

    @Override
    public boolean fullArrancar(EntityPlayer player) {
        ItemStack shoes = player.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack pants = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return this.fullOutfit(3, player) && this.isArrancar() && shoes != null && shoes.func_77973_b() == BleachArmor.ArrancarShoes && pants != null && pants.func_77973_b() == BleachArmor.ArrancarPants && chest != null && chest.func_77973_b() == BleachArmor.ArrancarJacket;
    }

    @Override
    public void setUnlockedPower(int index, int par1) {
        this.UnlockedPower[index] = par1;
        this.powerUpdate();
        this.updateFaction();
    }

    @Override
    public int getUnlockedPower(int index) {
        return this.UnlockedPower[index];
    }

    @Override
    public void setAbilityUnlock(int index, int level) {
        this.abilities[index] = level;
    }

    @Override
    public void unlockedPowerFIX() {
        if (this.UnlockedPower.length < 8) {
            int[] temp = new int[8];
            for (int i = 0; i < 7; ++i) {
                temp[i] = this.UnlockedPower[i];
            }
            this.setUnlockedPowerArray(temp);
        }
    }

    @Override
    public int getAbilityLevel(int index) {
        return this.abilities[index];
    }

    @Override
    public void decreaseMaskTimer(int amount) {
        int maskTime;
        if (amount == 0) {
            amount = 1;
        }
        if ((maskTime = this.getMaskTime()) > 0) {
            this.setMaskTime(maskTime - amount);
        }
        if (this.getMaskTime() <= 0) {
            this.setMaskTime(0);
            this.deactivateMask();
        }
    }

    @Override
    public void recoverMaskEnergy(int amount) {
        if (this.activePower[2] == 0) {
            if (amount == 0) {
                amount = 1;
            }
            if (this.getMaskTime() < this.getMaskTimerMax()) {
                this.setMaskTime(this.getMaskTime() + 1);
            }
        }
    }

    @Override
    public void setMaskTimerMax() {
        int maskLvl = this.getUnlockedPower(3);
        int reiHollow = this.reiryoku[3];
        int time = reiHollow / 10 / maskLvl;
        int newMaskTimeMax = 10 + time;
        this.setMaskTimerMax(newMaskTimeMax);
    }

    @Override
    public int getMaskTime() {
        return this.maskTimer;
    }

    @Override
    public void setMaskTime(int value) {
        this.maskTimer = value;
    }

    @Override
    public int getMaskTimerMax() {
        return this.maskTimerMax;
    }

    @Override
    public void setMaskTimerMax(int value) {
        this.maskTimerMax = value;
    }

    @Override
    public boolean activateMask(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            int maskTimerMaxTemp = this.getMaskTimerMax();
            if ((float)this.getMaskTime() > 0.1f * (float)maskTimerMaxTemp) {
                this.activatePower(2, 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public void activateBankai() {
        this.activatePower(0, 1);
    }

    @Override
    public void activateResurrecion() {
        this.activatePower(1, 1);
    }

    @Override
    public void activateSepunda() {
        this.activatePower(1, 2);
    }

    @Override
    public void activateLeztzStil(EntityPlayer player) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack current = player.func_184614_ca();
        if (!player.field_70170_p.field_72995_K) {
            ItemStack letz = new ItemStack(BleachArmor.QuincyLeztzStil);
            if (current.func_77973_b() instanceof ItemQuincyLeztzStil) {
                letz = current.func_77946_l();
            }
            ItemQuincyLeztzStil leztz = (ItemQuincyLeztzStil)letz.func_77973_b();
            int type = 0;
            if (chest != null) {
                int n = chest.func_77973_b() == BleachArmor.QuincyRobe ? 1 : (chest.func_77973_b() == BleachArmor.QuincyRobe2 ? 2 : (type = chest.func_77973_b() == BleachArmor.ShiniRobe ? 3 : 0));
                if (type == 3) {
                    ItemShinigamiRobes chestR = (ItemShinigamiRobes)chest.func_77973_b();
                    int hollow = chestR.decodeCloakData(chest, 9);
                    type += hollow;
                }
                BleachLib.unequipItem(player, EntityEquipmentSlot.CHEST);
            }
            leztz.setCloakVariation(letz, type);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            }
            player.func_184201_a(EntityEquipmentSlot.CHEST, letz);
        }
        this.activatePower(3, 1);
    }

    @Override
    public void activateVolstandig() {
        this.activatePower(3, 2);
    }

    @Override
    public void activateVolstandig2() {
        this.activatePower(3, 3);
    }

    @Override
    public void activateFullBring() {
        this.activatePower(4, 1);
    }

    @Override
    public void activateFullPowerFullBring() {
        this.activatePower(4, 2);
    }

    @Override
    public void activatePower(int power, int level) {
        boolean flag = false;
        if (power == 0 && this.isShinigami() && this.getUnlockedPower(2) >= 4 && this.activePower[0] == 0) {
            this.activePower[0] = 1;
            flag = true;
        }
        if (power == 1 && this.isArrancar()) {
            int n = level > 2 ? 2 : (level = level < 0 ? 0 : level);
            if (this.activePower[1] == 0 && level >= 1 && this.getUnlockedPower(2) >= 2) {
                this.activePower[1] = 1;
                flag = true;
            } else if (this.activePower[1] == 1 && level == 2 && this.getUnlockedPower(2) >= 3) {
                this.activePower[1] = 2;
                flag = true;
            }
        }
        if (power == 2 && this.isVisored() && this.activePower[2] == 0 && this.getUnlockedPower(3) > 0) {
            this.activePower[2] = 1;
            flag = true;
        }
        if (power == 3 && this.isQuincy()) {
            int n = level < 0 ? 0 : (level = level > 3 ? 3 : level);
            if (this.activePower[3] == 0 && level >= 1 && this.getUnlockedPower(4) >= 3) {
                this.activePower[3] = 1;
                flag = true;
            } else if (this.activePower[3] == 1 && level >= 2 && this.getUnlockedPower(4) >= 4) {
                this.activePower[3] = 2;
                flag = true;
            } else if (this.activePower[3] == 2 && level >= 3 && this.getUnlockedPower(4) >= 5) {
                this.activePower[3] = 3;
                flag = true;
            }
        }
        if (power == 4 && this.isFullBring()) {
            int n = level < 0 ? 0 : (level = level > 2 ? 2 : level);
            if (this.activePower[4] == 0 && level >= 1 && this.getUnlockedPower(7) >= 1) {
                this.activePower[4] = 1;
                flag = true;
            } else if (this.activePower[4] == 1 && level >= 2 && this.getUnlockedPower(7) >= 2) {
                this.activePower[4] = 2;
                flag = true;
            }
        }
        if (flag) {
            this.powerUpdate();
        }
    }

    @Override
    public void trackActivePowers(EntityPlayer player) {
        for (int i = 0; i < 5; ++i) {
            if (this.getActivePower(i) == 0) continue;
            this.consumeSpiritFromPower(i, this.getActivePower(i), player);
            this.addExperienceFromPower(i, this.getActivePower(i));
        }
    }

    @Override
    public int getActivePower(int index) {
        return this.activePower[index];
    }

    @Override
    public void addExperienceFromPower(int power, int level) {
        int expToAdd = 1;
        int powerXP = this.activePowerXP[power];
        if (powerXP < 1000) {
            int n = power;
            this.activePowerXP[n] = this.activePowerXP[n] + expToAdd;
        }
        if (power == 2 && powerXP >= 10 * this.getMaskTimerMax()) {
            this.addHollowReiryoku(this.rand.nextInt(4) + 1);
            this.activePowerXP[power] = 0;
        }
    }

    @Override
    public void consumeSpiritFromPower(int power, int level, EntityPlayer player) {
        int amount = 20;
        if (power == 4 && level == 1) {
            amount = 5;
        }
        if (power == 2) {
            int maskLevel = this.getUnlockedPower(3);
            int maskTime = this.getMaskTimerMax();
            amount *= maskLevel;
            amount -= maskTime / 5;
        }
        amount = amount < 5 ? 5 : amount;
        this.consumeSpiritEnergy(amount, player);
        if (this.getSpiritEnergy() <= 0) {
            this.deactivatePower(power);
        }
    }

    @Override
    public void deactivateAllPowers() {
        for (int i = 0; i < 5; ++i) {
            this.deactivatePower(i);
        }
    }

    @Override
    public void deactivatePower(int power) {
        this.activePower[power] = 0;
        this.powerUpdate();
    }

    @Override
    public void deactivateBankai() {
        this.deactivatePower(0);
    }

    @Override
    public void deactivateHollow() {
        this.deactivatePower(1);
    }

    @Override
    public void deactivateMask() {
        this.setMaskTimerMax();
        this.deactivatePower(2);
    }

    @Override
    public void deactivateQuincy() {
        this.deactivatePower(3);
    }

    @Override
    public void deactivateFullBring() {
        this.deactivatePower(4);
    }

    @Override
    public void powerUpdate() {
        this.setMaxSpirit(this.setUsableMaxReiryoku());
    }

    @Override
    public void setHTex(int var1) {
        this.HTex = var1;
    }

    @Override
    public void setHead(int var1) {
        this.hollowParts[0] = var1;
    }

    @Override
    public void setBack(int var1) {
        this.hollowParts[1] = var1;
    }

    @Override
    public void setArms(int var1) {
        this.hollowParts[2] = var1;
    }

    @Override
    public void setLegs(int var1) {
        this.hollowParts[3] = var1;
    }

    @Override
    public void setTail(int var1) {
        this.hollowParts[4] = var1;
    }

    @Override
    public void setHColorR(float var1) {
        this.HColorR = var1;
    }

    @Override
    public void setHColorB(float var1) {
        this.HColorB = var1;
    }

    @Override
    public void setHColorG(float var1) {
        this.HColorG = var1;
    }

    @Override
    public void setHollowTypes(int index, int amount) {
        this.hollowType[index] = amount;
        if (index == 5 && amount >= 1 && this.isHollow() && this.getUnlockedPower(3) < 2) {
            this.setUnlockedPower(3, 2);
        }
    }

    @Override
    public void addHollowType(int type, int amount) {
        int n = type;
        this.hollowType[n] = this.hollowType[n] + amount;
    }

    @Override
    public int getHollowTypeTotal(boolean include5) {
        int sum = 0;
        for (int value : this.hollowType) {
            sum += value;
        }
        if (!include5) {
            sum -= this.hollowType[5];
        }
        return sum;
    }

    @Override
    public int getHollowType(int index) {
        return this.hollowType[index];
    }

    @Override
    public int getHTex() {
        return this.HTex;
    }

    @Override
    public int getHead() {
        return this.hollowParts[0];
    }

    @Override
    public int getBack() {
        return this.hollowParts[1];
    }

    @Override
    public int getArms() {
        return this.hollowParts[2];
    }

    @Override
    public int getLegs() {
        return this.hollowParts[3];
    }

    @Override
    public int getTail() {
        return this.hollowParts[4];
    }

    @Override
    public float getHColorR() {
        return this.HColorR;
    }

    @Override
    public float getHColorB() {
        return this.HColorB;
    }

    @Override
    public float getHColorG() {
        return this.HColorG;
    }

    @Override
    public void randMaskSkin() {
        Random rand = new Random();
        this.setHColorR(rand.nextFloat());
        this.setHColorB(rand.nextFloat());
        this.setHColorG(rand.nextFloat());
        this.setHTex(rand.nextInt(texCount + 1));
    }

    @Override
    public void randomizeHollow(boolean fullCheck) {
        Random rand = new Random();
        this.setHColorR(rand.nextFloat());
        this.setHColorB(rand.nextFloat());
        this.setHColorG(rand.nextFloat());
        this.setHTex(rand.nextInt(texCount + 1));
        this.setHead(rand.nextInt(headCount + 1));
        this.setBack(rand.nextInt(backCount + 1));
        this.setLegs(rand.nextInt(legsCount + 1));
        this.setArms(rand.nextInt(armsCount + 1));
        this.setTail(rand.nextInt(tailCount + 1));
        this.setMenosType(rand.nextInt(9));
        if (this.getHollowPart(5) <= 1 && fullCheck) {
            this.setHollowPart(5, 1);
        }
        if (!fullCheck) {
            this.setHollowPart(5, 0);
        }
    }

    @Override
    public void setHollowPart(int partType) {
        switch (partType) {
            case 0: {
                if (this.getHead() == 0) {
                    this.setHead(this.rand.nextInt(headCount + 1));
                }
                return;
            }
            case 1: {
                if (this.getBack() == 0) {
                    this.setBack(this.rand.nextInt(backCount + 1));
                }
                return;
            }
            case 2: {
                if (this.getArms() == 0) {
                    this.setArms(this.rand.nextInt(armsCount + 1));
                }
                return;
            }
            case 3: {
                if (this.getLegs() == 0) {
                    this.setLegs(this.rand.nextInt(legsCount + 1));
                }
                return;
            }
            case 4: {
                if (this.getTail() == 0) {
                    this.setTail(this.rand.nextInt(tailCount + 1));
                }
                return;
            }
        }
    }

    @Override
    public void setHollowPart(int index, int part) {
        this.hollowParts[index] = part;
        if (this.getUnlockedPower(3) == 1 && index == 5 && part == 1) {
            this.setUnlockedPower(3, 2);
        }
    }

    @Override
    public int getHollowPart(int partType) {
        return this.hollowParts[partType];
    }

    @Override
    public boolean isTailUsable() {
        switch (this.getLegs()) {
            case 3: {
                return false;
            }
        }
        switch (this.getTail()) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void resetHollow() {
        this.setHColorR(1.0f);
        this.setHColorB(1.0f);
        this.setHColorG(1.0f);
        this.setHTex(0);
        for (int i = 0; i < 6; ++i) {
            this.hollowType[i] = 0;
            this.hollowParts[i] = 0;
        }
        this.setMenosType(0);
        this.setHollowDeathTypeArray(new int[7]);
    }

    @Override
    public void setMenosType(int type) {
        this.menosType = type;
    }

    @Override
    public int getMenosType() {
        return this.menosType;
    }

    @Override
    public void setHollowKillCount(int index, int value) {
        this.HollowKillCount[index] = value;
    }

    @Override
    public int getHollowKillCount(int index) {
        if (index >= 6) {
            int sum = 0;
            for (int value : this.HollowKillCount) {
                sum += value;
            }
            return sum;
        }
        return this.HollowKillCount[index];
    }

    @Override
    public void addHollowKill(int type, int amount) {
        int n = type;
        this.HollowKillCount[n] = this.HollowKillCount[n] + amount;
        if (this.isHollow() && this.getUnlockedPower(3) >= 2) {
            int hollowStage = this.getUnlockedPower(3);
            if (hollowStage == 2 && this.getHollowKillCount(6) >= 100) {
                if (BleachConfiguration.disablePathing[8] == 0) {
                    if (this.getMenosType() == 0) {
                        this.setMenosType(this.rand.nextInt(9));
                    }
                    this.setAsMenos(1);
                }
            } else if (hollowStage == 3 && this.getHollowKillCount(5) >= 100 && this.getReiryoku(3) >= 150 && BleachConfiguration.disablePathing[9] == 0) {
                this.setAsAdjuchas(1);
            }
        }
    }

    @Override
    public void setHollowDeathType(int index, int value) {
        this.HollowDeathType[index] = value;
    }

    @Override
    public int getHollowDeathType(int index) {
        return this.HollowDeathType[index];
    }

    @Override
    public int getFactionRep(int index) {
        return this.factionRep[index];
    }

    @Override
    public void setFactionRep(int index, int value) {
        this.factionRep[index] = value;
    }

    @Override
    public int getSoulSocietySquad() {
        return this.soulsocietysquad[0];
    }

    @Override
    public int getSoulSocietySquadRank() {
        return this.soulsocietysquad[1];
    }

    @Override
    public void setSoulSocietySquad(int value) {
        this.soulsocietysquad[0] = value;
    }

    @Override
    public void setSoulSocietySquadRank(int value) {
        this.soulsocietysquad[1] = value;
    }

    @Override
    public boolean isHuman() {
        return this.getUnlockedPower(0) == 0 || this.getUnlockedPower(1) == 0 && (this.getUnlockedPower(0) == 7 || this.getUnlockedPower(0) == 5);
    }

    @Override
    public boolean isSpirit() {
        return this.getUnlockedPower(1) == 1;
    }

    @Override
    public boolean noPowers() {
        boolean flag = true;
        if (this.getUnlockedPower(0) == 0) {
            for (int i = 2; i < this.UnlockedPower.length; ++i) {
                if (this.getUnlockedPower(i) == 0) continue;
                flag = false;
                break;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean isAWhole() {
        return this.getFaction() == 1;
    }

    @Override
    public boolean isHumanFac() {
        return this.getFaction() == 0;
    }

    @Override
    public boolean isShinigami() {
        int fac = this.getFaction();
        return fac == 2 || fac == 8;
    }

    @Override
    public boolean isShinigamiFac() {
        return this.getFaction() == 2;
    }

    @Override
    public boolean isVisored() {
        return this.getFaction() == 8;
    }

    @Override
    public boolean isQuincy() {
        return this.getFaction() == 4;
    }

    @Override
    public boolean isHollow() {
        int fac = this.getFaction();
        return fac == 3 || fac == 9 || fac == 10 || fac == 11;
    }

    @Override
    public boolean isHollowBASE() {
        int fac = this.getFaction();
        return fac == 3 || fac == 9 || fac == 10 || fac == 11 || fac == 12;
    }

    @Override
    public boolean isArrancar() {
        return this.getFaction() == 12;
    }

    @Override
    public boolean isBount() {
        return this.getFaction() == 5;
    }

    @Override
    public boolean isFullBring() {
        return this.getFaction() == 7;
    }

    @Override
    public boolean isTogabito() {
        return this.getFaction() == 6;
    }

    @Override
    public boolean isAscended() {
        return this.getFaction() == 13;
    }

    @Override
    public int getFactionId() {
        int faction;
        this.unlockedPowerFIX();
        int powerBase = this.getUnlockedPower(0);
        int n = faction = powerBase == 8 ? 13 : powerBase;
        if (powerBase == 0 && this.getUnlockedPower(1) == 1 && this.noPowers()) {
            faction = 1;
        }
        if (powerBase == 0 && this.getUnlockedPower(7) != 0) {
            faction = 7;
        }
        if (powerBase == 2 && this.getUnlockedPower(3) != 0) {
            faction = 8;
        }
        if (powerBase == 3) {
            int hollow;
            int n2 = hollow = this.getUnlockedPower(3) - 3 >= 0 ? 9 + this.getUnlockedPower(3) - 3 : powerBase;
            if (this.getUnlockedPower(2) != 0) {
                hollow = 12;
            }
            faction = hollow;
        }
        return faction;
    }

    @Override
    public int getFaction() {
        return this.faction;
    }

    @Override
    public void setFaction(int value) {
        this.faction = value;
    }

    @Override
    public void updateFaction() {
        this.faction = this.getFactionId();
    }

    @Override
    public boolean setAsFaction(int id, int level, int override) {
        switch (id) {
            case 0: {
                this.setAsHuman(override);
                return true;
            }
            case 1: {
                this.setAsWhole(1, override);
                return true;
            }
            case 2: {
                this.setAsShinigami(level, override);
                return true;
            }
            case 3: {
                this.setAsHollow(level, override);
                return true;
            }
            case 4: {
                this.setAsQuincy(level, override);
                return true;
            }
            case 5: {
                this.setAsBount(override);
                return true;
            }
            case 6: {
                this.setAsSinner(override);
                return true;
            }
            case 7: {
                this.setAsFullbringer(level, override);
                return true;
            }
            case 8: {
                this.setAsVisored(level, override);
                return true;
            }
            case 9: {
                this.setAsMenos(override);
                return true;
            }
            case 10: {
                this.setAsAdjuchas(override);
                return true;
            }
            case 11: {
                this.setAsVastoLorde(override);
                return true;
            }
            case 12: {
                this.setAsArrancar(level + 1, override);
                return true;
            }
            case 13: {
                this.setAsAscended(override);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setAsHuman(int override) {
        if (override == 0) {
            for (int i = 0; i < this.UnlockedPower.length; ++i) {
                this.setUnlockedPower(i, 0);
            }
        }
    }

    @Override
    public void setAsWhole(int living, int override) {
        this.setAsHuman(override);
        this.setUnlockedPower(0, 1);
        if (living == 1) {
            this.setUnlockedPower(1, 1);
        }
        this.setChainLifeStart();
    }

    @Override
    public void setAsAlive(int override) {
        if (this.getUnlockedPower(0) != 7 && this.getUnlockedPower(0) != 3 && this.getUnlockedPower(0) != 6) {
            this.setUnlockedPower(1, 0);
        }
    }

    @Override
    public void setAsHollow(int level, int override) {
        this.setAsWhole(1, override);
        this.setUnlockedPower(0, 3);
        level = level <= 0 ? 1 : (level > 6 ? 6 : level);
        this.setUnlockedPower(3, level);
    }

    @Override
    public void setAsMenos(int override) {
        this.setAsHollow(3, override);
    }

    @Override
    public void setAsAdjuchas(int override) {
        this.setAsHollow(4, override);
    }

    @Override
    public void setAsVastoLorde(int override) {
        this.setAsHollow(5, override);
    }

    @Override
    public void setAsArrancar(int level, int override) {
        this.setAsHollow(6, override);
        level = level + 1 > 3 ? 3 : level + 1;
        this.setUnlockedPower(2, level);
    }

    @Override
    public void setAsShinigami(int level, int override) {
        this.setAsWhole(this.getUnlockedPower(1), override);
        this.setUnlockedPower(0, 2);
        level = level <= 0 ? 1 : (level > 5 ? 5 : level);
        this.setUnlockedPower(2, level);
    }

    @Override
    public void setAsShiniCaptain(int override) {
        this.setAsShinigami(4, override);
    }

    @Override
    public void setAsVisored(int mask, int override) {
        int level = this.getUnlockedPower(2);
        level = level < 1 ? 1 : (level > 4 ? 4 : level);
        this.setAsShinigami(level, override);
        int n = mask < 1 ? 1 : (mask = mask > 5 ? 5 : mask);
        if (this.getUnlockedPower(3) <= mask) {
            this.setUnlockedPower(3, mask);
        }
        this.maskVisored();
    }

    @Override
    public void setAsMergedShini(int override) {
        this.setAsShinigami(5, override);
    }

    @Override
    public void setAsQuincy(int level, int override) {
        this.setAsHuman(override);
        this.setUnlockedPower(0, 4);
        this.setUnlockedPower(1, 0);
        level = level <= 0 ? 1 : (level > 5 ? 5 : level);
        this.setUnlockedPower(4, level);
    }

    @Override
    public void setAsQuincyLeztzStil(int override) {
        this.setAsQuincy(3, override);
    }

    @Override
    public void setAsQuincyVolstandigUser(int voltLvl, int override) {
        voltLvl = voltLvl >= 2 ? 1 : (voltLvl >= 0 ? voltLvl : 0);
        this.setAsQuincy(4 + voltLvl, override);
    }

    @Override
    public void setAsFullbringer(int level, int override) {
        this.setAsHuman(override);
        this.setUnlockedPower(0, 7);
        level = level < 1 ? 1 : (level > 3 ? 3 : level);
        this.setUnlockedPower(7, level);
    }

    @Override
    public void setAsBount(int override) {
        this.setAsHuman(override);
        this.setUnlockedPower(0, 5);
        this.setUnlockedPower(5, 1);
    }

    @Override
    public void setAsSinner(int override) {
        this.setUnlockedPower(0, 6);
        this.setUnlockedPower(1, 1);
        this.setUnlockedPower(6, 1);
    }

    @Override
    public void setAsAscended(int override) {
        this.setUnlockedPower(0, 8);
        this.setUnlockedPower(1, 1);
        for (int i = 2; i < this.UnlockedPower.length; ++i) {
            this.setUnlockedPower(i, 5);
        }
    }

    public void maskVisored() {
        if (this.maskData[1] == 0) {
            int value = this.rand.nextInt(20);
            while (value == 8 || value == 9 || value == 10 || value == 13) {
                value = this.rand.nextInt(19);
            }
            this.maskData[1] = value;
            this.setMaskTimerMax();
            this.recoverMaskEnergy(this.getMaskTimerMax());
        }
    }

    @Override
    public void setBleachStat(int index, int value) {
        this.bleachStats[index] = value;
        this.powerUpdate();
    }

    @Override
    public int getBleachStat(int index) {
        return this.bleachStats[index];
    }

    @Override
    public void setBleachStatExp(int index, int value) {
        this.bleachExp[index] = value;
    }

    @Override
    public int getBleachStatExp(int index) {
        return this.bleachExp[index];
    }

    @Override
    public double getBaseDamage() {
        int reiryoku = this.getMaxSpirit();
        float strFactor = this.bleachStats[0] / 10 + 10 * this.bleachStats[0] / BleachConfiguration.statMax[0];
        float endFactor = this.bleachStats[2] > 50 ? (float)(this.bleachStats[2] <= 170 ? this.bleachStats[2] / 10 - 2 : 15) : 1.0f;
        float reiry = reiryoku / 100;
        float reiryDiv = reiry / 5.0f;
        int damMax = BleachConfiguration.spiritDamageBoost;
        int damageIncrease = (int)(strFactor + endFactor / 10.0f + reiryDiv);
        return damageIncrease > damMax ? (double)damMax : (double)damageIncrease;
    }

    @Override
    public float getHollowBoost(int typeNeeded) {
        float boost = 0.0f;
        for (int i = 0; i < 5; ++i) {
            boost += this.getHollowPartBoost(i, typeNeeded);
        }
        return boost;
    }

    @Override
    public float getHollowPartBoost(int partType, int typeNeeded) {
        float value = 0.0f;
        float amplifier = 0.0f;
        if (this.getUnlockedPower(0) == 3) {
            amplifier = 1.0f;
            switch (this.getUnlockedPower(3)) {
                case 3: {
                    amplifier = 0.0f;
                }
                case 4: {
                    amplifier = 1.2f;
                }
                case 5: {
                    amplifier = 1.6f;
                }
                case 6: {
                    amplifier = 0.0f;
                }
            }
            if (this.getUnlockedPower(3) >= 6) {
                amplifier = 0.0f;
            }
            if (partType > 4 || partType < 0) {
                return 0.0f;
            }
            int check = this.getHollowPart(partType);
            if (partType == 0) {
                // empty if block
            }
            if (partType == 1) {
                // empty if block
            }
            if (partType == 2) {
                switch (check) {
                    case 1: {
                        float f = value = typeNeeded == 1 ? 2.0f : 0.0f;
                    }
                }
            }
            if (partType == 3) {
                switch (check) {
                    case 1: {
                        value = typeNeeded == 2 ? 0.2f : 0.0f;
                        break;
                    }
                    case 3: {
                        float f = value = typeNeeded == 0 ? 0.03f : 0.0f;
                    }
                }
            }
            if (partType != 4 || this.isTailUsable()) {
                // empty if block
            }
        }
        return value * amplifier;
    }

    @Override
    public void getExpGained(int index) {
    }

    @Override
    public void getWeaponDamage() {
    }

    @Override
    public void getRangedDamage() {
    }

    @Override
    public void getSpiritDefense() {
    }

    @Override
    public double getSpeed() {
        float strFactor;
        float f = (float)this.getBleachStat(0) > 50.0f ? ((float)this.getBleachStat(0) <= 170.0f ? (float)this.getBleachStat(0) / 10.0f - 2.0f : 15.0f) : (strFactor = 1.0f);
        float reishiFactor = (float)this.getBleachStat(8) < 30.0f ? 1.0f : ((float)this.getBleachStat(8) <= 200.0f ? (float)this.getBleachStat(8) / 10.0f : 20.0f);
        float reiryokuFactor = (float)this.getMaxSpirit() * 0.1f * ((float)this.getBleachStat(8) / (float)BleachConfiguration.statMax[8]);
        float agiFactor = (float)this.getBleachStat(1) / 10.0f * ((float)this.getBleachStat(1) / (float)BleachConfiguration.statMax[1] + 1.0f) * 2.0f;
        double combo = (double)(strFactor + reishiFactor) * 5.0E-4;
        double boost = (double)(agiFactor + reiryokuFactor) * 0.002;
        double spdMax = (double)BleachConfiguration.spiritSpeedBoost * 0.005;
        return (boost > spdMax ? spdMax : boost) + combo;
    }

    @Override
    public int getSpellCost() {
        int amount = 0;
        return amount;
    }

    @Override
    public int getSpiritRecoveryAmount() {
        return 5;
    }

    @Override
    public int getSpiritRecoverySpeed(EntityPlayer player) {
        return 100;
    }

    @Override
    public void getSPUseCost(int abilityID) {
    }

    @Override
    public int getFlashStepDistance() {
        return 1;
    }

    @Override
    public void chargeEnergy() {
    }

    @Override
    public void getSpiritWeaponTime() {
    }

    @Override
    public float getBonusHealth() {
        float healthMax;
        float endurFactor;
        int reiryokuCount = this.getMaxSpirit() / 250;
        float bonus = Math.round((float)reiryokuCount * ((endurFactor = (float)this.bleachStats[2] / (float)BleachConfiguration.statMax[2]) + 1.0f));
        return bonus > (healthMax = (float)BleachConfiguration.healthBonus) ? healthMax : bonus;
    }

    @Override
    public void addStat(int index, int amount) {
        int n = index;
        this.bleachStats[n] = this.bleachStats[n] + amount;
        if (this.bleachStats[index] > BleachConfiguration.statMax[index]) {
            this.bleachStats[index] = BleachConfiguration.statMax[index];
        }
        this.upgradeCount += amount;
        this.checkForUpgrade();
    }

    @Override
    public void checkForUpgrade() {
        if (this.upgradeCount > 30) {
            boolean arrancar;
            boolean shini = this.isShinigamiFac() && this.getBleachStat(4) > 50 && this.getBleachStat(7) > 20;
            boolean quincy = this.isQuincy() && this.getBleachStat(5) > 40 && this.getBleachStat(8) > 40;
            boolean hollow = this.isHollow() && this.getBleachStat(2) > 40 && this.getBleachStat(7) > 20;
            boolean bl = arrancar = this.isArrancar() && this.getBleachStat(4) > 40 && this.getBleachStat(8) > 30;
            if (shini || quincy || hollow || arrancar) {
                int current = this.getAbilityLevel(2);
                this.setAbilityUnlock(2, current + 1);
                this.upgradeCount = 0;
            }
        }
    }

    @Override
    public void addStatExp(int index, int amount) {
        amount *= this.debugEXPmultiply;
        int n = index;
        this.bleachExp[n] = this.bleachExp[n] + (amount *= BleachConfiguration.statXPRate);
        if (this.bleachExp[index] < 0) {
            this.bleachExp[index] = 0;
        }
        if (this.bleachExp[index] > 20 + this.getBleachStat(index) * 40) {
            this.addStat(index, 1);
            this.bleachExp[index] = 0;
        }
    }

    @Override
    public int getReiryoku(int index) {
        return this.reiryoku[index];
    }

    @Override
    public void resetReiryoku() {
        this.reiryoku[0] = 5;
        this.reiryokuCreative[0] = 0;
        for (int i = 1; i < 4; ++i) {
            this.reiryoku[i] = 0;
            this.reiryokuCreative[i] = 0;
        }
        this.powerUpdate();
    }

    @Override
    public void setReiryoku(int index, int amount) {
        this.reiryoku[index] = amount;
        this.reiryokuCreative[index] = 1;
        this.powerUpdate();
    }

    @Override
    public void reduceReiryoku(int index, int amount) {
        int min;
        int n = index;
        this.reiryoku[n] = this.reiryoku[n] - amount;
        int n2 = min = index == 0 ? 5 : 0;
        if (this.reiryoku[index] < min) {
            this.reiryoku[index] = min;
        }
    }

    @Override
    public void addReiryoku(int index, int amount) {
        if (this.getFaction() == -1) {
            this.updateFaction();
        }
        if (amount < 0) {
            this.reduceReiryoku(index, amount);
        } else {
            int n = index;
            this.reiryoku[n] = this.reiryoku[n] + amount;
            int conMax = BleachConfiguration.reiryokuMax;
            int conMaxBypass = BleachConfiguration.reiryokuMaxBypass;
            if (conMax >= 0) {
                int max = this.getMaxWFacReiryoku(index);
                if (conMax != 0 && !BleachConfiguration.factionCapWithMax) {
                    int n2 = max = conMax > 100 ? conMax : 100;
                    if (index != 0) {
                        max /= 4;
                    }
                }
                if (this.reiryoku[index] > max) {
                    if (this.reiryokuCreative[index] == 0 || conMaxBypass == 0) {
                        this.reiryoku[index] = max;
                    } else if (conMaxBypass == 1) {
                        int n3 = index;
                        this.reiryoku[n3] = this.reiryoku[n3] - amount;
                    }
                }
            } else if (index != 0 && this.reiryoku[index] > this.reiryoku[0] / 4) {
                if (this.reiryokuCreative[index] == 0 || conMaxBypass == 0) {
                    this.reiryoku[index] = this.reiryoku[0] / 4;
                } else if (conMaxBypass == 1) {
                    int n4 = index;
                    this.reiryoku[n4] = this.reiryoku[n4] - amount;
                }
            }
        }
        this.powerUpdate();
    }

    @Override
    public int totalBaseReiryoku() {
        int sum = 0;
        for (int i = 0; i < 4; ++i) {
            sum += this.reiryoku[i];
        }
        return sum;
    }

    @Override
    public int getMaxReiryoku(int index) {
        int base = 250;
        if (index == 0) {
            base = 100;
            switch (this.getFactionId()) {
                case 1: {
                    base = 100;
                    break;
                }
                case 2: {
                    base = this.UnlockedPower[2] == 1 ? 300 : (this.UnlockedPower[2] == 2 ? 550 : (this.UnlockedPower[2] == 3 ? 750 : (this.UnlockedPower[2] == 4 ? 1000 : (this.UnlockedPower[2] == 5 ? 1500 : base))));
                    break;
                }
                case 3: {
                    base = this.UnlockedPower[3] == 1 ? 400 : (this.UnlockedPower[3] == 2 ? 500 : 250);
                    break;
                }
                case 4: {
                    base = this.UnlockedPower[4] == 1 ? 150 : (this.UnlockedPower[4] == 2 ? 200 : (this.UnlockedPower[4] == 3 ? 300 : 250));
                    break;
                }
                case 5: {
                    base = 600;
                    break;
                }
                case 6: {
                    base = 900;
                    break;
                }
                case 7: {
                    base = this.UnlockedPower[7] == 1 ? 450 : 650;
                    break;
                }
                case 8: {
                    base = this.UnlockedPower[2] == 2 ? 550 : (this.UnlockedPower[2] == 3 ? 750 : (this.UnlockedPower[2] == 4 ? 1000 : 250));
                    break;
                }
                case 9: {
                    base = 600;
                    break;
                }
                case 10: {
                    base = 850;
                    break;
                }
                case 11: {
                    base = 1150;
                    break;
                }
                case 12: {
                    base = this.UnlockedPower[2] == 2 ? 1200 : 900;
                    break;
                }
                case 13: {
                    base = 2000;
                }
            }
            base += this.abilities[2] * 100;
            base += this.UnlockedPower[7] * 80;
        }
        if (index == 1) {
            int shiniLvl = this.UnlockedPower[2];
            base += shiniLvl * 70;
        }
        if (index == 2) {
            int quincyLvl = this.UnlockedPower[4];
            base += quincyLvl * 160;
        }
        if (index == 3) {
            int hollowLvl = this.UnlockedPower[3];
            base += hollowLvl * 90;
        }
        return base += this.UnlockedPower[7] * 20;
    }

    @Override
    public int getMaxWFacReiryoku(int index) {
        return this.getMaxReiryoku(index) * BleachConfiguration.factionCapScale;
    }

    @Override
    public void addBaseReiryoku(int amount) {
        this.addReiryoku(0, amount);
    }

    @Override
    public void addShiniReiryoku(int amount) {
        this.addReiryoku(1, amount);
    }

    @Override
    public void addQuincyReiryoku(int amount) {
        this.addReiryoku(2, amount);
    }

    @Override
    public void addHollowReiryoku(int amount) {
        this.addReiryoku(3, amount);
    }

    @Override
    public int setUsableMaxReiryoku() {
        int base = this.reiryoku[0];
        if (this.getUnlockedPower(0) == 2) {
            if (this.activePower[0] == 1) {
                base += this.reiryoku[1];
            }
            if (this.getUnlockedPower(2) >= 5) {
                return base *= 2;
            }
            if (this.getUnlockedPower(3) != 0 && this.activePower[2] == 1) {
                base += this.reiryoku[3];
            }
            if (this.getUnlockedPower(4) != 0 && this.activePower[0] != 0) {
                base += this.reiryoku[2] / 2;
            } else if (this.getUnlockedPower(4) >= 3 && this.activePower[0] == 0 && this.activePower[3] != 0) {
                base = (int)((double)base + (double)this.reiryoku[2] * 1.5);
            }
        }
        if (this.getUnlockedPower(0) == 3) {
            if (this.activePower[1] != 0) {
                base = (int)((double)base + (double)this.reiryoku[3] * 1.3);
            }
            if (this.activePower[1] == 2) {
                base = (int)((double)base * 1.5);
            }
        }
        if (this.getUnlockedPower(0) == 4) {
            base += this.reiryoku[2];
            if (this.activePower[3] != 0) {
                base *= 2;
                if (this.activePower[3] == 2) {
                    base = (int)((float)base * 1.25f);
                }
            }
        }
        if (this.getUnlockedPower(0) == 0 && this.activePower[4] != 0) {
            base += this.reiryoku[3] / 5;
            if (this.activePower[4] == 2) {
                base += this.reiryoku[3] / 2;
            }
        }
        return base;
    }

    @Override
    public void setChainLifeStart() {
        if (BleachConfiguration.disablePathing[2] == 0) {
            this.chainLife = this.getMaxSpirit() * 3000;
        }
    }

    @Override
    public void setChainLife(int par1) {
        this.chainLife = par1;
        if ((this.isAWhole() || this.isHuman() && this.isSpirit()) && this.chainLife <= 0 && this.chainLife != -1) {
            this.addBaseReiryoku(50);
            this.addHollowReiryoku(25);
            if (BleachConfiguration.removeHollowEvolution) {
                this.randomizeHollow(false);
            }
            if (BleachConfiguration.disablePathing[2] == 0) {
                this.setAsHollow(0, 1);
            } else {
                this.chainLife = -1;
            }
        }
    }

    @Override
    public void resetChainLife() {
        this.chainLife = -1;
    }

    @Override
    public int getChainLife() {
        if ((this.isAWhole() || this.isHuman() && this.isSpirit()) && this.chainLife <= 0 && this.chainLife != -1) {
            this.setChainLife(0);
            return 0;
        }
        return this.chainLife;
    }

    @Override
    public int getUpgradeCount() {
        return this.upgradeCount;
    }

    @Override
    public void setUpgradeCount(int value) {
        this.upgradeCount = value;
    }

    @Override
    public void setTimer(int index, int value) {
        this.bleachTimers[index] = value;
    }

    @Override
    public int getTimer(int index) {
        if (this.bleachTimers.length < 6) {
            this.bleachTimers = new int[6];
        }
        return this.bleachTimers[index];
    }

    @Override
    public int getRegenVsConsume() {
        return this.regenVsConsume;
    }

    @Override
    public void setRegenVsConsume(int value) {
        this.regenVsConsume = value < 0 ? 0 : value;
    }

    @Override
    public int[] getReiryokuArray() {
        return this.reiryoku;
    }

    @Override
    public int[] getReiryokuCreativeArray() {
        return this.reiryokuCreative;
    }

    @Override
    public int[] getFactionRepArray() {
        return this.factionRep;
    }

    @Override
    public int[] getSoulSocietySquadArray() {
        return this.soulsocietysquad;
    }

    @Override
    public int[] getUnlockedPowerArray() {
        return this.UnlockedPower;
    }

    @Override
    public int[] getElementPointsArray() {
        return this.elementPoints;
    }

    @Override
    public int[] getZanpakutoArray() {
        return this.Zanpakuto;
    }

    @Override
    public int[] getMaskDataArray() {
        return this.maskData;
    }

    @Override
    public int[] getHollowTypeArray() {
        return this.hollowType;
    }

    @Override
    public int[] getHollowPartArray() {
        return this.hollowParts;
    }

    @Override
    public int[] getBleachStatsArray() {
        return this.bleachStats;
    }

    @Override
    public int[] getBleachExpArray() {
        return this.bleachExp;
    }

    @Override
    public int[] getAbilitiesArray() {
        return this.abilities;
    }

    @Override
    public int[] getSpellLevelsArray() {
        return this.spellLevels;
    }

    @Override
    public int[] getTrackedDataArray() {
        return this.trackedData;
    }

    @Override
    public int[] getActivePowerArray() {
        return this.activePower;
    }

    @Override
    public int[] getActivePowerXPArray() {
        return this.activePowerXP;
    }

    @Override
    public int[] getBattleInfoArray() {
        return this.battleInfo;
    }

    @Override
    public int[] getHollowKillCountArray() {
        return this.HollowKillCount;
    }

    @Override
    public int[] getHollowDeathTypeArray() {
        return this.HollowDeathType;
    }

    @Override
    public int[] getTimerArray() {
        return this.bleachTimers;
    }

    @Override
    public void setReiryokuArray(int[] value) {
        this.reiryoku = value;
    }

    @Override
    public void setReiryokuCreativeArray(int[] value) {
        this.reiryokuCreative = value;
    }

    @Override
    public void setFactionRepArray(int[] value) {
        this.factionRep = value;
    }

    @Override
    public void setSoulSocietySquadArray(int[] value) {
        this.soulsocietysquad = value;
    }

    @Override
    public void setUnlockedPowerArray(int[] value) {
        this.UnlockedPower = value;
    }

    @Override
    public void setElementPointsArray(int[] value) {
        this.elementPoints = value;
    }

    @Override
    public void setZanpakutoArray(int[] value) {
        this.Zanpakuto = value;
    }

    @Override
    public void setMaskDataArray(int[] value) {
        this.maskData = value;
    }

    @Override
    public void setHollowTypeArray(int[] value) {
        this.hollowType = value;
    }

    @Override
    public void setHollowPartArray(int[] value) {
        this.hollowParts = value;
    }

    @Override
    public void setBleachStatsArray(int[] value) {
        this.bleachStats = value;
    }

    @Override
    public void setBleachExpArray(int[] value) {
        this.bleachExp = value;
    }

    @Override
    public void setAbilitiesArray(int[] value) {
        this.abilities = value;
    }

    @Override
    public void setSpellLevelsArray(int[] value) {
        this.spellLevels = value;
    }

    @Override
    public void setTrackedDataArray(int[] value) {
        this.trackedData = value;
    }

    @Override
    public void setActivePowerArray(int[] value) {
        this.activePower = value;
    }

    @Override
    public void setActivePowerXPArray(int[] value) {
        this.activePowerXP = value;
    }

    @Override
    public void setBattleInfoArray(int[] value) {
        this.battleInfo = value;
    }

    @Override
    public void setHollowKillCountArray(int[] value) {
        this.HollowKillCount = value;
    }

    @Override
    public void setHollowDeathTypeArray(int[] value) {
        this.HollowDeathType = value;
    }

    @Override
    public void setTimerArray(int[] value) {
        this.bleachTimers = value;
    }
}

