/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.items;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.entities.BleachEntityList;
import littlebreadloaf.bleach_kd.entities.EntityShinigami;
import littlebreadloaf.bleach_kd.entities.hollows.EntityGillianMenos;
import littlebreadloaf.bleach_kd.items.ItemBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBleachEggSpawner
extends ItemBase {
    public ItemBleachEggSpawner() {
        super("bleach_spawn_egg");
    }

    public String func_77653_i(ItemStack stack) {
        String s = ("" + I18n.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String s1 = BleachEntityList.getTranslationName(ItemBleachEggSpawner.getNamedIdFrom(stack));
        if (s1 != null) {
            s = s + " " + I18n.func_74838_a((String)("entity." + s1 + ".name"));
        }
        return s;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150474_ac && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
            mobspawnerbaselogic.func_190894_a(ItemBleachEggSpawner.getNamedIdFrom(itemstack));
            tileentity.func_70296_d();
            worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        Entity entity = ItemBleachEggSpawner.spawnCreature(worldIn, ItemBleachEggSpawner.getNamedIdFrom(itemstack), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                entity.func_96094_a(itemstack.func_82833_r());
            }
            ItemBleachEggSpawner.applyItemEntityDataToEntity(worldIn, player, itemstack, entity);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World p_190909_1_, BlockPos p_190909_2_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_190909_2_).func_72321_a(0.0, -1.0, 0.0);
        List list = p_190909_1_.func_184144_a((Entity)null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)p_190909_2_.func_177956_o();
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("EntityTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(nbttagcompound.func_74775_l("EntityTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                Entity entity = ItemBleachEggSpawner.spawnCreature(worldIn, ItemBleachEggSpawner.getNamedIdFrom(itemstack), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
                if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                    if (entity instanceof EntityShinigami) {
                        EntityShinigami shini = (EntityShinigami)entity;
                        String stackName = itemstack.func_82833_r();
                        if (stackName.toLowerCase().startsWith("captain")) {
                            shini.setAsCaptain();
                            if (stackName.equalsIgnoreCase("captain")) {
                                String name = shini.func_174793_f().func_70005_c_();
                                shini.func_96094_a(name + " Captain");
                            }
                        } else if (shini.func_184582_a(EntityEquipmentSlot.CHEST) != null && shini.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == BleachArmor.ShiniCaptain) {
                            shini.func_96094_a("Captain " + stackName);
                        } else if (stackName.equalsIgnoreCase("ashido")) {
                            shini.setAsSpecial();
                            shini.func_96094_a("Ashido");
                            shini.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(BleachArmor.AshidoArmour, 1));
                        }
                    } else if (entity instanceof EntityGillianMenos) {
                        EntityGillianMenos menos = (EntityGillianMenos)entity;
                        String stackName = itemstack.func_82833_r();
                        if (stackName.equalsIgnoreCase("grande")) {
                            menos.setMenosType(0);
                        }
                        if (stackName.equalsIgnoreCase("ichigo") && playerIn.func_184582_a(EntityEquipmentSlot.HEAD) != null && playerIn.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == BleachArmor.HollowIchigoHelmet && playerIn.field_71075_bZ.field_75098_d) {
                            menos.setMenosType(menos.textures.length - 1);
                        }
                    } else {
                        entity.func_96094_a(itemstack.func_82833_r());
                    }
                }
                ItemBleachEggSpawner.applyItemEntityDataToEntity(worldIn, playerIn, itemstack, entity);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @Nullable
    public static Entity spawnCreature(World worldIn, @Nullable ResourceLocation entityID, double x, double y, double z) {
        if (entityID != null && BleachEntityList.ENTITY_EGGS.containsKey(entityID)) {
            Entity entity = null;
            for (int i = 0; i < 1; ++i) {
                entity = BleachEntityList.createEntityByIDFromName(entityID, worldIn);
                if (!(entity instanceof EntityLiving)) continue;
                EntityLiving entityliving = (EntityLiving)entity;
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityliving.field_70759_as = entityliving.field_70177_z;
                entityliving.field_70761_aq = entityliving.field_70177_z;
                entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
                worldIn.func_72838_d(entity);
                entityliving.func_70642_aH();
            }
            return entity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColorFromItemStack(ItemStack itemStack, int layer) {
        BleachEntityList.EntityEggInfo eggInfo = BleachEntityList.ENTITY_EGGS.get(ItemBleachEggSpawner.getNamedIdFrom(itemStack));
        int color = 0xFFFFFF;
        if (eggInfo != null) {
            color = layer == 0 ? eggInfo.primaryColour : eggInfo.secondaryColour;
        }
        return color;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (BleachEntityList.EntityEggInfo entitylist$entityegginfo : BleachEntityList.ENTITY_EGGS.values()) {
                ItemStack itemstack = new ItemStack((Item)this, 1);
                ItemBleachEggSpawner.applyEntityIdToItemStack(itemstack, entitylist$entityegginfo.spawnedID);
                items.add((Object)itemstack);
            }
        }
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation entityId) {
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", entityId.toString());
        nbttagcompound.func_74782_a("EntityTag", (NBTBase)nbttagcompound1);
        stack.func_77982_d(nbttagcompound);
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        if (!nbttagcompound.func_150297_b("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("EntityTag");
        if (!nbttagcompound1.func_150297_b("id", 8)) {
            return null;
        }
        String s = nbttagcompound1.func_74779_i("id");
        ResourceLocation resourcelocation = new ResourceLocation(s);
        if (!s.contains(":")) {
            nbttagcompound1.func_74778_a("id", resourcelocation.toString());
        }
        return resourcelocation;
    }
}

