/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.items;

import java.util.List;
import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.events.BleachProvider;
import littlebreadloaf.bleach_kd.events.IBleachPlayerCap;
import littlebreadloaf.bleach_kd.items.ISpiritFood;
import littlebreadloaf.bleach_kd.items.ItemBase;
import littlebreadloaf.bleach_kd.world.BleachWorldGen;
import littlebreadloaf.bleach_kd.world.HuecoMundoTeleporter;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReiatsu
extends ItemBase
implements ISpiritFood {
    public final int itemUseDuration;
    public String reiatsuData = "reiatsuData";
    public String hollowActive = "hollowActive";

    public ItemReiatsu() {
        super("reiatsu");
        this.itemUseDuration = 32;
        this.func_185043_a(new ResourceLocation("hollow"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemReiatsu.this.getHollowActive(stack) > 0 ? 1.0f : 0.0f;
            }
        });
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 24;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.EAT;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag bool) {
        int i = this.getHollowActive(stack);
        if (i == 1) {
            list.add("Hollowed");
        } else if (i != 0 && i != 1) {
            list.add(i + " ??");
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            IBleachPlayerCap props = (IBleachPlayerCap)player.getCapability(BleachProvider.BLEACH_CAP, null);
            stack.func_190918_g(1);
            props.addStatExp(7, 5);
            if (this.getHollowActive(stack) != 1) {
                int spirit = props.isQuincy() ? 9 : (props.isHollowBASE() ? 11 : 7);
                props.replenishSpiritEnergy(spirit);
            } else if (this.getHollowActive(stack) == 1 && props.isHollowBASE()) {
                if (!BleachConfiguration.removeHollowEvolution) {
                    if (props.getHTex() == 0) {
                        props.randMaskSkin();
                    }
                    if (props.getHollowTypeTotal(false) > 50 && props.getHollowPart(5) == 0) {
                        if (props.getHollowType(5) > 200) {
                            props.setHollowPart(5, 1);
                        }
                        int check = 0;
                        for (int i = 0; i < 5; ++i) {
                            if (props.getHollowType(i) <= props.getHollowType(check)) continue;
                            check = i;
                        }
                        if (props.getHollowType(check) > 30) {
                            props.setHollowPart(check);
                            props.setHollowTypes(check, 0);
                        }
                    }
                }
                if (!BleachConfiguration.restrictHuecoMundo && !player.func_70093_af() && props.getAbilityLevel(4) >= 2 && props.getMaxSpirit() >= 75 && props.isEnergyMoreThan(25) && !BleachConfiguration.removeGargantaRequirements) {
                    props.consumeSpiritEnergy(25, player);
                    if (!player.field_70170_p.field_72995_K) {
                        if (player.field_71093_bK == BleachWorldGen.HuecoMundo_ID) {
                            player.changeDimension(0, (ITeleporter)HuecoMundoTeleporter.getTeleporterForDim(player.func_184102_h(), 0));
                        } else {
                            player.changeDimension(BleachWorldGen.HuecoMundo_ID, (ITeleporter)HuecoMundoTeleporter.getTeleporterForDim(player.func_184102_h(), BleachWorldGen.HuecoMundo_ID));
                        }
                    }
                }
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return stack;
    }

    public int getHollowActive(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return 0;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(this.reiatsuData);
        return nbttagcompound1 == null ? 0 : (nbttagcompound1.func_74764_b(this.hollowActive) ? nbttagcompound1.func_74762_e(this.hollowActive) : 0);
    }

    public void setHollowActive(ItemStack stack, int extra) {
        int currentMode;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(this.reiatsuData);
        if (!nbttagcompound.func_74764_b(this.reiatsuData)) {
            nbttagcompound.func_74782_a(this.reiatsuData, (NBTBase)nbttagcompound1);
        }
        if ((currentMode = nbttagcompound1.func_74762_e(this.hollowActive)) == 0) {
            nbttagcompound1.func_74768_a(this.hollowActive, 1 + extra);
        }
    }

    @Override
    public int getFood() {
        return 4;
    }

    @Override
    public float getSaturation() {
        return 0.5f;
    }
}

