/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.network;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import littlebreadloaf.bleach_kd.BleachMod;
import littlebreadloaf.bleach_kd.extras.ParticleEffects;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticleMessage
implements IMessage {
    private int id;
    private double posx;
    private double posy;
    private double posz;
    Random rand = new Random();

    public ParticleMessage() {
    }

    public ParticleMessage(int id, double x, double y, double z) {
        this.id = id;
        this.posx = x;
        this.posy = y;
        this.posz = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.posx = buf.readDouble();
        this.posy = buf.readDouble();
        this.posz = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.posx);
        buf.writeDouble(this.posy);
        buf.writeDouble(this.posz);
    }

    public static class Handler
    implements IMessageHandler<ParticleMessage, IMessage> {
        Random rand = new Random();

        public IMessage onMessage(ParticleMessage message, MessageContext ctx) {
            IBlockState block;
            EntityPlayer player = BleachMod.proxy.getPlayerFromMessage(ctx);
            if (message.id == 0) {
                ParticleEffects.spawnParticle("tensho", message.posx + this.rand.nextDouble(), message.posy + this.rand.nextDouble(), message.posz + this.rand.nextDouble(), 0.0, 0.0, 0.0);
            }
            if (message.id == 1) {
                ParticleEffects.spawnParticle("poison", message.posx + this.rand.nextDouble() - this.rand.nextDouble(), message.posy + this.rand.nextDouble() - this.rand.nextDouble(), message.posz + this.rand.nextDouble() - this.rand.nextDouble(), 0.0, 0.0, 0.0);
            }
            if (message.id != 2 || (block = player.field_70170_p.func_180495_p(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u - 2, (int)player.field_70161_v))).func_185904_a() != Material.field_151579_a) {
                // empty if block
            }
            if (message.id == 3) {
                ParticleEffects.spawnParticle("wind", message.posx, message.posy, message.posz, 0.0, 0.0, 0.0);
            }
            if (message.id == 4) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                player.field_70170_p.func_175688_a(EnumParticleTypes.HEART, message.posx + (double)(this.rand.nextFloat() * 2.0f), message.posy + 0.5 + (double)this.rand.nextFloat(), message.posz + (double)(this.rand.nextFloat() * 2.0f), d0, d1, d2, new int[0]);
            }
            if (message.id == 5) {
                ParticleEffects.spawnParticle("spirit", message.posx + this.rand.nextDouble(), message.posy + this.rand.nextDouble(), message.posz + this.rand.nextDouble(), 0.0, 0.0, 0.0);
                ParticleEffects.spawnParticle("spirit", message.posx + this.rand.nextDouble(), message.posy + this.rand.nextDouble(), message.posz + this.rand.nextDouble(), 0.0, 0.0, 0.0);
                ParticleEffects.spawnParticle("spirit", message.posx + this.rand.nextDouble(), message.posy + this.rand.nextDouble(), message.posz + this.rand.nextDouble(), 0.0, 0.0, 0.0);
            }
            return null;
        }
    }
}

