/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.proxies;

import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.BleachMaskMappings;
import littlebreadloaf.bleach_kd.entities.EntityCero;
import littlebreadloaf.bleach_kd.entities.EntityCeroCharge;
import littlebreadloaf.bleach_kd.entities.EntityEnergyArrow;
import littlebreadloaf.bleach_kd.entities.EntityGetsuga;
import littlebreadloaf.bleach_kd.entities.EntitySeeleArrow;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.BleachTickHandlerClient;
import littlebreadloaf.bleach_kd.extras.BleachKeyHandler;
import littlebreadloaf.bleach_kd.gui.GuiSoulBar;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.ItemBleachEggSpawner;
import littlebreadloaf.bleach_kd.items.ItemStatPoint;
import littlebreadloaf.bleach_kd.player.LayerSoulChain;
import littlebreadloaf.bleach_kd.player.LayerVisoredMask;
import littlebreadloaf.bleach_kd.proxies.CommonProxy;
import littlebreadloaf.bleach_kd.render.RenderSpike;
import littlebreadloaf.bleach_kd.render.entity.BleachEntityRenders;
import littlebreadloaf.bleach_kd.render.entity.RenderCero;
import littlebreadloaf.bleach_kd.render.entity.RenderCeroCharge;
import littlebreadloaf.bleach_kd.render.entity.RenderEnergyArrow;
import littlebreadloaf.bleach_kd.render.entity.RenderGetsuga;
import littlebreadloaf.bleach_kd.render.entity.RenderSeeleArrow;
import littlebreadloaf.bleach_kd.render.models.armor.ModelAshidoArmour;
import littlebreadloaf.bleach_kd.render.models.armor.ModelCaptainJacket;
import littlebreadloaf.bleach_kd.render.models.armor.ModelGolemMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelHoneyBadgerMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelIchigoVastoLorde;
import littlebreadloaf.bleach_kd.render.models.armor.ModelLizardMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelMantisMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelMaskIchigo;
import littlebreadloaf.bleach_kd.render.models.armor.ModelPterodactylMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelQuincyLeztzStil;
import littlebreadloaf.bleach_kd.render.models.armor.ModelShihakusho;
import littlebreadloaf.bleach_kd.render.models.armor.ModelSkirt;
import littlebreadloaf.bleach_kd.render.models.armor.ModelSnakeMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelSoulChain;
import littlebreadloaf.bleach_kd.render.models.armor.ModelStalkerMask;
import littlebreadloaf.bleach_kd.render.models.armor.ModelWolfMask;
import littlebreadloaf.bleach_kd.tiles.TileSpike;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    private static final ModelSoulChain chain = new ModelSoulChain(1.0f);
    private static final ModelBiped robes = new ModelBiped(0.2f);
    private static final ModelCaptainJacket captain = new ModelCaptainJacket(0.2f);
    private static final ModelShihakusho shinigami = new ModelShihakusho(0.2f);
    private static final ModelQuincyLeztzStil leztzStil = new ModelQuincyLeztzStil(0.1f);
    private static final ModelAshidoArmour ashido = new ModelAshidoArmour(1.0f);
    private static final ModelGolemMask golem = new ModelGolemMask(1.0f);
    private static final ModelSnakeMask snake = new ModelSnakeMask(1.0f);
    private static final ModelWolfMask wolf = new ModelWolfMask(1.0f);
    private static final ModelStalkerMask stalker = new ModelStalkerMask(0.0f);
    private static final ModelPterodactylMask pterodactyl = new ModelPterodactylMask(1.0f);
    private static final ModelMantisMask mantis = new ModelMantisMask(1.0f);
    private static final ModelLizardMask lizard = new ModelLizardMask(1.0f);
    private static final ModelHoneyBadgerMask honeybadger = new ModelHoneyBadgerMask(1.0f);
    private static final ModelSkirt skirt = new ModelSkirt(1.0f);
    private static final ModelMaskIchigo ichigoMask = new ModelMaskIchigo(1.1f);
    private static final ModelIchigoVastoLorde ichigoVasto = new ModelIchigoVastoLorde(0.2f);
    private static final ModelMaskIchigo ichigoMaskBasic = new ModelMaskIchigo(1.1f);
    private static final ModelMaskIchigo ichigoVastoBasic = new ModelMaskIchigo(1.1f);
    private static final ModelAshidoArmour ashidoMask = new ModelAshidoArmour(1.0f);

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), id));
    }

    @Override
    public void loadConfigClient() {
        BleachConfiguration.clientPreInit();
    }

    @Override
    public void initRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityEnergyArrow.class, (IRenderFactory)RenderEnergyArrow.RenderEnergyArrowFactory.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntitySeeleArrow.class, (IRenderFactory)RenderSeeleArrow.RenderSeeleArrowFactory.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityGetsuga.class, (IRenderFactory)RenderGetsuga.RenderGetsugaFactory.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityCeroCharge.class, (IRenderFactory)RenderCeroCharge.RenderCeroChargeFactory.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityCero.class, (IRenderFactory)RenderCero.RenderCeroFactory.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileSpike.class, (TileEntitySpecialRenderer)new RenderSpike());
        BleachEntityRenders.renderEntities();
        MinecraftForge.EVENT_BUS.register((Object)new BleachSounds());
    }

    @Override
    public void initProxy() {
        RenderLivingBase rendererDefault = (RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default");
        rendererDefault.func_177094_a(new LayerVisoredMask((RenderPlayer)rendererDefault));
        rendererDefault.func_177094_a(new LayerSoulChain((RenderPlayer)rendererDefault));
        RenderLivingBase rendererSlim = (RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim");
        rendererSlim.func_177094_a(new LayerVisoredMask((RenderPlayer)rendererSlim));
        rendererSlim.func_177094_a(new LayerSoulChain((RenderPlayer)rendererSlim));
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        BleachMaskMappings.createMaskMappings();
    }

    @Override
    public void initTickHandlers() {
        super.initTickHandlers();
        this.tickHandlerClient = new BleachTickHandlerClient();
        MinecraftForge.EVENT_BUS.register((Object)this.tickHandlerClient);
    }

    @Override
    public void registerItemColours() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return ItemStatPoint.getColorFromItemStack(stack, tintIndex);
            }
        }, new Item[]{BleachItems.statPoints});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return ItemBleachEggSpawner.getColorFromItemStack(stack, tintIndex);
            }
        }, new Item[]{BleachItems.bleachSpawnEggs});
    }

    @Override
    public int addArmor(String string) {
        return 0;
    }

    @Override
    public void loadGUI() {
        MinecraftForge.EVENT_BUS.register((Object)new GuiSoulBar(Minecraft.func_71410_x()));
    }

    @Override
    public void loadKeys() {
        MinecraftForge.EVENT_BUS.register((Object)new BleachKeyHandler());
    }

    public static ModelBiped getArmorModel(int id) {
        switch (id) {
            case 0: {
                return robes;
            }
            case 1: {
                return golem;
            }
            case 2: {
                return snake;
            }
            case 3: {
                return wolf;
            }
            case 4: {
                return stalker;
            }
            case 5: {
                return skirt;
            }
            case 6: {
                return pterodactyl;
            }
            case 7: {
                return lizard;
            }
            case 8: {
                return mantis;
            }
            case 9: {
                return honeybadger;
            }
            case 10: {
                return ichigoMask;
            }
            case 11: {
                return captain;
            }
            case 12: {
                return leztzStil;
            }
            case 13: {
                return ashido;
            }
            case 14: {
                return shinigami;
            }
            case 15: {
                return ichigoVasto;
            }
            case 16: {
                return ichigoMaskBasic;
            }
            case 17: {
                return ichigoVastoBasic;
            }
            case 18: {
                return ashidoMask;
            }
            case 21: {
                return chain;
            }
        }
        return chain;
    }

    @Override
    public EntityPlayer getPlayerFromMessage(MessageContext ctx) {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

