/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.render.entity;

import littlebreadloaf.bleach_kd.entities.IBleachEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderGeneralSpirit
extends RenderLiving {
    private float scaleRender = 1.0f;
    public static ResourceLocation texture = new ResourceLocation("bleach_kd", "textures/mobs/default.png");

    public RenderGeneralSpirit(RenderManager manager, ModelBase model, float shadow, float scale, boolean bipedFlag) {
        super(manager, model, shadow);
        this.scaleRender = scale;
        if (bipedFlag) {
            ModelBiped biped = null;
            if (model instanceof ModelBiped) {
                biped = (ModelBiped)this.func_177087_b();
            }
            this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
            if (biped != null) {
                this.func_177094_a((LayerRenderer)new LayerCustomHead(biped.field_78116_c));
            }
        }
    }

    protected void preRenderScale(EntityLivingBase entity, float par2) {
        GL11.glScalef((float)this.scaleRender, (float)this.scaleRender, (float)this.scaleRender);
    }

    protected void func_77041_b(EntityLivingBase entityliving, float f) {
        this.preRenderScale(entityliving, f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        IBleachEntity entityJojo = (IBleachEntity)entity;
        ResourceLocation temp = entityJojo.getEntityTexture();
        if (temp != null) {
            return temp;
        }
        return texture;
    }

    public static RenderGeneralSpiritFactory createBipedRender() {
        return RenderGeneralSpirit.createRender((ModelBase)new ModelBiped(), 0.3f, true);
    }

    public static RenderGeneralSpiritFactory createZombieRender() {
        return RenderGeneralSpirit.createRender((ModelBase)new ModelZombie(), 0.3f, true);
    }

    public static RenderGeneralSpiritFactory createRender(ModelBase modelIn, float shadowIn, boolean bipedIn) {
        return new RenderGeneralSpiritFactory(modelIn, shadowIn, bipedIn);
    }

    public static class RenderGeneralSpiritFactory
    implements IRenderFactory<Entity> {
        private ModelBase modelBase = null;
        private float shadowBase = 0.0f;
        private float scaleBase = 1.0f;
        private boolean bipedFlag = false;

        public RenderGeneralSpiritFactory(ModelBase modelIn, float shadowIn, boolean bipedIn) {
            this.modelBase = modelIn;
            this.shadowBase = shadowIn;
            this.bipedFlag = bipedIn;
        }

        public RenderGeneralSpiritFactory setScale(float scaleIn) {
            this.scaleBase = scaleIn;
            return this;
        }

        public Render<? super Entity> createRenderFor(RenderManager manager) {
            return new RenderGeneralSpirit(manager, this.modelBase, this.shadowBase, this.scaleBase, this.bipedFlag);
        }
    }
}

