/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.world;

import javax.annotation.Nullable;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.world.BleachWorldGenerator;
import littlebreadloaf.bleach_kd.world.HuecoMundoWorldProvider;
import littlebreadloaf.bleach_kd.world.HuecoMundoWorldType;
import littlebreadloaf.bleach_kd.world.SoulSocietyWorldProvider;
import littlebreadloaf.bleach_kd.world.SoulSocietyWorldType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BleachWorldGen {
    public static DimensionType HuecoMundo_DimType;
    public static final String HuecoMundo_Name = "hueco_mundo";
    public static final int HuecoMundo_ID;
    public static final WorldType HuecoMundo_WorldType;
    public static DimensionType SoulSociety_DimType;
    public static final String SoulSociety_Name = "soul_society";
    public static final int SoulSociety_ID;
    public static final WorldType SoulSociety_WorldType;

    public static final void registerDimensions() {
        HuecoMundo_DimType = DimensionType.register((String)HuecoMundo_Name, (String)"_bleach_dimension", (int)HuecoMundo_ID, HuecoMundoWorldProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)HuecoMundo_ID, (DimensionType)HuecoMundo_DimType);
        SoulSociety_DimType = DimensionType.register((String)SoulSociety_Name, (String)"_bleach_dimension", (int)SoulSociety_ID, SoulSocietyWorldProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)SoulSociety_ID, (DimensionType)SoulSociety_DimType);
    }

    @Nullable
    private static Integer findFreeDimensionID(int testFor) {
        if (!DimensionManager.isDimensionRegistered((int)testFor)) {
            return testFor;
        }
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            if (DimensionManager.isDimensionRegistered((int)i)) continue;
            return i;
        }
        return null;
    }

    public static void registerWorldGenerators() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BleachWorldGenerator(), (int)0);
    }

    static {
        HuecoMundo_ID = BleachWorldGen.findFreeDimensionID(BleachConfiguration.worldHuecoMundoID);
        HuecoMundo_WorldType = new HuecoMundoWorldType();
        SoulSociety_ID = BleachWorldGen.findFreeDimensionID(BleachConfiguration.worldSoulSocietyID);
        SoulSociety_WorldType = new SoulSocietyWorldType();
    }
}

