/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.world.gen;

import java.util.Random;
import littlebreadloaf.bleach_kd.BleachConfiguration;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.world.biomes.BleachBiomes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BleachGenHuecoStone
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (world.func_180494_b(pos) != BleachBiomes.HuecoMundoBase) {
            return false;
        }
        int i = pos.func_177958_n();
        int k = pos.func_177952_p();
        int topBlock = world.func_175672_r(pos).func_177956_o();
        Block blockTop = world.func_180495_p(world.func_175672_r(pos)).func_177230_c();
        if (topBlock < 58) {
            return false;
        }
        if (blockTop != BleachBlocks.whitesand) {
            return false;
        }
        int stoneHeight = rand.nextInt(7);
        int radiusMax = rand.nextInt(2) + 2;
        float radiusMin = 0.2f;
        for (int y = 0; y < stoneHeight; ++y) {
            for (int x = -radiusMax; x <= radiusMax; ++x) {
                for (int z = -radiusMax; z <= radiusMax; ++z) {
                    float lerp = 1.0f - (float)y / (float)topBlock;
                    float radius = (int)this.lerp(radiusMin, radiusMax, lerp);
                    if (y > 3 && (float)y - radius > 2.0f) {
                        radius -= 1.0f;
                    }
                    if (!(Math.sqrt(z * z + x * x) <= (double)radius)) continue;
                    world.func_175656_a(new BlockPos(x + i, y + topBlock, z + k), Blocks.field_150348_b.func_176223_P());
                }
            }
        }
        if (BleachConfiguration.generateHuecoStone) {
            world.func_175656_a(new BlockPos(i, topBlock, k), BleachBlocks.huecoStone.func_176223_P());
        }
        return true;
    }

    float lerp(float v0, float v1, float t) {
        return v0 + (v1 - v0) * t;
    }
}

