/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps;

import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.footsteps.AcousticResolver;
import org.orecruncher.dsurround.client.footsteps.Association;
import org.orecruncher.dsurround.client.footsteps.ConfigOptions;
import org.orecruncher.dsurround.client.footsteps.FootStrikeLocation;
import org.orecruncher.dsurround.client.footsteps.Footprint;
import org.orecruncher.dsurround.client.footsteps.SoundPlayer;
import org.orecruncher.dsurround.client.footsteps.accents.FootstepAccents;
import org.orecruncher.dsurround.client.fx.ParticleCollections;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.acoustics.AcousticRegistry;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.footstep.BlockMap;
import org.orecruncher.dsurround.registry.footstep.FootprintStyle;
import org.orecruncher.dsurround.registry.footstep.Substrate;
import org.orecruncher.dsurround.registry.footstep.Variator;
import org.orecruncher.dsurround.registry.sound.SoundRegistry;
import org.orecruncher.lib.TimeUtils;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.compat.EntityLivingBaseUtil;
import org.orecruncher.lib.compat.EntityUtil;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class Generator {
    public static final double PROBE_DEPTH = 0.0625;
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final int BRUSH_INTERVAL = 100;
    protected static final Consumer<Footprint> GENERATE_PRINT = print -> {
        Vec3d loc = print.getStepLocation();
        World world = print.getEntity().func_130014_f_();
        ParticleCollections.addFootprint(print.getStyle(), world, loc, print.getRotation(), print.getScale(), print.isRightFoot());
    };
    protected final Variator VAR;
    protected final BlockMap blockMap;
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected boolean didJump;
    protected boolean isFlying;
    protected float fallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected boolean isRightFoot;
    protected boolean isOnLadder;
    protected boolean isInWater;
    protected boolean isSneaking;
    protected boolean isJumping;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    protected boolean stepThisFrame;
    protected BlockPos messyPos = BlockPos.field_177992_a;
    protected long brushesTime;
    protected double distanceWalkedOnStepModified;
    protected int pedometer;
    protected static final ObjectArray<IAcoustic> accents = new ObjectArray(4);
    protected final ObjectArray<Footprint> footprints = new ObjectArray(4);
    protected final SoundPlayer soundPlayer;

    public Generator(@Nonnull Variator var) {
        this.VAR = var;
        this.blockMap = RegistryManager.FOOTSTEPS.getBlockMap();
        this.soundPlayer = new SoundPlayer(this.VAR.VOLUME_SCALE);
    }

    public int getPedometer() {
        return this.pedometer;
    }

    public void generateFootsteps(@Nonnull EntityLivingBase entity) {
        if (entity.func_184218_aH() || entity.func_70608_bn()) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
            return;
        }
        this.didJump = false;
        this.stepThisFrame = false;
        this.isOnLadder = entity.func_70617_f_();
        this.isInWater = entity.func_70090_H();
        this.isSneaking = entity.func_70093_af();
        this.isJumping = EntityLivingBaseUtil.isJumping((EntityLivingBase)entity);
        this.simulateFootsteps(entity);
        this.simulateAirborne(entity);
        this.simulateBrushes(entity);
        this.soundPlayer.think();
        if (this.footprints.size() > 0) {
            this.footprints.forEach(GENERATE_PRINT);
            this.footprints.clear();
        }
        if (this.stepThisFrame) {
            ++this.pedometer;
        }
        if (this.didJump && ModOptions.sound.enableJumpSound && this.VAR.PLAY_JUMP && !this.isSneaking) {
            this.soundPlayer.playAcoustic(entity.func_174791_d(), RegistryManager.FOOTSTEPS.JUMP, EventType.JUMP, null);
        }
        if (SoundEngine.getVolume(SoundRegistry.FOOTSTEPS) > 0.0f) {
            EntityUtil.setNextStepDistance((Entity)entity, (int)Integer.MAX_VALUE);
        } else {
            int dist = EntityUtil.getNextStepDistance((Entity)entity);
            if (dist == Integer.MAX_VALUE) {
                EntityUtil.setNextStepDistance((Entity)entity, (int)0);
            }
        }
    }

    protected boolean stoppedImmobile(float reference) {
        long current = TimeUtils.currentTimeMillis();
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = current;
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return current - this.timeImmobile > (long)this.VAR.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void updateWalkedOnStep(@Nonnull EntityLivingBase entity) {
        double dX = entity.field_70165_t - entity.field_70169_q;
        double dY = entity.field_70163_u - entity.field_70167_r;
        double dZ = entity.field_70161_v - entity.field_70166_s;
        this.distanceWalkedOnStepModified += Math.sqrt(dX * dX + dY * dY + dZ * dZ) * (double)0.6f;
    }

    protected void simulateFootsteps(@Nonnull EntityLivingBase entity) {
        double movZ;
        double movX;
        double scal;
        this.updateWalkedOnStep(entity);
        float distanceReference = (float)this.distanceWalkedOnStepModified;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = entity.field_70159_w) * this.xMovec + (movZ = entity.field_70179_y) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.VAR.PLAY_WANDER && !this.hasSpecialStoppingConditions(entity)) {
                this.playSinglefoot(entity, 0.0, EventType.WANDER, this.isRightFoot);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        if (entity.field_70122_E || this.isInWater || this.isOnLadder) {
            EventType event = null;
            float dwm = distanceReference - this.dmwBase;
            boolean immobile = this.stoppedImmobile(distanceReference);
            if (immobile && !this.isOnLadder) {
                dwm = 0.0f;
                this.dmwBase = distanceReference;
            }
            float distance = 0.0f;
            if (entity.func_70617_f_() && !entity.field_70122_E) {
                distance = this.VAR.STRIDE_LADDER;
            } else if (!this.isInWater && MathStuff.abs((double)(this.yPosition - entity.field_70163_u)) > 0.4) {
                if (this.yPosition < entity.field_70163_u) {
                    distance = this.VAR.STRIDE_STAIR;
                    event = this.speedDisambiguator(entity, EventType.UP, EventType.UP_RUN);
                } else if (!this.isSneaking) {
                    distance = -1.0f;
                    event = this.speedDisambiguator(entity, EventType.DOWN, EventType.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.VAR.STRIDE;
            }
            if (event == null) {
                event = this.speedDisambiguator(entity, EventType.WALK, EventType.RUN);
            }
            if (dwm > (distance = this.reevaluateDistance(event, distance))) {
                this.produceStep(entity, event, 0.0);
                this.stepped(entity, event);
                this.dmwBase = distanceReference;
            }
        }
        if (entity.field_70122_E) {
            this.yPosition = entity.field_70163_u;
        }
    }

    protected void stepped(@Nonnull EntityLivingBase entity, @Nonnull EventType event) {
    }

    protected float reevaluateDistance(@Nonnull EventType event, float distance) {
        return distance;
    }

    protected void produceStep(@Nonnull EntityLivingBase entity, @Nonnull EventType event) {
        this.produceStep(entity, event, 0.0);
    }

    protected void produceStep(@Nonnull EntityLivingBase entity, @Nullable EventType event, double verticalOffsetAsMinus) {
        if (!this.playSpecialStoppingConditions(entity)) {
            if (event == null) {
                event = this.speedDisambiguator(entity, EventType.WALK, EventType.RUN);
            }
            this.playSinglefoot(entity, verticalOffsetAsMinus, event, this.isRightFoot);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected void simulateAirborne(@Nonnull EntityLivingBase entity) {
        if ((entity.field_70122_E || this.isOnLadder) == this.isFlying) {
            this.isFlying = !this.isFlying;
            this.simulateJumpingLanding(entity);
        }
        if (this.isFlying) {
            this.fallDistance = entity.field_70143_R;
        }
    }

    protected void simulateJumpingLanding(@Nonnull EntityLivingBase entity) {
        if (this.hasSpecialStoppingConditions(entity)) {
            return;
        }
        if (this.isFlying && this.isJumping) {
            if (this.VAR.EVENT_ON_JUMP && entity.field_70181_x > 0.0) {
                this.didJump = true;
                double speed = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
                if (speed < (double)this.VAR.SPEED_TO_JUMP_AS_MULTIFOOT) {
                    this.playMultifoot(entity, 0.4, EventType.JUMP);
                } else {
                    this.playSinglefoot(entity, 0.4, EventType.JUMP, this.isRightFoot);
                }
            }
        } else if (!this.isFlying && this.fallDistance > 0.0f) {
            if (this.fallDistance > this.VAR.LAND_HARD_DISTANCE_MIN) {
                this.playMultifoot(entity, 0.0, EventType.LAND);
            } else if (!this.stepThisFrame && !this.isSneaking) {
                this.playSinglefoot(entity, 0.0, this.speedDisambiguator(entity, EventType.CLIMB, EventType.CLIMB_RUN), this.isRightFoot);
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    protected EventType speedDisambiguator(@Nonnull EntityLivingBase entity, @Nonnull EventType walk, @Nonnull EventType run) {
        double velocity = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
        return velocity > (double)this.VAR.SPEED_TO_RUN ? run : walk;
    }

    protected void simulateBrushes(@Nonnull EntityLivingBase entity) {
        long current = TimeUtils.currentTimeMillis();
        if (current >= this.brushesTime) {
            int yy;
            BlockPos pos;
            this.brushesTime = current + 100L;
            if (this.proceedWithStep(entity) && (entity.field_70159_w != 0.0 || entity.field_70179_y != 0.0) && !this.messyPos.equals((Object)(pos = new BlockPos(entity.field_70165_t, (double)(yy = MathStuff.floor((double)(entity.field_70163_u - 0.0625 - entity.func_70033_W() - (entity.field_70122_E ? 0.0 : 0.25)))), entity.field_70161_v)))) {
                this.messyPos = pos;
                Association assos = this.findAssociationMessyFoliage(entity, pos);
                if (assos != null) {
                    this.playAssociation(assos, EventType.WALK);
                }
            }
        }
    }

    protected boolean proceedWithStep(@Nonnull EntityLivingBase entity) {
        return !this.isSneaking;
    }

    protected void playSinglefoot(@Nonnull EntityLivingBase entity, double verticalOffsetAsMinus, @Nonnull EventType eventType, boolean foot) {
        if (this.proceedWithStep(entity)) {
            Association assos = this.findAssociation(entity, verticalOffsetAsMinus, foot);
            this.playAssociation(assos, eventType);
        }
    }

    protected void playMultifoot(@Nonnull EntityLivingBase entity, double verticalOffsetAsMinus, EventType eventType) {
        if (this.proceedWithStep(entity)) {
            Association leftFoot = this.findAssociation(entity, verticalOffsetAsMinus, false);
            Association rightFoot = this.findAssociation(entity, verticalOffsetAsMinus, true);
            this.playAssociation(leftFoot, eventType);
            this.playAssociation(rightFoot, eventType);
        }
    }

    protected void playAssociation(@Nullable Association assos, @Nonnull EventType eventType) {
        if (assos != null && !assos.isNotEmitter()) {
            this.soundPlayer.playAcoustic(assos, eventType);
        }
    }

    protected boolean shouldProducePrint(@Nonnull EntityLivingBase entity) {
        return ModOptions.effects.enableFootprints && this.VAR.HAS_FOOTPRINT && (entity.field_70122_E || !this.isJumping && !entity.field_70160_al) && !entity.func_98034_c(EnvironStateHandler.EnvironState.getPlayer());
    }

    @Nullable
    protected Association findAssociation(@Nonnull EntityLivingBase entity, double verticalOffsetAsMinus, boolean isRightFoot) {
        Vec3d printPos;
        float rotDegrees = MathStuff.wrapDegrees((float)entity.field_70177_z);
        double rot = MathStuff.toRadians((float)rotDegrees);
        float feetDistanceToCenter = isRightFoot ? -this.VAR.DISTANCE_TO_CENTER : this.VAR.DISTANCE_TO_CENTER;
        double xx = entity.field_70165_t + MathStuff.cos((double)rot) * (double)feetDistanceToCenter;
        double zz = entity.field_70161_v + MathStuff.sin((double)rot) * (double)feetDistanceToCenter;
        double minY = entity.func_174813_aQ().field_72338_b;
        FootStrikeLocation loc = new FootStrikeLocation(entity, xx, minY - 0.0625 - verticalOffsetAsMinus, zz);
        AcousticResolver resolver = new AcousticResolver((IBlockAccess)ClientChunkCache.instance(), this.blockMap, loc, this.VAR.DISTANCE_TO_CENTER);
        Association result = this.addSoundOverlay(entity, resolver.findAssociationForEvent());
        if (result != null && result.hasStrikeLocation() && this.shouldProducePrint(entity) && (printPos = result.getStrikeLocation().footprintPosition()) != null) {
            FootprintStyle style = this.VAR.FOOTPRINT_STYLE;
            if (entity instanceof EntityPlayer) {
                style = FootprintStyle.getStyle(ModOptions.effects.footprintStyle);
            }
            Footprint print = Footprint.produce(style, entity, printPos, rotDegrees, this.VAR.FOOTPRINT_SCALE, isRightFoot);
            this.footprints.add((Object)print);
        }
        return result;
    }

    protected boolean playSpecialStoppingConditions(@Nonnull EntityLivingBase entity) {
        if (entity.func_70090_H()) {
            if (this.proceedWithStep(entity)) {
                float volume = (float)MathStuff.sqrt((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y)) * 1.25f;
                ConfigOptions options = new ConfigOptions();
                options.setGlidingVolume(volume > 1.0f ? 1.0f : volume);
                this.soundPlayer.playAcoustic(entity.func_174791_d(), RegistryManager.FOOTSTEPS.SWIM, entity.func_70055_a(Material.field_151586_h) ? EventType.SWIM : EventType.WALK, options);
            }
            return true;
        }
        return false;
    }

    protected boolean hasSpecialStoppingConditions(@Nonnull EntityLivingBase entity) {
        return entity.func_70090_H();
    }

    @Nullable
    protected Association findAssociationMessyFoliage(@Nonnull EntityLivingBase entity, @Nonnull BlockPos pos) {
        IAcoustic[] acoustics;
        Association result = null;
        BlockPos up = pos.func_177984_a();
        IBlockState above = ClientChunkCache.instance().func_180495_p(up);
        if (above != Blocks.field_150350_a.func_176223_P() && (acoustics = this.blockMap.getBlockAcoustics(above, Substrate.MESSY)) == AcousticRegistry.MESSY_GROUND && (acoustics = this.blockMap.getBlockAcoustics(above, Substrate.FOLIAGE)) != null && acoustics != AcousticRegistry.NOT_EMITTER) {
            result = new Association(entity, acoustics);
        }
        return result;
    }

    @Nullable
    protected Association addSoundOverlay(@Nonnull EntityLivingBase entity, @Nullable Association assoc) {
        if (entity.field_70122_E) {
            accents.clear();
            BlockPos pos = assoc != null ? assoc.getStepPos() : null;
            FootstepAccents.provide(entity, pos, accents);
            if (accents.size() > 0) {
                if (assoc == null) {
                    assoc = new Association(entity, (IAcoustic[])accents.toArray((Object[])new IAcoustic[0]));
                } else {
                    assoc.add((Collection<? extends IAcoustic>)accents);
                }
            }
        }
        return assoc;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("didJump: ").append(Boolean.toString(this.didJump)).append(' ');
        builder.append("onLadder: ").append(Boolean.toString(this.isOnLadder)).append(' ');
        builder.append("flying: ").append(Boolean.toString(this.isFlying)).append(' ');
        builder.append("immobile: ").append(Boolean.toString(this.isImmobile)).append(' ');
        builder.append("steps: ").append(this.pedometer);
        return builder.toString();
    }
}

