/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps.facade;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.footsteps.facade.ChiselFacadeAccessor;
import org.orecruncher.dsurround.client.footsteps.facade.CoFHCoreCoverAccessor;
import org.orecruncher.dsurround.client.footsteps.facade.ConnectedTexturesAccessor;
import org.orecruncher.dsurround.client.footsteps.facade.EnderIOFacadeAccessor;
import org.orecruncher.dsurround.client.footsteps.facade.ForgeMultiPartCBE;
import org.orecruncher.dsurround.client.footsteps.facade.IFacadeAccessor;
import org.orecruncher.dsurround.client.footsteps.facade.LittleTilesAccessor;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;

@SideOnly(value=Side.CLIENT)
public final class FacadeHelper {
    private static final Map<Block, IFacadeAccessor> crackers = new Reference2ObjectOpenHashMap();

    private static void addAccessor(@Nonnull List<IFacadeAccessor> accessors, @Nonnull IFacadeAccessor accessor) {
        if (accessor.isValid()) {
            ModBase.log().info("Facade Accessor: %s", new Object[]{accessor.getName()});
            accessors.add(accessor);
        }
    }

    protected FacadeHelper() {
    }

    @Nonnull
    public static IBlockState resolveState(@Nonnull EntityLivingBase entity, @Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull Vec3d pos, @Nullable EnumFacing side) {
        IBlockState newState;
        IFacadeAccessor accessor;
        if (crackers.size() > 0 && state != Blocks.field_150350_a.func_176223_P() && (accessor = crackers.get(state.func_177230_c())) != null && (newState = accessor.getBlockState(entity, state, world, pos, side)) != null) {
            return newState;
        }
        return state;
    }

    static {
        ArrayList<IFacadeAccessor> accessors = new ArrayList<IFacadeAccessor>();
        if (ModEnvironment.LittleTiles.isLoaded()) {
            FacadeHelper.addAccessor(accessors, new LittleTilesAccessor());
        }
        if (ModEnvironment.ForgeMultipartCBE.isLoaded()) {
            FacadeHelper.addAccessor(accessors, new ForgeMultiPartCBE());
        }
        if (ModEnvironment.ConnectedTextures.isLoaded()) {
            FacadeHelper.addAccessor(accessors, new ConnectedTexturesAccessor());
        }
        FacadeHelper.addAccessor(accessors, new EnderIOFacadeAccessor());
        FacadeHelper.addAccessor(accessors, new CoFHCoreCoverAccessor());
        FacadeHelper.addAccessor(accessors, new ChiselFacadeAccessor());
        if (accessors.size() > 0) {
            block0: for (Block b : Block.field_149771_c) {
                for (int i = 0; i < accessors.size(); ++i) {
                    IFacadeAccessor accessor = (IFacadeAccessor)accessors.get(i);
                    if (!accessor.instanceOf(b)) continue;
                    crackers.put(b, accessor);
                    continue block0;
                }
            }
        }
    }
}

