/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.lib.OutOfBandTimerEMA;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.math.TimerEMA;

@SideOnly(value=Side.CLIENT)
public class DiagnosticHandler
extends EffectHandlerBase {
    private List<String> diagnostics;
    private List<String> timings;
    private List<String> serverDataReport = ImmutableList.of();
    private final List<TimerEMA> timers = new ArrayList<TimerEMA>();
    private final TimerEMA clientTick = new TimerEMA("Client Tick");
    private final TimerEMA lastTick = new TimerEMA("Last Tick");
    private long timeMark;
    private long lastTickMark = -1L;
    private float tps = 0.0f;
    private TimerEMA processingTimer;
    private TimerEMA diagnosticTimer;

    public DiagnosticHandler() {
        super("Diagnostics");
    }

    public void addTimer(@Nonnull TimerEMA timer) {
        this.timers.add(timer);
        if ("Processing".equals(timer.name())) {
            this.processingTimer = timer;
        } else if ("Diagnostics".equals(timer.name())) {
            this.diagnosticTimer = timer;
        }
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            this.diagnostics = new ArrayList<String>();
            this.timings = new ArrayList<String>();
            if (ModBase.isDeveloperMode()) {
                this.diagnostics.add(TextFormatting.RED + "DEVELOPER MODE ENABLED");
            }
            if (ModOptions.logging.enableDebugLogging) {
                DiagnosticEvent.Gather gather = new DiagnosticEvent.Gather(player2.func_130014_f_(), player2);
                MinecraftForge.EVENT_BUS.post((Event)gather);
                this.diagnostics.add("");
                this.diagnostics.addAll(gather.output);
                double adjusted = this.processingTimer.getMSecs() - this.diagnosticTimer.getMSecs();
                this.timings.add("");
                this.timings.add(TextFormatting.LIGHT_PURPLE + this.clientTick.toString());
                this.timings.add(TextFormatting.LIGHT_PURPLE + this.lastTick.toString());
                this.timings.add(TextFormatting.LIGHT_PURPLE + String.format("TPS:%7.3fms", Float.valueOf(this.tps)));
                for (TimerEMA timer : this.timers) {
                    boolean oob = timer instanceof OutOfBandTimerEMA;
                    this.timings.add((oob ? TextFormatting.GRAY : TextFormatting.AQUA) + timer.toString());
                    if (!oob) continue;
                    adjusted += timer.getMSecs();
                }
                String txt = String.format(TextFormatting.YELLOW + "%s:%7.3fms", "Impact", adjusted);
                this.timings.add(txt);
            }
            if (this.serverDataReport != null && !this.serverDataReport.isEmpty()) {
                this.timings.add("");
                this.timings.addAll(this.serverDataReport);
            }
        } else {
            this.diagnostics = null;
            this.timings = null;
        }
    }

    @Override
    public void onConnect() {
        this.diagnostics = null;
        this.serverDataReport = null;
    }

    @Override
    public void onDisconnect() {
        this.diagnostics = null;
        this.serverDataReport = null;
        this.timers.clear();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tickStart(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.timeMark = System.nanoTime();
            if (this.lastTickMark != -1L) {
                this.lastTick.update((double)(this.timeMark - this.lastTickMark));
                this.tps = MathStuff.clamp((float)((float)(50.0 / this.lastTick.getMSecs() * 20.0)), (float)0.0f, (float)20.0f);
            }
            this.lastTickMark = this.timeMark;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void worldLoad(@Nonnull WorldEvent.Load event) {
        if (ModOptions.logging.enableDebugLogging && event.getWorld() instanceof WorldClient) {
            IRenderHandler handler = event.getWorld().field_73011_w.getWeatherRenderer();
            ModBase.log().debug("World class     : %s", new Object[]{event.getWorld().getClass().getName()});
            ModBase.log().debug("World Provider  : %s", new Object[]{event.getWorld().field_73011_w.getClass().getName()});
            ModBase.log().debug("Weather Renderer: %s", new Object[]{handler != null ? handler.getClass().getName() : "VANILLA"});
            ModBase.log().debug("Entity Renderer : %s", new Object[]{Minecraft.func_71410_x().field_71460_t.getClass().getName()});
            ModBase.log().debug("Particle Manager: %s", new Object[]{Minecraft.func_71410_x().field_71452_i.getClass().getName()});
            ModBase.log().debug("Music Ticker    : %s", new Object[]{Minecraft.func_71410_x().func_181535_r().getClass().getName()});
            ModBase.log().debug("Sound Manager   : %s", new Object[]{SoundEngine.instance().getSoundManager().getClass().getName()});
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEnd(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.clientTick.update((double)(System.nanoTime() - this.timeMark));
        }
    }

    @SubscribeEvent
    public void onGatherText(@Nonnull RenderGameOverlayEvent.Text event) {
        if (this.diagnostics != null && !this.diagnostics.isEmpty()) {
            event.getLeft().addAll(this.diagnostics);
        }
        if (this.timings != null && !this.timings.isEmpty()) {
            event.getRight().addAll(this.timings);
        }
    }

    public void setServerTPSReport(@Nonnull List<String> report) {
        this.serverDataReport = report;
    }
}

