/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.network;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.network.Locus;
import org.orecruncher.dsurround.network.PacketEntityData;
import org.orecruncher.dsurround.network.PacketEnvironment;
import org.orecruncher.dsurround.network.PacketServerData;
import org.orecruncher.dsurround.network.PacketSpeechBubble;
import org.orecruncher.dsurround.network.PacketThunder;
import org.orecruncher.dsurround.network.PacketWeatherUpdate;
import org.orecruncher.lib.ReflectedField;
import org.orecruncher.lib.collections.EmptyList;
import org.orecruncher.lib.task.Scheduler;

@Mod.EventBusSubscriber(modid="dsurround")
public final class Network {
    private static final ReflectedField.ObjectField<NetworkDispatcher, EntityPlayerMP> player = new ReflectedField.ObjectField(NetworkDispatcher.class, "player", null);
    private static final ObjectOpenHashSet<UUID> blockList = new ObjectOpenHashSet();
    private static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("dsurround");

    public static void initialize() {
        int discriminator = 0;
        NETWORK.registerMessage(PacketWeatherUpdate.PacketHandler.class, PacketWeatherUpdate.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketSpeechBubble.PacketHandler.class, PacketSpeechBubble.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketEntityData.PacketHandler.class, PacketEntityData.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketThunder.PacketHandler.class, PacketThunder.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketEnvironment.PacketHandler.class, PacketEnvironment.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketServerData.PacketHandler.class, PacketServerData.class, ++discriminator, Side.CLIENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void clientConnect(@Nonnull FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        block10: {
            NetworkDispatcher dispatcher = NetworkDispatcher.get((NetworkManager)event.getManager());
            if (dispatcher != null) {
                try {
                    EntityPlayerMP p = (EntityPlayerMP)player.get((Object)dispatcher);
                    String version = (String)dispatcher.getModList().get("dsurround");
                    if (StringUtils.isEmpty((CharSequence)version)) {
                        ObjectOpenHashSet<UUID> objectOpenHashSet = blockList;
                        synchronized (objectOpenHashSet) {
                            blockList.add((Object)p.getPersistentID());
                        }
                        ModBase.log().info("Player [%s] connected without having %s installed", new Object[]{p.getDisplayNameString(), "Dynamic Surroundings"});
                        break block10;
                    }
                    ObjectOpenHashSet<UUID> objectOpenHashSet = blockList;
                    synchronized (objectOpenHashSet) {
                        blockList.remove((Object)p.getPersistentID());
                    }
                    ModBase.log().info("Player [%s] connected with %s %s", new Object[]{p.getDisplayNameString(), "Dynamic Surroundings", version});
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void clientDisconnect(@Nonnull FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        NetworkDispatcher dispatcher = NetworkDispatcher.get((NetworkManager)event.getManager());
        if (dispatcher != null) {
            try {
                EntityPlayerMP p = (EntityPlayerMP)player.get((Object)dispatcher);
                ObjectOpenHashSet<UUID> objectOpenHashSet = blockList;
                synchronized (objectOpenHashSet) {
                    blockList.remove((Object)p.getPersistentID());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void clientDisconnect(@Nonnull PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            ObjectOpenHashSet<UUID> objectOpenHashSet = blockList;
            synchronized (objectOpenHashSet) {
                blockList.remove((Object)event.player.getPersistentID());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static void postEvent(@Nonnull Event event) {
        Network.postEvent(Side.CLIENT, event);
    }

    private static void postEvent(@Nonnull Side side, @Nonnull Event event) {
        Scheduler.schedule((Side)side, () -> MinecraftForge.EVENT_BUS.post(event));
    }

    static void postEventServer(@Nonnull Event event) {
        Network.postEvent(Side.SERVER, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendToList(@Nonnull List<EntityPlayerMP> players, @Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            players.forEach(p -> NETWORK.sendTo(msg, p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends EntityPlayer> List<EntityPlayerMP> generateStream(@Nonnull Collection<T> c, Predicate<T> pred) {
        Stream<EntityPlayer> strm = c.stream().filter(p -> !(p instanceof FakePlayer)).filter(p -> !blockList.contains((Object)p.getPersistentID()));
        if (pred != null) {
            strm = strm.filter(pred);
        }
        try {
            ObjectOpenHashSet<UUID> objectOpenHashSet = blockList;
            synchronized (objectOpenHashSet) {
                return strm.map(p -> (EntityPlayerMP)p).collect(Collectors.toList());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return EmptyList.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToPlayer(@Nonnull EntityPlayerMP player2, @Nonnull IMessage msg) {
        try {
            SimpleNetworkWrapper simpleNetworkWrapper = blockList;
            synchronized (simpleNetworkWrapper) {
                if (blockList.contains((Object)player2.getPersistentID())) {
                    return;
                }
            }
            simpleNetworkWrapper = NETWORK;
            synchronized (simpleNetworkWrapper) {
                NETWORK.sendTo(msg, player2);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void sendToEntityViewers(@Nonnull Entity entity, @Nonnull IMessage msg) {
        Set players = ((WorldServer)entity.func_130014_f_()).func_73039_n().getTrackingPlayers(entity);
        List<EntityPlayerMP> list = Network.generateStream(players, null);
        Network.sendToList(list, msg);
    }

    public static void sendToDimension(int dimensionId, @Nonnull IMessage msg) {
        WorldServer world = DimensionManager.getWorld((int)dimensionId);
        if (world != null) {
            List<EntityPlayerMP> players = Network.generateStream(DimensionManager.getWorld((int)dimensionId).field_73010_i, null);
            Network.sendToList(players, msg);
        }
    }

    public static void sendToAll(@Nonnull IMessage msg) {
        List<EntityPlayerMP> players = Network.generateStream(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v(), null);
        Network.sendToList(players, msg);
    }

    public static void sendToAllAround(@Nonnull Locus point, @Nonnull IMessage msg) {
        WorldServer world = DimensionManager.getWorld((int)point.dimension);
        if (world != null) {
            double rSq = point.range * point.range;
            List<EntityPlayerMP> players = Network.generateStream(DimensionManager.getWorld((int)point.dimension).field_73010_i, p -> p.func_70092_e(point.x, point.y, point.z) <= rSq);
            Network.sendToList(players, msg);
        }
    }
}

