/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;

public class BetterVanillaTextures
extends Feature {
    private static final String OVERRIDES_JSON_FILE = "/assets/quark/overrides.json";
    private static final Gson GSON = new Gson();
    public static OverrideHolder overrides = null;

    @Override
    public void setupConfig() {
        if (overrides == null) {
            InputStreamReader reader = new InputStreamReader(Quark.class.getResourceAsStream(OVERRIDES_JSON_FILE));
            overrides = (OverrideHolder)GSON.fromJson((Reader)reader, OverrideHolder.class);
        }
        for (OverrideEntry e : BetterVanillaTextures.overrides.overrides) {
            e.configVal = this.loadPropBool("Enable " + e.name, "", !e.disabled);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        BetterVanillaTextures.overrides.overrides.forEach(OverrideEntry::apply);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    private static class OverrideEntry {
        public String name;
        public String[] files;
        public boolean disabled;
        public boolean configVal;

        private OverrideEntry() {
        }

        void apply() {
            if (this.configVal) {
                for (String file : this.files) {
                    String[] tokens = file.split("//");
                    Quark.proxy.addResourceOverride(tokens[0], tokens[1]);
                }
            }
        }
    }

    private static class OverrideHolder {
        public List<OverrideEntry> overrides;

        private OverrideHolder() {
        }
    }
}

