/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.emoji.Models;
import net.teamfruit.emojicord.util.DataUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.util.EntityUtils;

public class CallbackServerInstance
implements AutoCloseable {
    private Consumer<Models.EmojiDiscordList> consumer;
    private Predicate<String> keyChecker;
    private final ExecutorService listenerExecutor;
    private final ExecutorService workerExecutor;
    private ServerSocket serversocket;

    public CallbackServerInstance(Consumer<Models.EmojiDiscordList> consumer, Predicate<String> keyChecker) throws IOException {
        this(consumer, keyChecker, 0);
    }

    public CallbackServerInstance(Consumer<Models.EmojiDiscordList> consumer, Predicate<String> keyChecker, int port) throws IOException {
        this.consumer = consumer;
        this.keyChecker = keyChecker;
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("emojicord-web-listener-%d").build());
        this.workerExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("emojicord-web-worker-%d").build());
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("Emojicord/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build();
        UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
        reqistry.register("*", (HttpRequestHandler)new HttpCallbackHandler());
        HttpService httpService = new HttpService(httpproc, (HttpRequestHandlerMapper)reqistry);
        DefaultBHttpServerConnectionFactory connFactory = DefaultBHttpServerConnectionFactory.INSTANCE;
        this.serversocket = new ServerSocket(port, 0, InetAddress.getByName(null));
        this.listenerExecutor.submit(() -> this.lambda$new$1((HttpConnectionFactory)connFactory, httpService));
    }

    public int getPort() {
        return this.serversocket.getLocalPort();
    }

    @Override
    public void close() {
        this.listenerExecutor.shutdownNow();
        this.workerExecutor.shutdownNow();
        IOUtils.closeQuietly((ServerSocket)this.serversocket);
    }

    public static void main(String[] args) throws IOException {
        new CallbackServerInstance(e -> {}, e -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$new$1(HttpConnectionFactory connFactory, HttpService httpService) {
        Log.log.info("Emojicord Web Listener on port " + this.serversocket.getLocalPort());
        try {
            while (!Thread.interrupted()) {
                try {
                    Socket socket = this.serversocket.accept();
                    HttpServerConnection conn = (HttpServerConnection)connFactory.createConnection(socket);
                    Log.log.info("Incoming connection from " + socket.getInetAddress());
                    this.workerExecutor.submit(() -> {
                        BasicHttpContext context = new BasicHttpContext(null);
                        try {
                            while (!Thread.interrupted() && conn.isOpen()) {
                                httpService.handleRequest(conn, (HttpContext)context);
                            }
                        }
                        catch (ConnectionClosedException ex) {
                            Log.log.info("Client closed connection");
                        }
                        catch (IOException ex) {
                            Log.log.error("IO error: " + ex.getMessage());
                        }
                        catch (HttpException ex) {
                            Log.log.error("Unrecoverable HTTP protocol violation: " + ex.getMessage());
                        }
                        finally {
                            try {
                                conn.shutdown();
                            }
                            catch (IOException ex) {}
                        }
                    });
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (IOException e) {
                    Log.log.error("IO error initialising connection thread: ", (Throwable)e);
                    break;
                }
            }
        }
        finally {
            IOUtils.closeQuietly((ServerSocket)this.serversocket);
        }
        Log.log.info("Emojicord Web Listener closed");
    }

    private class HttpCallbackHandler
    implements HttpRequestHandler {
        private HttpCallbackHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String[] split;
            response.addHeader((Header)new BasicHeader("Access-Control-Allow-Origin", "https://emojicord.teamfruit.net"));
            response.addHeader((Header)new BasicHeader("Access-Control-Allow-Methods", "POST, OPTIONS"));
            response.addHeader((Header)new BasicHeader("Access-Control-Allow-Headers", "Authorization, Content-Type"));
            response.addHeader((Header)new BasicHeader("Access-Control-Max-Age", "86400"));
            response.addHeader((Header)new BasicHeader("Accept", "application/json"));
            response.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (method.equals("OPTIONS")) {
                response.setStatusCode(204);
                Log.log.debug("OPTIONS");
                return;
            }
            String target = request.getRequestLine().getUri();
            Log.log.info(String.format("URL: %s, Method: %s", target, method));
            if (!target.equals("/")) {
                response.setStatusCode(404);
                response.setEntity((HttpEntity)new StringEntity("NG\nNot Found", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Not Found");
                return;
            }
            if (method.equals("GET")) {
                response.setStatusCode(200);
                response.setEntity((HttpEntity)new StringEntity("OK", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
                Log.log.debug("GET");
                return;
            }
            boolean authorized = false;
            Header authorization = request.getFirstHeader("Authorization");
            if (authorization != null && (split = StringUtils.split((String)authorization.getValue(), (String)" ")) != null && split.length == 2 && StringUtils.equals((CharSequence)split[0], (CharSequence)"token")) {
                Log.log.debug(String.format("Key Check: %s", split[1]));
                authorized = CallbackServerInstance.this.keyChecker.test(split[1]);
            }
            if (!authorized) {
                response.setStatusCode(401);
                response.setEntity((HttpEntity)new StringEntity("NG\nInvalid Key", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Invalid Key");
                return;
            }
            if (!method.equals("POST")) {
                response.setStatusCode(405);
                response.setEntity((HttpEntity)new StringEntity("NG\nMethod Not Allowed", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Method Not Allowed");
                return;
            }
            if (!(request instanceof HttpEntityEnclosingRequest)) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("NG\nNo Request Data", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: No Request Data");
                return;
            }
            HttpEntityEnclosingRequest eRequest = (HttpEntityEnclosingRequest)request;
            HttpEntity entity = eRequest.getEntity();
            byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
            Log.log.debug(StringUtils.toEncodedString((byte[])data, (Charset)StandardCharsets.UTF_8));
            Models.EmojiDiscordList callback = DataUtils.loadStream(new ByteArrayInputStream(data), Models.EmojiDiscordList.class, "Parsing Web Callback");
            if (callback == null || StringUtils.isEmpty((CharSequence)callback.id) || StringUtils.isEmpty((CharSequence)callback.name)) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("NG\nInvalid Json", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Invalid Json");
                return;
            }
            response.setStatusCode(200);
            response.setEntity((HttpEntity)new StringEntity("OK", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            CallbackServerInstance.this.consumer.accept(callback);
        }
    }
}

