/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import java.awt.Color;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public class OpenGL {
    private static FloatBuffer buf = GLAllocation.func_74529_h((int)16);
    @Nullable
    private static ContextCapabilities capabilities;

    public static void glEnable(int attrib) {
        switch (attrib) {
            case 3008: {
                GlStateManager.func_179141_d();
                break;
            }
            case 3042: {
                GlStateManager.func_179147_l();
                break;
            }
            case 2884: {
                GlStateManager.func_179089_o();
                break;
            }
            case 2929: {
                GlStateManager.func_179126_j();
                break;
            }
            case 2912: {
                GlStateManager.func_179127_m();
                break;
            }
            case 2896: {
                GlStateManager.func_179145_e();
                break;
            }
            case 2977: {
                GlStateManager.func_179108_z();
                break;
            }
            case 32823: {
                GlStateManager.func_179088_q();
                break;
            }
            case 32826: {
                GlStateManager.func_179091_B();
                break;
            }
            case 3553: {
                GlStateManager.func_179098_w();
                break;
            }
            default: {
                GL11.glEnable((int)attrib);
            }
        }
    }

    public static void glDisable(int attrib) {
        switch (attrib) {
            case 3008: {
                GlStateManager.func_179118_c();
                break;
            }
            case 3042: {
                GlStateManager.func_179084_k();
                break;
            }
            case 2884: {
                GlStateManager.func_179129_p();
                break;
            }
            case 2929: {
                GlStateManager.func_179097_i();
                break;
            }
            case 2912: {
                GlStateManager.func_179106_n();
                break;
            }
            case 2896: {
                GlStateManager.func_179140_f();
                break;
            }
            case 2977: {
                GlStateManager.func_179133_A();
                break;
            }
            case 32823: {
                GlStateManager.func_179113_r();
                break;
            }
            case 32826: {
                GlStateManager.func_179101_C();
                break;
            }
            case 3553: {
                GlStateManager.func_179090_x();
                break;
            }
            default: {
                GL11.glDisable((int)attrib);
            }
        }
    }

    public static boolean glIsEnabled(int attrib) {
        return GL11.glIsEnabled((int)attrib);
    }

    public static boolean glEnabled(int attrib) {
        if (!OpenGL.glIsEnabled(attrib)) {
            OpenGL.glEnable(attrib);
            return true;
        }
        return false;
    }

    public static boolean glDisabled(int attrib) {
        if (OpenGL.glIsEnabled(attrib)) {
            OpenGL.glEnable(attrib);
            return true;
        }
        return false;
    }

    public static void glHint(int target, int mode) {
        GL11.glHint((int)target, (int)mode);
    }

    public static void glAlphaFunc(int func, float ref) {
        GlStateManager.func_179092_a((int)func, (float)ref);
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        GlStateManager.func_179112_b((int)sfactor, (int)dfactor);
    }

    public static void glBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        GlStateManager.func_179120_a((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    public static void glCallList(int list) {
        GlStateManager.func_179148_o((int)list);
    }

    public static void glClear(int mask) {
        GlStateManager.func_179086_m((int)mask);
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        GlStateManager.func_179082_a((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearDepth(double depth) {
        GlStateManager.func_179151_a((double)depth);
    }

    public static void glColor3f(float red, float green, float blue) {
        OpenGL.glColor4f(red, green, blue, 1.0f);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColor4i(int red, int green, int blue, int alpha) {
        OpenGL.glColor4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public static void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        OpenGL.glColor4i(red & 0xFF, green & 0xFF, blue & 0xFF, alpha & 0xFF);
    }

    public static void glColorRGB(int rgb) {
        int value = 0xFF000000 | rgb;
        OpenGL.glColor4i(value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF, value >> 24 & 0xFF);
    }

    public static void glColorRGBA(int rgba) {
        OpenGL.glColor4i(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba >> 0 & 0xFF, rgba >> 24 & 0xFF);
    }

    public static void glColor(Color color) {
        OpenGL.glColor4i(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void glColor(org.lwjgl.util.Color color) {
        OpenGL.glColor4i(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static int toColorCode(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    private static int toColorCode(float r, float g, float b, float a) {
        return OpenGL.toColorCode((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f), (int)(a * 255.0f + 0.5f));
    }

    public static int glGetColorRGBA() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = buf.get(0);
        float g = buf.get(1);
        float b = buf.get(2);
        float a = buf.get(3);
        return OpenGL.toColorCode(r, g, b, a);
    }

    public static Color glGetColor() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = Math.min(1.0f, buf.get(0));
        float g = Math.min(1.0f, buf.get(1));
        float b = Math.min(1.0f, buf.get(2));
        float a = Math.min(1.0f, buf.get(3));
        return new Color(r, g, b, a);
    }

    public static org.lwjgl.util.Color glGetLwjglColor() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = buf.get(0);
        float g = buf.get(1);
        float b = buf.get(2);
        float a = buf.get(3);
        return new org.lwjgl.util.Color((int)((double)(r * 255.0f) + 0.5) & 0xFF, (int)((double)(g * 255.0f) + 0.5) & 0xFF, (int)((double)(b * 255.0f) + 0.5) & 0xFF, (int)((double)(a * 255.0f) + 0.5) & 0xFF);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GlStateManager.func_179135_a((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void glColorMaterial(int face, int mode) {
        GlStateManager.func_179104_a((int)face, (int)mode);
    }

    public static void glCullFace(int mode) {
        if (mode == GlStateManager.CullFace.BACK.field_187328_d) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        } else if (mode == GlStateManager.CullFace.FRONT.field_187328_d) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        } else if (mode == GlStateManager.CullFace.FRONT_AND_BACK.field_187328_d) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT_AND_BACK);
        }
    }

    public static void glDepthFunc(int func) {
        GlStateManager.func_179143_c((int)func);
    }

    public static void glDepthMask(boolean flag) {
        GlStateManager.func_179132_a((boolean)flag);
    }

    public static void glGetFloat(int pname, FloatBuffer params) {
        GlStateManager.func_179111_a((int)pname, (FloatBuffer)params);
    }

    public static void glLoadIdentity() {
        GlStateManager.func_179096_D();
    }

    public static void glLogicOp(int opcode) {
        GlStateManager.func_179116_f((int)opcode);
    }

    public static void glMatrixMode(int mode) {
        GlStateManager.func_179128_n((int)mode);
    }

    public static void glMultMatrix(FloatBuffer m) {
        GlStateManager.func_179110_a((FloatBuffer)m);
    }

    public static void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        GlStateManager.func_179130_a((double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar);
    }

    public static void glPolygonOffset(float factor, float units) {
        GlStateManager.func_179136_a((float)factor, (float)units);
    }

    public static void glPopAttrib() {
        GlStateManager.func_179099_b();
    }

    public static void glPopMatrix() {
        GlStateManager.func_179121_F();
    }

    public static void glPushAttrib() {
        GlStateManager.func_179123_a();
    }

    public static void glPushMatrix() {
        GlStateManager.func_179094_E();
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        GlStateManager.func_179114_b((float)angle, (float)x, (float)y, (float)z);
    }

    public static void glScaled(double x, double y, double z) {
        GlStateManager.func_179139_a((double)x, (double)y, (double)z);
    }

    public static void glScalef(float x, float y, float z) {
        GlStateManager.func_179152_a((float)x, (float)y, (float)z);
    }

    public static void glSetActiveTextureUnit(int texture) {
        GlStateManager.func_179138_g((int)texture);
    }

    public static void glShadeModel(int mode) {
        GlStateManager.func_179103_j((int)mode);
    }

    public static void glTranslated(double x, double y, double z) {
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    public static void glTranslatef(float x, float y, float z) {
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
    }

    public static void glViewport(int x, int y, int width, int height) {
        GlStateManager.func_179083_b((int)x, (int)y, (int)width, (int)height);
    }

    public static void glBegin(int mode) {
        GL11.glBegin((int)mode);
    }

    public static void glEnd() {
        GL11.glEnd();
    }

    public static int glGenTextures() {
        return GlStateManager.func_179146_y();
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
    }

    public static int glGetTexParameteri(int target, int pname) {
        return GL11.glGetTexParameteri((int)target, (int)pname);
    }

    public static void glNormal3f(float nx, float ny, float nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public static void glPushAttrib(int mask) {
        GL11.glPushAttrib((int)mask);
    }

    public static void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GL11.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public static void glTexCoord2f(float sCoord, float tCoord) {
        GlStateManager.func_187426_b((float)sCoord, (float)tCoord);
    }

    public static void glVertex2f(float x, float y) {
        GL11.glVertex2f((float)x, (float)y);
    }

    public static void glVertex3f(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void glLineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public static void glStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public static void glStencilMask(int mask) {
        GL11.glStencilMask((int)mask);
    }

    public static void glStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public static boolean openGl30() {
        ContextCapabilities cap;
        if (capabilities == null) {
            capabilities = GLContext.getCapabilities();
        }
        return (cap = capabilities) != null && cap.OpenGL30;
    }

    public static void glGenerateMipmap(int target) {
        GL30.glGenerateMipmap((int)target);
    }

    public static void glBindTexture(int target, int texture) {
        if (target == 3553) {
            GlStateManager.func_179144_i((int)texture);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
    }

    public static void glDeleteTextures(int texture) {
        GlStateManager.func_179150_h((int)texture);
    }
}

