/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.collect.Queues;
import java.io.File;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.EmojiText;
import net.teamfruit.emojicord.emoji.PickerGroup;
import net.teamfruit.emojicord.emoji.PickerItem;
import net.teamfruit.emojicord.util.DataUtils;

public class EmojiFrequently {
    @Nonnull
    public static final EmojiFrequently instance = new EmojiFrequently();
    public static final int storeCount = 100;
    public static final int showCount = 40;
    private Deque<PickerItem> frequently = Queues.newArrayDeque();
    private File save;
    private boolean changed;

    public void add(PickerItem item) {
        this.frequently.addLast(item);
        if (this.frequently.size() > 100) {
            this.frequently.removeFirst();
        }
        this.changed = true;
    }

    public void use(PickerItem item) {
        this.add(item);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public PickerGroup getGroup() {
        Map<EmojiId, List<PickerItem>> group = this.frequently.stream().collect(Collectors.groupingBy(e -> e.id));
        List<PickerItem> list = group.values().stream().filter(e -> !e.isEmpty()).sorted((a, b) -> Integer.compare(b.size(), a.size())).limit(40L).map(e -> (PickerItem)e.get(0)).collect(Collectors.toList());
        return new PickerGroup("FREQUENTLY USED", list);
    }

    public void load(File dictDir) {
        this.frequently.clear();
        this.save = new File(dictDir, "history.json");
        EmojiHistoryModel model = DataUtils.loadFileIfExists(this.save, EmojiHistoryModel.class, "Emoji Frequently History");
        if (model != null && model.history != null) {
            Stream.of(model.history).flatMap(e -> {
                EmojiText emojiText = EmojiText.create(e, EnumSet.of(EmojiText.ParseFlag.ESCAPE, EmojiText.ParseFlag.ENCODE, EmojiText.ParseFlag.ENCODE_ALIAS, EmojiText.ParseFlag.ENCODE_UTF, EmojiText.ParseFlag.PARSE));
                return PickerItem.fromText(emojiText).stream();
            }).forEach(this::use);
        }
    }

    public void save() {
        if (this.save != null) {
            EmojiHistoryModel model = new EmojiHistoryModel();
            model.history = (String[])this.frequently.stream().map(e -> e.name).toArray(String[]::new);
            DataUtils.saveFile(this.save, EmojiHistoryModel.class, model, "Emoji Frequently History");
        }
    }

    public static class EmojiHistoryModel {
        public String[] history;
    }
}

