/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoundRegistry {
    private static HashMap<String, SoundEvent> lookupStringToEvent = new HashMap();

    public static void init() {
        SoundRegistry.register("env.waterfall");
        SoundRegistry.register("env.wind_calm");
        SoundRegistry.register("env.wind_calmfade");
        SoundRegistry.register("streaming.destruction");
        SoundRegistry.register("streaming.destruction_0_");
        SoundRegistry.register("streaming.destruction_1_");
        SoundRegistry.register("streaming.destruction_2_");
        SoundRegistry.register("streaming.destruction_s");
        SoundRegistry.register("streaming.destructionb");
        SoundRegistry.register("streaming.siren");
        SoundRegistry.register("streaming.wind_close");
        SoundRegistry.register("streaming.wind_close_0_");
        SoundRegistry.register("streaming.wind_close_1_");
        SoundRegistry.register("streaming.wind_close_2_");
        SoundRegistry.register("streaming.wind_far");
        SoundRegistry.register("streaming.wind_far_0_");
        SoundRegistry.register("streaming.wind_far_1_");
        SoundRegistry.register("streaming.wind_far_2_");
        SoundRegistry.register("streaming.sandstorm_high1");
        SoundRegistry.register("streaming.sandstorm_med1");
        SoundRegistry.register("streaming.sandstorm_med2");
        SoundRegistry.register("streaming.sandstorm_low1");
        SoundRegistry.register("streaming.sandstorm_low2");
        SoundRegistry.register("streaming.siren_sandstorm_1");
        SoundRegistry.register("streaming.siren_sandstorm_2");
        SoundRegistry.register("streaming.siren_sandstorm_3");
        SoundRegistry.register("streaming.siren_sandstorm_4");
        SoundRegistry.register("streaming.siren_sandstorm_5_extra");
        SoundRegistry.register("streaming.siren_sandstorm_6_extra");
    }

    public static void register(String soundPath) {
        ResourceLocation resLoc = new ResourceLocation("weather2", soundPath);
        SoundEvent event = (SoundEvent)new SoundEvent(resLoc).setRegistryName(resLoc);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        if (lookupStringToEvent.containsKey(soundPath)) {
            System.out.println("WEATHER SOUNDS WARNING: duplicate sound registration for " + soundPath);
        }
        lookupStringToEvent.put(soundPath, event);
    }

    public static SoundEvent get(String soundPath) {
        return lookupStringToEvent.get(soundPath);
    }
}

