/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import CoroUtil.util.CoroUtilFile;
import java.util.ArrayList;
import java.util.List;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import weather2.CommandWeather2;
import weather2.CommonProxy;
import weather2.EventHandlerFML;
import weather2.EventHandlerForge;
import weather2.EventHandlerPacket;
import weather2.ServerTickHandler;
import weather2.config.ConfigFoliage;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigSand;
import weather2.config.ConfigSnow;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.config.ConfigWind;
import weather2.player.PlayerData;
import weather2.util.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerServer;

@Mod(modid="weather2", name="weather2", version="1.12.1-2.6.12", dependencies="required-after:coroutil@[1.12.1-1.2.12,)", acceptedMinecraftVersions="[1.12.1]")
public class Weather {
    @Mod.Instance(value="weather2")
    public static Weather instance;
    public static final String modID = "weather2";
    public static final String version = "1.12.1-2.6.12";
    @SidedProxy(clientSide="weather2.ClientProxy", serverSide="weather2.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForWorld;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;
    public static List<IConfigCategory> listConfigs;
    public static ConfigMisc configMisc;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        eventChannel.register((Object)new EventHandlerPacket());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerFML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        configMisc = new ConfigMisc();
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(configMisc));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigWind()));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigSand()));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigSnow()));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigStorm()));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigTornado()));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigParticle()));
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (IConfigCategory)Weather.addConfig(new ConfigFoliage()));
        WeatherUtilConfig.nbtLoadDataAll();
        proxy.preInit();
    }

    public static IConfigCategory addConfig(IConfigCategory config) {
        listConfigs.add(config);
        return config;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        EventHandlerFML.extraGrassLast = ConfigFoliage.extraGrass;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWeather2());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        Weather.writeOutData(true);
        Weather.resetStates();
        initProperNeededForWorld = true;
    }

    public static void initTry() {
        if (initProperNeededForWorld) {
            System.out.println("Weather2: being reinitialized");
            initProperNeededForWorld = false;
            CoroUtilFile.getWorldFolderName();
            ServerTickHandler.initialize();
        }
    }

    public static void resetStates() {
        ServerTickHandler.reset();
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(0);
            if (wm != null) {
                wm.writeToFile();
            }
            PlayerData.writeAllPlayerNBT(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void handleIMCMessages(FMLInterModComms.IMCEvent event) {
    }

    public static void dbg(Object obj) {
        if (ConfigMisc.consoleDebug) {
            System.out.println(obj);
        }
    }

    public static void dbgStackTrace() {
        if (ConfigMisc.consoleDebug) {
            StackTraceElement[] arr;
            for (StackTraceElement ele : arr = Thread.currentThread().getStackTrace()) {
                System.out.println(ele.toString());
            }
        }
    }

    static {
        initProperNeededForWorld = true;
        eventChannelName = modID;
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
        listConfigs = new ArrayList<IConfigCategory>();
        configMisc = null;
    }
}

