/*
 * Decompiled with CFR 0.152.
 */
package weather2.block;

import CoroUtil.util.Vec3;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigTornado;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;

public class TileEntityWeatherMachine
extends TileEntity
implements ITickable {
    public int weatherType = 1;
    public int weatherSize = 50;
    public boolean lockStormHere = true;
    public StormObject lastTickStormObject = null;
    public long lastTickStormObjectID = -1L;

    public void cycleWeatherType(boolean reverse) {
        int maxID = 6;
        if (ConfigTornado.Storm_NoTornadosOrCyclones || ConfigMisc.Block_WeatherMachineNoTornadosOrCyclones) {
            maxID = 4;
        }
        int minID = 0;
        if (!reverse) {
            ++this.weatherType;
            if (this.weatherType > maxID) {
                this.weatherType = minID;
            }
        } else {
            --this.weatherType;
            if (this.weatherType < minID) {
                this.weatherType = maxID;
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.killStorm();
    }

    public void killStorm() {
        WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(this.field_145850_b.field_73011_w.getDimension());
        if (wm != null && this.lastTickStormObject != null) {
            wm.removeStormObject(this.lastTickStormObject.ID);
            wm.syncStormRemove(this.lastTickStormObject);
            this.lastTickStormObject = null;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.weatherType == 0) {
                if (this.lastTickStormObject != null) {
                    this.killStorm();
                }
                return;
            }
            this.weatherSize = 100;
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                StormObject obj;
                WeatherManagerServer manager;
                if (this.lastTickStormObject != null && this.lastTickStormObject.isDead) {
                    this.lastTickStormObject = null;
                }
                if (this.lastTickStormObject == null && this.lastTickStormObjectID != -1L && (manager = ServerTickHandler.lookupDimToWeatherMan.get(this.field_145850_b.field_73011_w.getDimension())) != null && (obj = manager.getStormObjectByID(this.lastTickStormObjectID)) != null) {
                    this.lastTickStormObject = obj;
                    Weather.dbg("regrabbed old storm instance by ID " + obj.ID + " for weather machine");
                }
                if (this.lastTickStormObject == null && !ConfigMisc.Aesthetic_Only_Mode && (manager = ServerTickHandler.lookupDimToWeatherMan.get(this.field_145850_b.field_73011_w.getDimension())) != null) {
                    StormObject so = new StormObject(manager);
                    so.initFirstTime();
                    so.pos = new Vec3((double)this.func_174877_v().func_177958_n(), (double)StormObject.layers.get(0).intValue(), (double)this.func_174877_v().func_177952_p());
                    so.layer = 0;
                    so.userSpawnedFor = "" + this.func_174877_v().func_177958_n() + this.func_174877_v().func_177956_o() + this.func_174877_v().func_177952_p();
                    so.naturallySpawned = false;
                    manager.addStormObject(so);
                    manager.syncStormNew(so);
                    this.lastTickStormObject = so;
                    this.lastTickStormObjectID = so.ID;
                }
            }
            if (this.lastTickStormObject != null && !this.lastTickStormObject.isDead) {
                Random rand = new Random();
                if (this.lockStormHere) {
                    this.lastTickStormObject.pos = new Vec3((double)this.func_174877_v().func_177958_n(), (double)StormObject.layers.get(0).intValue(), (double)this.func_174877_v().func_177952_p());
                    this.lastTickStormObject.motion = new Vec3(0.0, 0.0, 0.0);
                }
                this.lastTickStormObject.weatherMachineControlled = true;
                this.lastTickStormObject.size = this.weatherSize;
                this.lastTickStormObject.levelWater = 1000;
                this.lastTickStormObject.attrib_precipitation = true;
                this.lastTickStormObject.hasStormPeaked = false;
                this.lastTickStormObject.levelCurStagesIntensity = 0.9f;
                this.lastTickStormObject.levelCurIntensityStage = StormObject.STATE_NORMAL;
                this.lastTickStormObject.stormType = StormObject.TYPE_LAND;
                this.lastTickStormObject.levelTemperature = 40.0f;
                if (this.weatherType == 0) {
                    this.lastTickStormObject.levelTemperature = -40.0f;
                } else if (this.weatherType != 1) {
                    if (this.weatherType == 2) {
                        this.lastTickStormObject.stormType = StormObject.TYPE_LAND;
                        this.lastTickStormObject.levelCurIntensityStage = StormObject.STATE_THUNDER;
                    } else if (this.weatherType == 3) {
                        this.lastTickStormObject.stormType = StormObject.TYPE_LAND;
                        this.lastTickStormObject.levelCurIntensityStage = StormObject.STATE_HIGHWIND;
                    } else if (this.weatherType == 4) {
                        this.lastTickStormObject.stormType = StormObject.TYPE_LAND;
                        this.lastTickStormObject.levelCurIntensityStage = StormObject.STATE_HAIL;
                    } else if (this.weatherType == 5) {
                        this.lastTickStormObject.stormType = StormObject.TYPE_LAND;
                        this.lastTickStormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    } else if (this.weatherType == 6) {
                        this.lastTickStormObject.stormType = StormObject.TYPE_WATER;
                        this.lastTickStormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    }
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        var1.func_74768_a("weatherType", this.weatherType);
        var1.func_74772_a("lastTickStormObjectID", this.lastTickStormObjectID);
        return super.func_189515_b(var1);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.weatherType = var1.func_74762_e("weatherType");
        if (var1.func_74764_b("lastTickStormObjectID")) {
            this.lastTickStormObjectID = var1.func_74763_f("lastTickStormObjectID");
        }
    }
}

