/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.block;

import CoroUtil.util.Vec3;
import extendedrenderer.ExtendedRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import weather2.ClientProxy;
import weather2.ClientTickHandler;
import weather2.block.TileEntityWeatherForecast;
import weather2.client.SceneEnhancer;
import weather2.config.ConfigMisc;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectSandstorm;

public class TileEntityWeatherForecastRenderer
extends TileEntitySpecialRenderer {
    public void func_192841_a(TileEntity var1, double x, double y, double z, float var8, int destroyStage, float alpha) {
        EntityPlayerSP entP;
        TileEntityWeatherForecast tEnt = (TileEntityWeatherForecast)var1;
        String particleCount = ExtendedRenderer.rotEffRenderer.getStatistics();
        StormObject so = tEnt.lastTickStormObject;
        Vec3 pos = new Vec3((double)tEnt.func_174877_v().func_177958_n(), (double)tEnt.func_174877_v().func_177956_o(), (double)tEnt.func_174877_v().func_177952_p());
        String descSeverity = "";
        String descDist = "";
        String descWindAngleCloud = "Wind Angle Clouds: " + (int)WindReader.getWindAngle(var1.func_145831_w(), pos, WindReader.WindType.CLOUD);
        String descWindAngle = "Wind Angle Effect: " + (int)WindReader.getWindAngle(var1.func_145831_w(), pos, WindReader.WindType.PRIORITY);
        String descWindSpeed = "Wind Speed Effect: " + (float)((int)(WindReader.getWindSpeed(var1.func_145831_w(), pos, WindReader.WindType.PRIORITY) * 100.0f)) / 100.0f;
        String descStage = "";
        String progression = "";
        float levelWater = 0.0f;
        if (so != null) {
            descStage = "" + so.levelCurIntensityStage;
            progression = "Growing ";
            if (so.hasStormPeaked) {
                progression = "Dying ";
            }
            if (so.levelCurIntensityStage >= StormObject.STATE_STAGE5 + 1) {
                descSeverity = "????";
            } else if (so.levelCurIntensityStage >= StormObject.STATE_STAGE5) {
                descSeverity = "F5 Tornado";
                if (so.stormType == StormObject.TYPE_WATER) {
                    descSeverity = "Hurricane";
                }
            } else if (so.levelCurIntensityStage >= StormObject.STATE_STAGE4) {
                descSeverity = "F4 Tornado";
                if (so.stormType == StormObject.TYPE_WATER) {
                    descSeverity = "Tropical Cyclone Stage 4";
                }
            } else if (so.levelCurIntensityStage >= StormObject.STATE_STAGE3) {
                descSeverity = "F3 Tornado";
                if (so.stormType == StormObject.TYPE_WATER) {
                    descSeverity = "Tropical Cyclone Stage 3";
                }
            } else if (so.levelCurIntensityStage >= StormObject.STATE_STAGE2) {
                descSeverity = "F2 Tornado";
                if (so.stormType == StormObject.TYPE_WATER) {
                    descSeverity = "Tropical Cyclone Stage 2";
                }
            } else if (so.levelCurIntensityStage >= StormObject.STATE_STAGE1) {
                descSeverity = "F1 Tornado";
                if (so.stormType == StormObject.TYPE_WATER) {
                    descSeverity = "Tropical Cyclone Stage 1";
                }
            } else if (so.levelCurIntensityStage >= StormObject.STATE_FORMING) {
                descSeverity = "Sign of Tornado";
                if (so.stormType == StormObject.TYPE_WATER) {
                    descSeverity = "Sign of Tropical Cyclone";
                }
            } else if (so.levelCurIntensityStage >= StormObject.STATE_HAIL) {
                descSeverity = "Hailstorm";
            } else if (so.levelCurIntensityStage >= StormObject.STATE_HIGHWIND) {
                descSeverity = "High wind";
            } else if (so.levelCurIntensityStage >= StormObject.STATE_THUNDER) {
                descSeverity = "Thunderstorm";
            } else if (so.attrib_precipitation) {
                descSeverity = "Rainstorm";
                progression = "";
            }
            Vec3 posXZ = new Vec3((double)tEnt.func_174877_v().func_177958_n(), so.pos.yCoord, (double)tEnt.func_174877_v().func_177952_p());
            descDist = "" + (int)posXZ.distanceTo(so.pos);
            levelWater = so.levelWater;
        }
        boolean index = true;
        boolean oldMode = false;
        float yOffset = 2.5f;
        float sizeSimBoxDiameter = 2048.0f;
        float sizeRenderBoxDiameter = 3.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.1f), (float)((float)z + 0.5f));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)(-(sizeRenderBoxDiameter / 2.0f)), 0.0, -((double)(sizeRenderBoxDiameter / 2.0f))).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(-(sizeRenderBoxDiameter / 2.0f)), 0.0, (double)(sizeRenderBoxDiameter / 2.0f)).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(sizeRenderBoxDiameter / 2.0f), 0.0, (double)(sizeRenderBoxDiameter / 2.0f)).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(sizeRenderBoxDiameter / 2.0f), 0.0, -((double)(sizeRenderBoxDiameter / 2.0f))).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        float playerViewY = Minecraft.func_71410_x().func_175598_ae().field_78735_i;
        this.renderLivingLabel("\u00a76|", x, y + (double)1.2f, z, 1, 10, 10, playerViewY);
        if (ConfigMisc.radarCloudDebug && (entP = Minecraft.func_71410_x().field_71439_g) != null) {
            WeatherManagerClient wm = ClientTickHandler.weatherManager;
            float precipStr = Math.abs(SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP, true));
            boolean clientWeather2Rain = precipStr > 0.0f;
            String rainThunder = entP.field_70170_p.field_73004_o + " / " + entP.field_70170_p.field_73017_q;
            this.renderLivingLabel("\u00a7 rain/clear time: " + wm.vanillaRainTimeOnServer, x, y + (double)1.9f, z, 1, 10, 10, playerViewY);
            this.renderLivingLabel("\u00a7 client weather: " + (entP.field_70170_p.func_72896_J() ? "raining, " : (clientWeather2Rain ? "light rain" : "")) + (entP.field_70170_p.func_72911_I() ? "thundering" : ""), x, y + 2.0, z, 1, 10, 10, playerViewY);
            this.renderLivingLabel("\u00a7 server weather: " + (wm.isVanillaRainActiveOnServer ? "raining, " : "") + (wm.isVanillaThunderActiveOnServer ? "thundering" : ""), x, y + (double)2.1f, z, 1, 10, 10, playerViewY);
            this.renderLivingLabel("\u00a7 precip str: " + SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP), x, y + (double)2.2f, z, 1, 10, 10, playerViewY);
            this.renderLivingLabel("\u00a7 levelWater: " + levelWater, x, y + (double)2.3f, z, 1, 10, 10, playerViewY);
            this.renderLivingLabel("\u00a7 precip dist: " + descDist + ", stage: " + descStage, x, y + (double)2.4f, z, 1, 10, 10, playerViewY);
            this.renderLivingLabel("\u00a7 rainThunder: " + rainThunder, x, y + 2.5, z, 1, 10, 10, playerViewY);
        }
        for (int i = 0; i < tEnt.storms.size(); ++i) {
            WeatherObject wo = tEnt.storms.get(i);
            GlStateManager.func_179094_E();
            Vec3 posRenderOffset = new Vec3(wo.pos.xCoord - (double)tEnt.func_174877_v().func_177958_n(), 0.0, wo.pos.zCoord - (double)tEnt.func_174877_v().func_177952_p());
            posRenderOffset.xCoord /= (double)sizeSimBoxDiameter;
            posRenderOffset.zCoord /= (double)sizeSimBoxDiameter;
            posRenderOffset.xCoord *= (double)sizeRenderBoxDiameter;
            posRenderOffset.zCoord *= (double)sizeRenderBoxDiameter;
            GlStateManager.func_179137_b((double)posRenderOffset.xCoord, (double)0.0, (double)posRenderOffset.zCoord);
            if (wo instanceof StormObject) {
                StormObject storm = (StormObject)wo;
                if (storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
                    if (storm.stormType == StormObject.TYPE_WATER) {
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconCyclone);
                        this.renderLivingLabel("C" + (int)((float)storm.levelCurIntensityStage - StormObject.levelStormIntensityFormingStartVal), x, y + 1.5, z, 1, 15, 5, playerViewY);
                    } else {
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconTornado);
                        this.renderLivingLabel("F" + (int)((float)storm.levelCurIntensityStage - StormObject.levelStormIntensityFormingStartVal), x, y + 1.5, z, 1, 12, 5, playerViewY);
                    }
                } else if (storm.levelCurIntensityStage >= StormObject.STATE_HAIL) {
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconHail);
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconWind);
                } else if (storm.levelCurIntensityStage >= StormObject.STATE_HIGHWIND) {
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconLightning);
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconWind);
                } else if (storm.levelCurIntensityStage >= StormObject.STATE_THUNDER) {
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconLightning);
                } else if (storm.isPrecipitating()) {
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconRain);
                }
                String charCode = "|";
                if (ConfigMisc.radarCloudDebug) {
                    charCode = storm.levelTemperature > 0.0f ? TextFormatting.DARK_RED.toString() : TextFormatting.BLUE.toString();
                }
                if (storm.levelCurIntensityStage > StormObject.STATE_NORMAL) {
                    if (storm.hasStormPeaked) {
                        this.renderLivingLabel("\u00a74|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                    } else {
                        this.renderLivingLabel("\u00a72|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                    }
                } else if (ConfigMisc.radarCloudDebug) {
                    if (storm.isCloudlessStorm()) {
                        this.renderLivingLabel(TextFormatting.BLACK + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                    } else {
                        this.renderLivingLabel(charCode + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                    }
                } else {
                    this.renderLivingLabel(TextFormatting.WHITE + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                }
            } else if (wo instanceof WeatherObjectSandstorm) {
                this.renderIconNew(x, y + (double)1.4f, z, 16, 16, playerViewY, ClientProxy.radarIconSandstorm);
                if (((WeatherObjectSandstorm)wo).isFrontGrowing) {
                    this.renderLivingLabel("\u00a72|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                } else {
                    this.renderLivingLabel("\u00a74|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY);
                }
            }
            GlStateManager.func_179137_b((double)(-posRenderOffset.xCoord), (double)0.0, (double)(-posRenderOffset.zCoord));
            GlStateManager.func_179121_F();
        }
    }

    protected void renderLivingLabel(String par2Str, double par3, double par5, double par7, int par9, float angle) {
        this.renderLivingLabel(par2Str, par3, par5, par7, par9, 200, 80, angle);
    }

    protected void renderLivingLabel(String par2Str, double par3, double par5, double par7, int par9, int width, int height, float angle) {
        int borderSize = 2;
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        FontRenderer var11 = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        float var12 = 0.6f;
        float var13 = 0.016666668f * var12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(par3 + 0.5), (double)par5, (double)(par7 + 0.5));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-var13), (float)(-var13), (float)var13);
        GlStateManager.func_179140_f();
        if (par9 == 0) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator var14 = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = var14.func_178180_c();
            int var15 = 0;
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(-width / 2 - borderSize), (double)(-borderSize + var15), 0.0).func_181675_d();
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(-width / 2 - borderSize), (double)(height + var15), 0.0).func_181675_d();
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(width / 2 + borderSize), (double)(height + var15), 0.0).func_181675_d();
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(width / 2 + borderSize), (double)(-borderSize + var15), 0.0).func_181675_d();
            var14.func_78381_a();
        }
        GlStateManager.func_179098_w();
        var11.func_78276_b(par2Str, -width / 2 + borderSize, 0, 0xFFFFFF);
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
    }

    public void renderIconNew(double x, double y, double z, int width, int height, float angle, TextureAtlasSprite parIcon) {
        float f6 = parIcon.func_94209_e();
        float f7 = parIcon.func_94212_f();
        float f9 = parIcon.func_94206_g();
        float f8 = parIcon.func_94210_h();
        float var12 = 0.6f;
        float var13 = 0.016666668f * var12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-var13), (float)(-var13), (float)var13);
        int borderSize = 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179106_n();
        this.func_147499_a(TextureMap.field_110575_b);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        worldrenderer.func_181662_b((double)(-width / 2 - borderSize), (double)(-borderSize), 0.0).func_187315_a((double)f6, (double)f9).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b((double)(-width / 2 - borderSize), (double)height, 0.0).func_187315_a((double)f6, (double)f8).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b((double)(width / 2 + borderSize), (double)height, 0.0).func_187315_a((double)f7, (double)f8).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b((double)(width / 2 + borderSize), (double)(-borderSize), 0.0).func_187315_a((double)f7, (double)f9).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

