/*
 * Decompiled with CFR 0.152.
 */
package weather2.item;

import CoroUtil.packet.PacketHelper;
import CoroUtil.util.Vec3;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorSandstorm;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientTickHandler;
import weather2.CommonProxy;
import weather2.Weather;
import weather2.client.SceneEnhancer;
import weather2.client.entity.particle.ParticleSandstorm;
import weather2.util.WeatherUtilBlock;

public class ItemPocketSand
extends Item {
    @SideOnly(value=Side.CLIENT)
    public static ParticleBehaviorSandstorm particleBehavior;

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack itemStackIn = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d && itemStackIn.func_190916_E() > 0) {
                itemStackIn.func_190918_g(1);
            }
            int y = (int)player.func_174813_aQ().field_72338_b;
            double randSize = 20.0;
            double randAngle = player.field_70170_p.field_73012_v.nextDouble() * randSize - player.field_70170_p.field_73012_v.nextDouble() * randSize;
            WeatherUtilBlock.fillAgainstWallSmoothly(player.field_70170_p, new Vec3(player.field_70165_t, (double)y + 0.5, player.field_70161_v), player.field_70759_as + (float)randAngle, 15.0f, 2.0f, CommonProxy.blockSandLayer, 2);
            ItemPocketSand.particulateToClients(worldIn, (EntityLivingBase)player);
        } else {
            ItemPocketSand.particulate(player.field_70170_p, (EntityLivingBase)player);
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public static void particulate(World world, EntityLivingBase player) {
        if (particleBehavior == null) {
            particleBehavior = new ParticleBehaviorSandstorm(new Vec3(player.func_180425_c()));
        }
        Random rand = world.field_73012_v;
        TextureAtlasSprite sprite = ParticleRegistry.cloud256;
        double distCast = 10.0;
        double xzAdj = Math.cos(Math.toRadians(player.field_70125_A));
        double vecYCast = -Math.sin(Math.toRadians(player.field_70125_A)) * distCast;
        double vecXCast = -Math.sin(Math.toRadians(player.field_70759_as)) * distCast * xzAdj;
        double vecZCast = Math.cos(Math.toRadians(player.field_70759_as)) * distCast * xzAdj;
        BlockPos pos = new BlockPos(player.field_70165_t + vecXCast, player.field_70163_u + vecYCast, player.field_70161_v + vecZCast);
        double dist = Math.sqrt(Minecraft.func_71410_x().field_71439_g.func_174818_b(pos));
        if (Minecraft.func_71410_x().field_71439_g != player && dist < 7.0) {
            SceneEnhancer.adjustAmountTargetPocketSandOverride = 1.3f;
        }
        for (int i = 0; i < 15; ++i) {
            ParticleSandstorm part = new ParticleSandstorm(world, player.field_70165_t, player.field_70163_u + 1.5, player.field_70161_v, 0.0, 0.0, 0.0, sprite);
            particleBehavior.initParticle((EntityRotFX)part);
            double speed = 0.6f;
            double randSize = 20.0;
            double randAngle = player.field_70170_p.field_73012_v.nextDouble() * randSize - player.field_70170_p.field_73012_v.nextDouble() * randSize;
            double vecX = -Math.sin(Math.toRadians((double)player.field_70759_as + randAngle)) * speed;
            randAngle = player.field_70170_p.field_73012_v.nextDouble() * randSize - player.field_70170_p.field_73012_v.nextDouble() * randSize;
            double vecZ = Math.cos(Math.toRadians((double)player.field_70759_as + randAngle)) * speed;
            randAngle = player.field_70170_p.field_73012_v.nextDouble() * randSize - player.field_70170_p.field_73012_v.nextDouble() * randSize;
            double vecY = -Math.sin(Math.toRadians((double)player.field_70125_A + randAngle)) * speed;
            part.setMotionX(vecX * xzAdj);
            part.setMotionZ(vecZ * xzAdj);
            part.setMotionY(vecY);
            part.setFacePlayer(false);
            part.isTransparent = true;
            part.rotationYaw = rand.nextInt(360);
            part.rotationPitch = rand.nextInt(360);
            part.func_187114_a(80);
            part.setGravity(0.09f);
            part.func_82338_g(1.0f);
            float brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
            part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
            part.setScale(20.0f);
            part.aboveGroundHeight = 0.5;
            part.collisionSpeedDampen = false;
            part.bounceSpeed = 0.03;
            part.bounceSpeedAhead = 0.0;
            part.setKillOnCollide(false);
            part.windWeight = 1.0f;
            ItemPocketSand.particleBehavior.particles.add(part);
            ClientTickHandler.weatherManager.addWeatheredParticle((Particle)part);
            part.spawnAsWeatherEffect();
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            this.tickClient(stack, worldIn, entityIn, itemSlot, isSelected);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (particleBehavior == null) {
            particleBehavior = new ParticleBehaviorSandstorm(new Vec3(entityIn.func_180425_c()));
        }
        particleBehavior.tickUpdateList();
    }

    public static void particulateToClients(World world, EntityLivingBase player) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "PocketSandData");
        data.func_74778_a("command", "create");
        data.func_74778_a("playerName", player.func_70005_c_());
        Weather.eventChannel.sendToAllAround(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
    }

    @SideOnly(value=Side.CLIENT)
    public static void particulateFromServer(String username) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayer player = world.func_72924_a(username);
        if (player != null) {
            ItemPocketSand.particulate((World)world, (EntityLivingBase)player);
        }
    }
}

