/*
 * Decompiled with CFR 0.152.
 */
package weather2.player;

import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import weather2.Weather;

public class PlayerData {
    public static HashMap<String, NBTTagCompound> playerNBT = new HashMap();

    public static NBTTagCompound getPlayerNBT(String username) {
        if (!playerNBT.containsKey(username)) {
            PlayerData.tryLoadPlayerNBT(username);
        }
        return playerNBT.get(username);
    }

    public static void tryLoadPlayerNBT(String username) {
        NBTTagCompound playerData = new NBTTagCompound();
        try {
            String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "weather2" + File.separator + "PlayerData" + File.separator + username + ".dat";
            if (new File(fileURL).exists()) {
                playerData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        playerNBT.put(username, playerData);
    }

    public static void writeAllPlayerNBT(boolean resetData) {
        String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "weather2" + File.separator + "PlayerData";
        if (!new File(fileURL).exists()) {
            new File(fileURL).mkdir();
        }
        for (Map.Entry<String, NBTTagCompound> pairs : playerNBT.entrySet()) {
            PlayerData.writePlayerNBT(pairs.getKey(), pairs.getValue());
        }
        if (resetData) {
            playerNBT.clear();
        }
    }

    public static void writePlayerNBT(String username, NBTTagCompound parData) {
        String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "weather2" + File.separator + "PlayerData" + File.separator + username + ".dat";
        try {
            FileOutputStream fos = new FileOutputStream(fileURL);
            CompressedStreamTools.func_74799_a((NBTTagCompound)parData, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather.dbg("Error writing Weather2 player data for " + username);
        }
    }
}

