/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.util.Vec3;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.util.CachedNBTTagCompound;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.storm.EnumWeatherObjectType;

public class WeatherObject {
    public static long lastUsedStormID = 0L;
    public long ID;
    public boolean isDead = false;
    public int ticksSinceNoNearPlayer = 0;
    public WeatherManagerBase manager;
    public Vec3 pos = new Vec3(0.0, 0.0, 0.0);
    public Vec3 posGround = new Vec3(0.0, 0.0, 0.0);
    public Vec3 motion = new Vec3(0.0, 0.0, 0.0);
    public int size = 50;
    public int maxSize = 0;
    public EnumWeatherObjectType weatherObjectType = EnumWeatherObjectType.CLOUD;
    private CachedNBTTagCompound nbtCache;

    public WeatherObject(WeatherManagerBase parManager) {
        this.manager = parManager;
        this.nbtCache = new CachedNBTTagCompound();
    }

    public void initFirstTime() {
        this.ID = lastUsedStormID++;
    }

    public void tick() {
    }

    @SideOnly(value=Side.CLIENT)
    public void tickRender(float partialTick) {
    }

    public void reset() {
        this.setDead();
    }

    public void setDead() {
        this.isDead = true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.cleanupClient();
        }
        this.cleanup();
    }

    public void cleanup() {
        this.manager = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanupClient() {
    }

    public int getUpdateRateForNetwork() {
        return 40;
    }

    public void readFromNBT() {
    }

    public void writeToNBT() {
    }

    public void nbtSyncFromServer() {
        CachedNBTTagCompound parNBT = this.getNbtCache();
        this.ID = parNBT.getLong("ID");
        this.pos = new Vec3(parNBT.getDouble("posX"), parNBT.getDouble("posY"), parNBT.getDouble("posZ"));
        this.motion = new Vec3(parNBT.getDouble("vecX"), parNBT.getDouble("vecY"), parNBT.getDouble("vecZ"));
        this.size = parNBT.getInteger("size");
        this.maxSize = parNBT.getInteger("maxSize");
        this.weatherObjectType = EnumWeatherObjectType.get(parNBT.getInteger("weatherObjectType"));
    }

    public void nbtSyncForClient() {
        CachedNBTTagCompound nbt = this.getNbtCache();
        nbt.setDouble("posX", this.pos.xCoord);
        nbt.setDouble("posY", this.pos.yCoord);
        nbt.setDouble("posZ", this.pos.zCoord);
        nbt.setDouble("vecX", this.motion.xCoord);
        nbt.setDouble("vecY", this.motion.yCoord);
        nbt.setDouble("vecZ", this.motion.zCoord);
        nbt.setLong("ID", this.ID);
        nbt.getNewNBT().func_74772_a("ID", this.ID);
        nbt.setInteger("size", this.size);
        nbt.setInteger("maxSize", this.maxSize);
        nbt.setInteger("weatherObjectType", this.weatherObjectType.ordinal());
    }

    public CachedNBTTagCompound getNbtCache() {
        return this.nbtCache;
    }

    public void setNbtCache(CachedNBTTagCompound nbtCache) {
        this.nbtCache = nbtCache;
    }
}

